/*
 * Decompiled with CFR 0.152.
 */
package com.laidbacksloth42.placementutil.client;

import com.laidbacksloth42.placementutil.item.ModItems;
import com.laidbacksloth42.placementutil.util.Util;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(modid="placementutil", value={Dist.CLIENT})
public class AngelWandBlockPlacingMarker {
    @SubscribeEvent
    public static void onRenderWorldEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS || event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        if (!camera.m_90593_()) {
            return;
        }
        GameRenderer gameRenderer = Minecraft.m_91087_().f_91063_;
        gameRenderer.m_109111_(event.getProjectionMatrix());
        Item held = player.m_21205_().m_41720_();
        if (player.m_21206_().m_41720_() != ModItems.ANGEL_WAND.get() || !(held instanceof BlockItem)) {
            return;
        }
        BlockHitResult blockHitResult = Util.getPlayerPOVHitResult((Player)player);
        BlockPos pos = Util.getAdvancedPositionFromBlockHitResult(blockHitResult, (Player)player);
        if (pos == null) {
            return;
        }
        Block block = ((BlockItem)held).m_40614_();
        if (!(block instanceof DoorBlock) && !(block instanceof BedBlock) && player.f_19853_.m_8055_(pos).m_60734_() != block) {
            BlockState newState = Util.getPlacingBlockStateFromPlayer((Player)player, block);
            if (!newState.m_60710_((LevelReader)player.f_19853_, pos)) {
                return;
            }
            PoseStack poseStack = event.getPoseStack();
            VoxelShape voxelShape = newState.m_60808_((BlockGetter)player.f_19853_, pos);
            AngelWandBlockPlacingMarker.drawShapeOutline(poseStack, voxelShape, pos);
        }
    }

    private static void drawShapeOutline(PoseStack poseStack, VoxelShape voxelShape, BlockPos pos) {
        poseStack.m_85836_();
        GL11.glDisable((int)2929);
        float red = 0.0f;
        float green = 0.5f;
        float blue = 0.5f;
        float alpha = 0.5f;
        Vec3 cam = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_().m_82548_();
        double originX = cam.f_82479_ + (double)pos.m_123341_();
        double originY = cam.f_82480_ + (double)pos.m_123342_();
        double originZ = cam.f_82481_ + (double)pos.m_123343_();
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
        MultiBufferSource.BufferSource renderTypeBuffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer bufferIn = renderTypeBuffer.m_6299_(RenderType.m_110504_());
        voxelShape.m_83224_((x0, y0, z0, x1, y1, z1) -> {
            bufferIn.m_85982_(matrix4f, (float)(x0 + originX), (float)(y0 + originY), (float)(z0 + originZ)).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 1.0f, 1.0f, 1.0f).m_5752_();
            bufferIn.m_85982_(matrix4f, (float)(x1 + originX), (float)(y1 + originY), (float)(z1 + originZ)).m_85950_(red, green, blue, alpha).m_85977_(matrix3f, 0.0f, 0.0f, 0.0f).m_5752_();
        });
        renderTypeBuffer.m_109912_(RenderType.m_110504_());
        GL11.glEnable((int)2929);
        poseStack.m_85849_();
    }
}

