/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.component.callback;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import me.lib720.caprica.vlcj.player.component.callback.CallbackImagePainter;

public class ScaledCallbackImagePainter
implements CallbackImagePainter {
    @Override
    public void prepare(Graphics2D g2, JComponent component) {
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    @Override
    public void paint(Graphics2D g2, JComponent component, BufferedImage image) {
        int width = component.getWidth();
        int height = component.getHeight();
        g2.setColor(component.getBackground());
        g2.fillRect(0, 0, width, height);
        if (image != null) {
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            float sx = (float)width / (float)imageWidth;
            float sy = (float)height / (float)imageHeight;
            float sf = Math.min(sx, sy);
            float scaledW = (float)imageWidth * sf;
            float scaledH = (float)imageHeight * sf;
            g2.translate(((float)width - scaledW) / 2.0f, ((float)height - scaledH) / 2.0f);
            if ((double)sf != 1.0) {
                g2.scale(sf, sf);
            }
            g2.drawImage(image, null, 0, 0);
        }
    }
}

