/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.player.component;

import java.awt.Component;
import java.awt.Window;
import me.lib720.caprica.vlcj.factory.MediaPlayerFactory;
import me.lib720.caprica.vlcj.medialist.MediaList;
import me.lib720.caprica.vlcj.medialist.MediaListRef;
import me.lib720.caprica.vlcj.player.component.EmbeddedMediaListPlayerComponentBase;
import me.lib720.caprica.vlcj.player.component.InputEvents;
import me.lib720.caprica.vlcj.player.component.MediaPlayerSpecs;
import me.lib720.caprica.vlcj.player.embedded.EmbeddedMediaPlayer;
import me.lib720.caprica.vlcj.player.embedded.fullscreen.FullScreenStrategy;
import me.lib720.caprica.vlcj.player.list.MediaListPlayer;

public class EmbeddedMediaListPlayerComponent
extends EmbeddedMediaListPlayerComponentBase {
    private MediaListPlayer mediaListPlayer;
    private MediaList mediaList;

    public EmbeddedMediaListPlayerComponent(MediaPlayerFactory mediaPlayerFactory, Component videoSurfaceComponent, FullScreenStrategy fullScreenStrategy, InputEvents inputEvents, Window overlay) {
        super(mediaPlayerFactory, videoSurfaceComponent, fullScreenStrategy, inputEvents, overlay);
        this.applyMediaPlayer();
        this.applyMediaList();
        this.onAfterConstruct();
    }

    public EmbeddedMediaListPlayerComponent(MediaPlayerSpecs.EmbeddedMediaPlayerSpec spec) {
        this(spec.factory, spec.videoSurfaceComponent, spec.fullScreenStrategy, spec.inputEvents, spec.overlay);
    }

    public EmbeddedMediaListPlayerComponent(String ... libvlcArgs) {
        this(new MediaPlayerFactory(libvlcArgs), null, null, null, null);
    }

    public EmbeddedMediaListPlayerComponent() {
        this((MediaPlayerFactory)null, (Component)null, (FullScreenStrategy)null, (InputEvents)null, (Window)null);
    }

    @Override
    protected final EmbeddedMediaPlayer onCreateMediaPlayer() {
        this.mediaListPlayer = this.mediaPlayerFactory().mediaPlayers().newMediaListPlayer();
        this.mediaListPlayer.events().addMediaListPlayerEventListener(this);
        this.mediaList = this.mediaPlayerFactory().media().newMediaList();
        this.mediaList.events().addMediaListEventListener(this);
        return this.mediaPlayerFactory().mediaPlayers().newEmbeddedMediaPlayer(this.mediaListPlayer);
    }

    private void applyMediaPlayer() {
        this.mediaListPlayer.mediaPlayer().setMediaPlayer(this.mediaPlayer());
    }

    private void applyMediaList() {
        MediaListRef mediaListRef = this.mediaList.newMediaListRef();
        try {
            this.mediaListPlayer.list().setMediaList(mediaListRef);
        }
        finally {
            mediaListRef.release();
        }
    }

    public final MediaListPlayer mediaListPlayer() {
        return this.mediaListPlayer;
    }

    @Override
    protected final void onBeforeRelease() {
        this.mediaListPlayer.release();
        this.mediaList.release();
    }
}

