/*
 * Decompiled with CFR 0.152.
 */
package me.lib720.caprica.vlcj.media;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.lib720.caprica.vlcj.VideoLan4J;
import me.lib720.caprica.vlcj.binding.internal.libvlc_audio_track_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_media_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_media_track_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_subtitle_track_t;
import me.lib720.caprica.vlcj.binding.internal.libvlc_video_track_t;
import me.lib720.caprica.vlcj.binding.lib.LibVlc;
import me.lib720.caprica.vlcj.media.AudioTrackInfo;
import me.lib720.caprica.vlcj.media.TextTrackInfo;
import me.lib720.caprica.vlcj.media.TrackInfo;
import me.lib720.caprica.vlcj.media.TrackType;
import me.lib720.caprica.vlcj.media.UnknownTrackInfo;
import me.lib720.caprica.vlcj.media.VideoOrientation;
import me.lib720.caprica.vlcj.media.VideoProjection;
import me.lib720.caprica.vlcj.media.VideoTrackInfo;

final class TrackInformation {
    static List<TrackInfo> getTrackInfo(libvlc_media_t media, TrackType ... types) {
        List<TrackInfo> result;
        if (media != null) {
            HashSet<TrackType> requestedTypes;
            if (types == null || types.length == 0) {
                requestedTypes = null;
            } else {
                requestedTypes = new HashSet<TrackType>(types.length);
                for (TrackType type : types) {
                    requestedTypes.add(type);
                }
            }
            result = TrackInformation.getTrackInfo(media, requestedTypes);
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private static List<TrackInfo> getTrackInfo(libvlc_media_t media, Set<TrackType> types) {
        PointerByReference tracksPointer = new PointerByReference();
        int numberOfTracks = LibVlc.libvlc_media_tracks_get(media, tracksPointer);
        ArrayList<TrackInfo> result = new ArrayList<TrackInfo>(numberOfTracks);
        if (numberOfTracks > 0) {
            Pointer[] tracks;
            for (Pointer track : tracks = tracksPointer.getValue().getPointerArray(0L, numberOfTracks)) {
                TrackInfo trackInfo = TrackInformation.getTrackInfo(track, types);
                if (trackInfo == null) continue;
                result.add(trackInfo);
            }
            LibVlc.libvlc_media_tracks_release(tracksPointer.getValue(), numberOfTracks);
        }
        return result;
    }

    private static TrackInfo getTrackInfo(Pointer pointer, Set<TrackType> types) {
        TrackInfo result = null;
        libvlc_media_track_t track = (libvlc_media_track_t)Structure.newInstance(libvlc_media_track_t.class, (Pointer)pointer);
        track.read();
        switch (TrackType.trackType(track.i_type)) {
            case UNKNOWN: {
                if (types != null && !types.contains((Object)TrackType.UNKNOWN)) break;
                result = TrackInformation.getUnknownTrackInfo(track);
                break;
            }
            case VIDEO: {
                if (types != null && !types.contains((Object)TrackType.VIDEO)) break;
                result = TrackInformation.getVideoTrackInfo(track);
                break;
            }
            case AUDIO: {
                if (types != null && !types.contains((Object)TrackType.AUDIO)) break;
                result = TrackInformation.getAudioTrackInfo(track);
                break;
            }
            case TEXT: {
                if (types != null && !types.contains((Object)TrackType.TEXT)) break;
                result = TrackInformation.getTextTrackInfo(track);
            }
        }
        return result;
    }

    private static TrackInfo getUnknownTrackInfo(libvlc_media_track_t track) {
        return new UnknownTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, VideoLan4J.copyNativeString(track.psz_language), VideoLan4J.copyNativeString(track.psz_description), TrackInformation.codecDescription(TrackType.UNKNOWN, track.i_codec));
    }

    private static TrackInfo getVideoTrackInfo(libvlc_media_track_t track) {
        track.u.setType(libvlc_video_track_t.class);
        track.u.read();
        return new VideoTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, VideoLan4J.copyNativeString(track.psz_language), VideoLan4J.copyNativeString(track.psz_description), track.u.video.i_width, track.u.video.i_height, track.u.video.i_sar_num, track.u.video.i_sar_den, track.u.video.i_frame_rate_num, track.u.video.i_frame_rate_den, VideoOrientation.videoOrientation(track.u.video.i_orientation), VideoProjection.videoProjection(track.u.video.i_projection), track.u.video.pose.f_yaw, track.u.video.pose.f_pitch, track.u.video.pose.f_roll, track.u.video.pose.f_field_of_view, null, TrackInformation.codecDescription(TrackType.VIDEO, track.i_codec));
    }

    private static TrackInfo getAudioTrackInfo(libvlc_media_track_t track) {
        track.u.setType(libvlc_audio_track_t.class);
        track.u.read();
        return new AudioTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, VideoLan4J.copyNativeString(track.psz_language), VideoLan4J.copyNativeString(track.psz_description), track.u.audio.i_channels, track.u.audio.i_rate, TrackInformation.codecDescription(TrackType.AUDIO, track.i_codec));
    }

    private static TrackInfo getTextTrackInfo(libvlc_media_track_t track) {
        track.u.setType(libvlc_subtitle_track_t.class);
        track.u.read();
        return new TextTrackInfo(track.i_codec, track.i_original_fourcc, track.i_id, track.i_profile, track.i_level, track.i_bitrate, VideoLan4J.copyNativeString(track.psz_language), VideoLan4J.copyNativeString(track.psz_description), VideoLan4J.copyNativeString(track.u.subtitle.psz_encoding), TrackInformation.codecDescription(TrackType.TEXT, track.i_codec));
    }

    private static String codecDescription(TrackType type, int codec) {
        return LibVlc.libvlc_media_get_codec_description(type.intValue(), codec);
    }

    private TrackInformation() {
    }
}

