/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.candylands.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.candylands.CandylandsMod;
import net.mcreator.candylands.procedures.BuyChocolateKeyProcedure;
import net.mcreator.candylands.procedures.BuySweetifierProcedure;
import net.mcreator.candylands.procedures.SellFineChocolateProcedure;
import net.mcreator.candylands.procedures.SellFloatyScrapsProcedure;
import net.mcreator.candylands.procedures.SellJungleCandyProcedure;
import net.mcreator.candylands.procedures.ToWilliamDialogGuiProcedure;
import net.mcreator.candylands.world.inventory.WilliamShopGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class WilliamShopGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public WilliamShopGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public WilliamShopGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(WilliamShopGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(WilliamShopGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            WilliamShopGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = WilliamShopGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            ToWilliamDialogGuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            BuySweetifierProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            BuyChocolateKeyProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            SellFloatyScrapsProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            SellJungleCandyProcedure.execute((Entity)entity);
        }
        if (buttonID == 6) {
            SellFineChocolateProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CandylandsMod.addNetworkMessage(WilliamShopGuiButtonMessage.class, WilliamShopGuiButtonMessage::buffer, WilliamShopGuiButtonMessage::new, WilliamShopGuiButtonMessage::handler);
    }
}

