/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.candylands.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.candylands.CandylandsMod;
import net.mcreator.candylands.procedures.EventBuyPinataHuntTrophyProcedure;
import net.mcreator.candylands.procedures.EventBuyPinataTotemProcedure;
import net.mcreator.candylands.procedures.EventBuyTreatBagProcedure;
import net.mcreator.candylands.procedures.ToEventArrangerGuiProcedure;
import net.mcreator.candylands.procedures.ToEventPinataHuntGui0Procedure;
import net.mcreator.candylands.world.inventory.EventPinataHuntGuiMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventPinataHuntGuiButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public EventPinataHuntGuiButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public EventPinataHuntGuiButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(EventPinataHuntGuiButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(EventPinataHuntGuiButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            EventPinataHuntGuiButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = EventPinataHuntGuiMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 1) {
            ToEventArrangerGuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ToEventPinataHuntGui0Procedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            EventBuyTreatBagProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            EventBuyPinataTotemProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            EventBuyPinataHuntTrophyProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CandylandsMod.addNetworkMessage(EventPinataHuntGuiButtonMessage.class, EventPinataHuntGuiButtonMessage::buffer, EventPinataHuntGuiButtonMessage::new, EventPinataHuntGuiButtonMessage::handler);
    }
}

