/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.candylands.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.candylands.CandylandsMod;
import net.mcreator.candylands.procedures.EventSellBronzeCandyProcedure;
import net.mcreator.candylands.procedures.EventSellGoldenCandyProcedure;
import net.mcreator.candylands.procedures.EventSellSilverCandyProcedure;
import net.mcreator.candylands.procedures.ToEventArrangerGuiProcedure;
import net.mcreator.candylands.procedures.ToEventPinataHuntGuiProcedure;
import net.mcreator.candylands.world.inventory.EventPinataHuntGui0Menu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class EventPinataHuntGui0ButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public EventPinataHuntGui0ButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public EventPinataHuntGui0ButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(EventPinataHuntGui0ButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(EventPinataHuntGui0ButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            EventPinataHuntGui0ButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.f_19853_;
        HashMap<String, Object> guistate = EventPinataHuntGui0Menu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 1) {
            ToEventArrangerGuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            ToEventPinataHuntGuiProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 3) {
            EventSellBronzeCandyProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            EventSellSilverCandyProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            EventSellGoldenCandyProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        CandylandsMod.addNetworkMessage(EventPinataHuntGui0ButtonMessage.class, EventPinataHuntGui0ButtonMessage::buffer, EventPinataHuntGui0ButtonMessage::new, EventPinataHuntGui0ButtonMessage::handler);
    }
}

