/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.candylands.entity;

import io.netty.buffer.Unpooled;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.candylands.init.CandylandsModEntities;
import net.mcreator.candylands.procedures.BaduraMiniBossEntityIsHurtProcedure;
import net.mcreator.candylands.world.inventory.BaduraGuiMenu;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

public class BaduraNpcEntity
extends PathfinderMob {
    private final ItemStackHandler inventory = new ItemStackHandler(9){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public BaduraNpcEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BaduraNpcEntity>)((EntityType)CandylandsModEntities.BADURA_NPC.get()), world);
    }

    public BaduraNpcEntity(EntityType<BaduraNpcEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_21530_();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.witch.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.witch.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.witch.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        BaduraMiniBossEntityIsHurtProcedure.execute((LevelAccessor)this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this, source.m_7639_());
        return super.m_6469_(source, amount);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    protected void m_5907_() {
        super.m_5907_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT(inventoryTag);
        }
    }

    public InteractionResult m_6071_(final Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        if (sourceentity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237113_((String)"Badura [NPC]");
                }

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.m_130064_(sourceentity.m_20183_());
                    packetBuffer.writeByte(0);
                    packetBuffer.m_130130_(BaduraNpcEntity.this.m_19879_());
                    return new BaduraGuiMenu(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.m_130064_(sourceentity.m_20183_());
                buf.writeByte(0);
                buf.m_130130_(this.m_19879_());
            });
        }
        super.m_6071_(sourceentity, hand);
        return retval;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.0);
        builder = builder.m_22268_(Attributes.f_22276_, 1024.0);
        builder = builder.m_22268_(Attributes.f_22284_, 100.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 0.0);
        return builder;
    }
}

