/*
 * Decompiled with CFR 0.152.
 */
package net.its0v3r.itsthirst.thirst;

import net.its0v3r.itsthirst.registry.ConfigRegistry;
import net.its0v3r.itsthirst.registry.DamageSourceRegistry;
import net.its0v3r.itsthirst.registry.SoundRegistry;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3419;

public class ThirstManager {
    public boolean isModEnabled = true;
    public int thirstLevel = 20;
    public float dehydrationLevel;
    public int dehydrationTickTimer;
    public boolean hasDrankFromWaterSource = false;
    public int drankFromWaterSourceTickTimer;
    public boolean hasDrankFromRain = false;
    public int drankFromRainTickTimer;

    public void add(int thirst) {
        this.thirstLevel = Math.min(thirst + this.thirstLevel, 20);
    }

    public void update(class_1657 player) {
        class_1267 difficulty = player.field_6002.method_8407();
        if (this.dehydrationLevel > 4.0f) {
            this.dehydrationLevel -= 4.0f;
            if (difficulty != class_1267.field_5801) {
                this.thirstLevel = Math.max(this.thirstLevel - 1, 0);
            }
        }
        if (this.thirstLevel <= 0) {
            ++this.dehydrationTickTimer;
            if (this.dehydrationTickTimer >= 80) {
                if (player.method_6032() > 10.0f || difficulty == class_1267.field_5807 || player.method_6032() > 1.0f && difficulty == class_1267.field_5802) {
                    player.method_5643(DamageSourceRegistry.THIRST, 1.0f);
                }
                this.dehydrationTickTimer = 0;
            }
        } else {
            this.dehydrationTickTimer = 0;
        }
        if (!player.method_7337()) {
            if (this.thirstLevel <= ConfigRegistry.CONFIG.minimum_thirst_level_to_apply_haste_effect && !player.method_6059(class_1294.field_5917) && ConfigRegistry.CONFIG.should_thirst_apply_haste_effect) {
                player.method_6092(new class_1293(class_1294.field_5917, 40, 0, false, false, false));
            }
            if (this.thirstLevel <= ConfigRegistry.CONFIG.minimum_thirst_level_to_apply_mining_fatigue_effect && !player.method_6059(class_1294.field_5901) && ConfigRegistry.CONFIG.should_thirst_apply_mining_fatigue_effect) {
                player.method_6092(new class_1293(class_1294.field_5901, 40, 0, false, false, false));
            }
        }
        if (this.hasDrankFromWaterSource) {
            ++this.drankFromWaterSourceTickTimer;
            if (this.drankFromWaterSourceTickTimer >= ConfigRegistry.CONFIG.drank_from_water_source_cooldown * 20) {
                this.drankFromWaterSourceTickTimer = 0;
                this.hasDrankFromWaterSource = false;
                player.method_37908().method_8396(null, player.method_24515(), SoundRegistry.SWALLOW_WATER_AFTER_DRINK, class_3419.field_15248, 0.5f, player.method_37908().field_9229.method_43057() * 0.1f + 0.9f);
            }
        }
        if (this.hasDrankFromRain) {
            ++this.drankFromRainTickTimer;
            if (this.drankFromRainTickTimer >= ConfigRegistry.CONFIG.drank_from_rain_cooldown * 20) {
                this.drankFromRainTickTimer = 0;
                this.hasDrankFromRain = false;
                player.method_37908().method_8396(null, player.method_24515(), SoundRegistry.SWALLOW_WATER_AFTER_DRINK, class_3419.field_15248, 0.5f, player.method_37908().field_9229.method_43057() * 0.1f + 0.9f);
            }
        }
    }

    public boolean isModEnabled() {
        return this.isModEnabled;
    }

    public int getThirstLevel() {
        return this.thirstLevel;
    }

    public void setThirstLevel(int thirstLevel) {
        this.thirstLevel = thirstLevel;
    }

    public boolean isNotFull() {
        return this.thirstLevel < 20;
    }

    public void addDehydration(float dehydration) {
        this.dehydrationLevel = Math.min(this.dehydrationLevel + dehydration, 40.0f);
    }

    public void readNbt(class_2487 nbt) {
        this.thirstLevel = nbt.method_10550("vanillathirst.thirst_level");
        this.dehydrationLevel = nbt.method_10583("vanillathirst.dehydration_level");
        this.dehydrationTickTimer = nbt.method_10550("vanillathirst.dehydration_tick_timer");
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("vanillathirst.thirst_level", this.thirstLevel);
        nbt.method_10548("vanillathirst.dehydration_level", this.dehydrationLevel);
        nbt.method_10569("vanillathirst.dehydration_tick_time", this.dehydrationTickTimer);
    }
}

