/*
 * Decompiled with CFR 0.152.
 */
package net.its0v3r.itsthirst.network.packet;

import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.its0v3r.itsthirst.access.ThirstManagerAccess;
import net.its0v3r.itsthirst.identifier.NetworkPacketsIdentifiers;
import net.its0v3r.itsthirst.registry.ConfigRegistry;
import net.its0v3r.itsthirst.registry.EffectRegistry;
import net.its0v3r.itsthirst.thirst.ThirstManager;
import net.minecraft.class_1293;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.server.MinecraftServer;

public class DrinkWaterC2SPacket {
    public static void receive(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buffer, PacketSender responseSender) {
        ThirstManager thirstManager = ((ThirstManagerAccess)player).getThirstManager();
        String drinkSource = buffer.method_19772();
        class_2338 blockPos = buffer.method_10811();
        if (Objects.equals(drinkSource, "water_source") && thirstManager.isNotFull() && !thirstManager.hasDrankFromWaterSource && !thirstManager.hasDrankFromRain) {
            if (ConfigRegistry.CONFIG.bad_water) {
                DrinkWaterC2SPacket.applyThirstEffectChance(player, blockPos, "water_source", thirstManager);
            }
            DrinkWaterC2SPacket.drinkWater(player, thirstManager);
            thirstManager.hasDrankFromWaterSource = true;
        }
        if (Objects.equals(drinkSource, "rain") && thirstManager.isNotFull() && !thirstManager.hasDrankFromRain && !thirstManager.hasDrankFromWaterSource) {
            if (ConfigRegistry.CONFIG.bad_water && ConfigRegistry.CONFIG.bad_water_applies_to_rain) {
                DrinkWaterC2SPacket.applyThirstEffectChance(player, blockPos, "rain", thirstManager);
            }
            DrinkWaterC2SPacket.drinkWater(player, thirstManager);
            thirstManager.hasDrankFromRain = true;
        }
    }

    private static void applyThirstEffectChance(class_3222 player, class_2338 blockPos, String drinkSource, ThirstManager thirstManager) {
        class_3218 world = player.method_14220();
        float bad_water_chance = 0.0f;
        if (Objects.equals(drinkSource, "water_source")) {
            bad_water_chance = ConfigRegistry.CONFIG.bad_water_from_water_source_chance;
        } else if (Objects.equals(drinkSource, "rain")) {
            bad_water_chance = ConfigRegistry.CONFIG.bad_water_from_rain_chance;
        }
        if (world.field_9229.method_43057() <= bad_water_chance) {
            player.method_6092(new class_1293(EffectRegistry.THIRST, ConfigRegistry.CONFIG.bad_water_thirst_effect_duration * 20, 0, false, false, true));
        }
    }

    private static void drinkWater(class_3222 player, ThirstManager thirstManager) {
        class_3218 world = player.method_14220();
        world.method_8396(null, player.method_24515(), class_3417.field_20613, class_3419.field_15248, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
        thirstManager.add(1);
        player.method_6104(player.method_6058());
        ServerPlayNetworking.send((class_3222)player, (class_2960)NetworkPacketsIdentifiers.SWING_HAND_ID, (class_2540)PacketByteBufs.create());
    }
}

