/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.views.ScrollingContainer;
import com.ldtteam.blockui.views.ScrollingListContainer;
import com.ldtteam.blockui.views.ScrollingView;
import java.util.List;
import java.util.function.IntSupplier;

public class ScrollingList
extends ScrollingView {
    protected int childSpacing = 0;
    protected DataProvider dataProvider;
    private int maxHeight;

    public ScrollingList() {
    }

    public ScrollingList(PaneParams params) {
        super(params);
        this.childSpacing = params.getInteger("childspacing", this.childSpacing);
        this.setMaxHeight(this.height);
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setDataProvider(final IntSupplier countSupplier, final IPaneUpdater paneUpdater) {
        this.setDataProvider(new DataProvider(){

            @Override
            public int getElementCount() {
                return countSupplier.getAsInt();
            }

            @Override
            public void updateElement(int index, Pane rowPane) {
                paneUpdater.apply(index, rowPane);
            }
        });
    }

    public void setDataProvider(DataProvider p) {
        this.dataProvider = p;
        this.refreshElementPanes();
    }

    public void refreshElementPanes() {
        ((ScrollingListContainer)this.container).refreshElementPanes(this.dataProvider, this.maxHeight, this.childSpacing);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        this.refreshElementPanes();
    }

    @Override
    protected ScrollingContainer createScrollingContainer() {
        return new ScrollingListContainer(this);
    }

    @Override
    public void parseChildren(PaneParams params) {
        List<PaneParams> childNodes = params.getChildren();
        if (childNodes.isEmpty()) {
            return;
        }
        ScrollingContainer scrollingContainer = this.container;
        if (scrollingContainer instanceof ScrollingListContainer) {
            ScrollingListContainer scrollingListContainer = (ScrollingListContainer)scrollingContainer;
            scrollingListContainer.setListNodeParams(childNodes.get(0));
        }
    }

    public int getListElementIndexByPane(Pane pane) {
        return ((ScrollingListContainer)this.container).getListElementIndexByPane(pane);
    }

    @FunctionalInterface
    public static interface IPaneUpdater {
        public void apply(int var1, Pane var2);
    }

    public static interface DataProvider {
        public int getElementCount();

        default public void modifyRowSize(int index, ScrollingListContainer.RowSizeModifier modifier) {
        }

        public void updateElement(int var1, Pane var2);
    }
}

