/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.texture;

import com.google.gson.JsonParseException;
import com.ldtteam.blockui.util.SafeError;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.util.sprite.Sprite;
import com.ldtteam.blockui.util.texture.IsOurTexture;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.Tickable;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpriteTexture
extends AbstractTexture
implements Tickable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpriteTexture.class);
    private final ResourceLocation resourceLocation;
    private Sprite sprite;
    private Sprite.SpriteTicker ticker;

    public SpriteTexture(ResourceLocation resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
        this.close();
        if (!OutOfJarResourceLocation.fileExists(this.resourceLocation, resourceManager)) {
            throw new FileNotFoundException(this.resourceLocation.toString());
        }
        Resource resource = OutOfJarResourceLocation.getResourceHandle(this.resourceLocation, resourceManager);
        this.sprite = Sprite.loadSprite(this.resourceLocation, resource);
        this.ticker = this.sprite.createTicker();
        TextureUtil.m_85287_((int)this.m_117963_(), (int)0, (int)this.width(), (int)this.height());
        this.sprite.uploadFirstFrame(0, 0);
    }

    public void m_7673_() {
        if (this.ticker != null) {
            this.m_117966_();
            this.ticker.tickAndUpload(0, 0);
        }
    }

    public void close() {
        if (this.sprite != null) {
            this.sprite.close();
        }
        if (this.ticker != null) {
            this.ticker.close();
        }
    }

    public int width() {
        return this.sprite.width();
    }

    public int height() {
        return this.sprite.height();
    }

    @Nullable
    public static SpriteTexture checkLoaded(ResourceLocation resourceLocation, TextureManager textureManager, ResourceManager resourceManager) {
        ResourceMetadata metadata;
        AbstractTexture current = textureManager.m_174786_(resourceLocation, null);
        if (IsOurTexture.isOur(current)) {
            SpriteTexture sprite;
            return current instanceof SpriteTexture ? (sprite = (SpriteTexture)current) : null;
        }
        try {
            metadata = OutOfJarResourceLocation.getResourceHandle(resourceLocation, resourceManager).m_215509_();
        }
        catch (JsonParseException | IOException e) {
            if (!resourceLocation.m_135827_().equals("blockui")) {
                SafeError.throwInDev(new RuntimeException("Parsing sprite metadata failed for: " + resourceLocation, e), LOGGER);
            }
            return null;
        }
        if (metadata.m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).isPresent()) {
            SpriteTexture sprite = new SpriteTexture(resourceLocation);
            textureManager.m_118495_(resourceLocation, (AbstractTexture)sprite);
            return sprite;
        }
        return null;
    }
}

