/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.util.sprite;

import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.util.records.SizeI;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.client.resources.metadata.animation.AnimationMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import org.slf4j.Logger;

public class Sprite
implements AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation name;
    final int width;
    final int height;
    public NativeImage[] byMipLevel;
    @Nullable
    final SpriteMapTexture animatedTexture;

    public Sprite(ResourceLocation resLoc, SizeI frameSize, NativeImage originalImage, AnimationMetadataSection animMetadata) {
        this.name = resLoc;
        this.width = frameSize.width();
        this.height = frameSize.height();
        this.animatedTexture = this.loadFrames(frameSize, originalImage.m_84982_(), originalImage.m_85084_(), animMetadata);
        this.byMipLevel = new NativeImage[]{originalImage};
    }

    @Nullable
    private SpriteMapTexture loadFrames(SizeI frameSize, int texWidth, int texHeight, AnimationMetadataSection animMetadata) {
        int columns = texWidth / frameSize.width();
        int rows = texHeight / frameSize.height();
        int frameCount = columns * rows;
        ArrayList<Frame> list = new ArrayList<Frame>();
        animMetadata.m_174861_((index, time) -> list.add(new Frame(index, time)));
        if (list.isEmpty()) {
            for (int l = 0; l < frameCount; ++l) {
                list.add(new Frame(l, animMetadata.m_119030_()));
            }
        } else {
            int i1 = 0;
            IntOpenHashSet indexSet = new IntOpenHashSet();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Frame frame = (Frame)iterator.next();
                boolean flag = true;
                if (frame.time <= 0) {
                    LOGGER.warn("Invalid frame duration on sprite {} frame {}: {}", new Object[]{this.name, i1, frame.time});
                    flag = false;
                }
                if (frame.index < 0 || frame.index >= frameCount) {
                    LOGGER.warn("Invalid frame index on sprite {} frame {}: {}", new Object[]{this.name, i1, frame.index});
                    flag = false;
                }
                if (flag) {
                    indexSet.add(frame.index);
                } else {
                    iterator.remove();
                }
                ++i1;
            }
            int[] unusedFrames = IntStream.range(0, frameCount).filter(arg_0 -> Sprite.lambda$loadFrames$1((IntSet)indexSet, arg_0)).toArray();
            if (unusedFrames.length > 0) {
                LOGGER.warn("Unused frames in sprite {}: {}", (Object)this.name, (Object)Arrays.toString(unusedFrames));
            }
        }
        return list.size() <= 1 ? null : new SpriteMapTexture((List<Frame>)ImmutableList.copyOf(list), columns, animMetadata.m_119036_());
    }

    void uploadImages(int parentX, int parentY, int frameX, int frameY, NativeImage[] mipMappedImages) {
        for (int i = 0; i < this.byMipLevel.length && this.width >> i > 0 && this.height >> i > 0; ++i) {
            mipMappedImages[i].m_85003_(i, parentX >> i, parentY >> i, frameX >> i, frameY >> i, this.width >> i, this.height >> i, this.byMipLevel.length > 1, false);
        }
    }

    public void uploadFirstFrame(int parentX, int parentY) {
        this.uploadImages(parentX, parentY, 0, 0, this.byMipLevel);
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    @Nullable
    public SpriteTicker createTicker() {
        return this.animatedTexture != null ? this.animatedTexture.createTicker() : null;
    }

    @Override
    public void close() {
        for (NativeImage nativeimage : this.byMipLevel) {
            nativeimage.close();
        }
    }

    @Nullable
    public static Sprite loadSprite(ResourceLocation resLoc, Resource resource) {
        NativeImage nativeimage;
        AnimationMetadataSection animMetadata;
        try {
            animMetadata = resource.m_215509_().m_214059_((MetadataSectionSerializer)AnimationMetadataSection.f_119011_).orElse(AnimationMetadataSection.f_119012_);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to parse metadata from {}", (Object)resLoc, (Object)exception);
            return null;
        }
        try (InputStream inputstream = resource.m_215507_();){
            nativeimage = NativeImage.m_85058_((InputStream)inputstream);
        }
        catch (IOException ioexception) {
            LOGGER.error("Using missing texture, unable to load {}", (Object)resLoc, (Object)ioexception);
            return null;
        }
        SizeI framesize = SizeI.of((Pair<Integer, Integer>)animMetadata.m_119039_(nativeimage.m_84982_(), nativeimage.m_85084_()));
        if (Sprite.isMultipleOf(nativeimage.m_84982_(), framesize.width()) && Sprite.isMultipleOf(nativeimage.m_85084_(), framesize.height())) {
            return new Sprite(resLoc, framesize, nativeimage, animMetadata);
        }
        LOGGER.error("Image {} size {},{} is not multiple of frame size {},{}", new Object[]{resLoc, nativeimage.m_84982_(), nativeimage.m_85084_(), framesize.width(), framesize.height()});
        nativeimage.close();
        return null;
    }

    public static boolean isMultipleOf(int value, int multOf) {
        return value % multOf == 0;
    }

    private static /* synthetic */ boolean lambda$loadFrames$1(IntSet indexSet, int index) {
        return !indexSet.contains(index);
    }

    class SpriteMapTexture {
        final List<Frame> frames;
        private final int frameRowSize;
        private final boolean interpolateFrames;

        SpriteMapTexture(List<Frame> frames, int frameRowSize, boolean interpolateFrames) {
            this.frames = frames;
            this.frameRowSize = frameRowSize;
            this.interpolateFrames = interpolateFrames;
        }

        int getFrameX(int frameIndex) {
            return frameIndex % this.frameRowSize;
        }

        int getFrameY(int frameIndex) {
            return frameIndex / this.frameRowSize;
        }

        void uploadFrame(int parentX, int parentY, int frameIndex) {
            int frameX = this.getFrameX(frameIndex) * Sprite.this.width;
            int frameY = this.getFrameY(frameIndex) * Sprite.this.height;
            Sprite.this.uploadImages(parentX, parentY, frameX, frameY, Sprite.this.byMipLevel);
        }

        public SpriteTicker createTicker() {
            return new Ticker(this, this.interpolateFrames ? new InterpolationEngine() : null);
        }
    }

    static class Frame {
        final int index;
        final int time;

        Frame(int index, int time) {
            this.index = index;
            this.time = time;
        }
    }

    public static interface SpriteTicker
    extends AutoCloseable {
        public void tickAndUpload(int var1, int var2);

        @Override
        public void close();
    }

    class Ticker
    implements SpriteTicker {
        int frame;
        int subFrame;
        final SpriteMapTexture animationInfo;
        @Nullable
        private final InterpolationEngine interpolationData;

        Ticker(@Nullable SpriteMapTexture animationInfo, InterpolationEngine interpolationData) {
            this.animationInfo = animationInfo;
            this.interpolationData = interpolationData;
        }

        @Override
        public void tickAndUpload(int parentX, int parentY) {
            ++this.subFrame;
            Frame curFrame = this.animationInfo.frames.get(this.frame);
            if (this.subFrame >= curFrame.time) {
                int i = curFrame.index;
                this.frame = (this.frame + 1) % this.animationInfo.frames.size();
                this.subFrame = 0;
                int j = this.animationInfo.frames.get((int)this.frame).index;
                if (i != j) {
                    this.animationInfo.uploadFrame(parentX, parentY, j);
                }
            } else if (this.interpolationData != null) {
                if (!RenderSystem.m_69586_()) {
                    RenderSystem.m_69879_(() -> this.interpolationData.calcAndUploadInterpolatedFrame(parentX, parentY, this));
                } else {
                    this.interpolationData.calcAndUploadInterpolatedFrame(parentX, parentY, this);
                }
            }
        }

        @Override
        public void close() {
            if (this.interpolationData != null) {
                this.interpolationData.close();
            }
        }
    }

    final class InterpolationEngine
    implements AutoCloseable {
        private final NativeImage[] activeFrame;

        InterpolationEngine() {
            this.activeFrame = new NativeImage[Sprite.this.byMipLevel.length];
            for (int i = 0; i < this.activeFrame.length; ++i) {
                int j = Sprite.this.width >> i;
                int k = Sprite.this.height >> i;
                this.activeFrame[i] = new NativeImage(Math.max(1, j), Math.max(1, k), false);
            }
        }

        void calcAndUploadInterpolatedFrame(int parentX, int parentY, Ticker ticker) {
            SpriteMapTexture animTex = ticker.animationInfo;
            List<Frame> frames = animTex.frames;
            Frame curFrame = frames.get(ticker.frame);
            double frameProgress = 1.0 - (double)ticker.subFrame / (double)curFrame.time;
            int curFrameIndex = curFrame.index;
            int nextFrameIndex = frames.get((int)((ticker.frame + 1) % frames.size())).index;
            if (curFrameIndex != nextFrameIndex) {
                for (int mipMapLevel = 0; mipMapLevel < this.activeFrame.length; ++mipMapLevel) {
                    int endWidth = Sprite.this.width >> mipMapLevel;
                    int endHeight = Sprite.this.height >> mipMapLevel;
                    if (endWidth < 1 || endHeight < 1) continue;
                    for (int y = 0; y < endHeight; ++y) {
                        for (int x = 0; x < endWidth; ++x) {
                            int startColor = this.getPixel(animTex, curFrameIndex, mipMapLevel, x, y);
                            int endColor = this.getPixel(animTex, nextFrameIndex, mipMapLevel, x, y);
                            int r = this.mix(frameProgress, startColor >> 16 & 0xFF, endColor >> 16 & 0xFF);
                            int g = this.mix(frameProgress, startColor >> 8 & 0xFF, endColor >> 8 & 0xFF);
                            int b = this.mix(frameProgress, startColor & 0xFF, endColor & 0xFF);
                            this.activeFrame[mipMapLevel].m_84988_(x, y, startColor & 0xFF000000 | r << 16 | g << 8 | b);
                        }
                    }
                }
                Sprite.this.uploadImages(parentX, parentY, 0, 0, this.activeFrame);
            }
        }

        private int getPixel(SpriteMapTexture animTex, int frameIndex, int mipMapLevel, int x, int y) {
            return Sprite.this.byMipLevel[mipMapLevel].m_84985_(x + (animTex.getFrameX(frameIndex) * Sprite.this.width >> mipMapLevel), y + (animTex.getFrameY(frameIndex) * Sprite.this.height >> mipMapLevel));
        }

        private int mix(double progress, int min, int max) {
            return (int)(progress * (double)min + (1.0 - progress) * (double)max);
        }

        @Override
        public void close() {
            for (NativeImage nativeimage : this.activeFrame) {
                nativeimage.close();
            }
        }
    }
}

