/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.mod.item;

import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.mod.item.BlockToItemHelper;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.MultiVariant;
import net.minecraft.client.renderer.block.model.Variant;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public record BlockStateRenderingData(BlockState blockState, @Nullable BlockEntity blockEntity, ModelData modelData, boolean modelNeedsRotationFix, Lazy<ItemStack> playerPickedItemStack) {
    private final ModelData modelData;
    public static final BlockPos ILLEGAL_BLOCK_ENTITY_POS = BlockPos.f_121853_.m_6625_(1000);

    private BlockStateRenderingData(BlockState blockState, BlockEntity blockEntity, ModelData modelData, boolean modelNeedsRotationFix) {
        this(blockState, blockEntity, modelData, BlockStateRenderingData.checkModelForYrotation(blockState), (Lazy<ItemStack>)Lazy.of(() -> BlockToItemHelper.getItemStack(blockState, blockEntity, (Player)Minecraft.m_91087_().f_91074_)));
    }

    public BlockStateRenderingData(BlockState blockState, BlockEntity blockEntity, ModelData modelData) {
        this(blockState, blockEntity, modelData, BlockStateRenderingData.checkModelForYrotation(blockState));
    }

    public static BlockStateRenderingData of(BlockState blockState, @Nullable BlockEntity blockEntity) {
        return blockEntity == null ? BlockStateRenderingData.of(blockState) : new BlockStateRenderingData(blockState, blockEntity, BlockStateRenderingData.getModelData(blockState, blockEntity));
    }

    public static BlockStateRenderingData of(BlockState blockState) {
        EntityBlock entityBlock;
        BlockEntity be;
        Block block;
        if (blockState.m_155947_() && (block = blockState.m_60734_()) instanceof EntityBlock && (be = (entityBlock = (EntityBlock)block).m_142194_(ILLEGAL_BLOCK_ENTITY_POS, blockState)) != null) {
            return BlockStateRenderingData.of(blockState, be);
        }
        return new BlockStateRenderingData(blockState, null, null);
    }

    public BlockStateRenderingData updateBlockEntity(Function<BlockEntity, BlockEntity> updater) {
        BlockEntity updated = updater.apply(this.blockEntity);
        return new BlockStateRenderingData(this.blockState, updated, BlockStateRenderingData.getModelData(this.blockState, updated), this.modelNeedsRotationFix);
    }

    public ModelData modelData() {
        return this.modelData == null ? ModelData.EMPTY : this.modelData;
    }

    private static ModelData getModelData(BlockState blockState, BlockEntity blockEntity) {
        ModelData model = ModelData.EMPTY;
        try {
            model = blockEntity.getModelData();
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not get model data for: " + blockState.toString(), (Throwable)e);
        }
        return model;
    }

    public ItemStack itemStack() {
        return (ItemStack)this.playerPickedItemStack.get();
    }

    public static boolean checkModelForYrotation(BlockState blockState) {
        BlockModel blockModel;
        BlockModel bm;
        MultiVariant mv;
        UnbakedModel unbakedModel;
        BlockModel bm2;
        ModelResourceLocation modelResLoc = BlockModelShaper.m_110895_((BlockState)blockState);
        ModelBakery modelBakery = Minecraft.m_91087_().m_91289_().m_110907_().m_110881_().getModelBakery();
        UnbakedModel model = modelBakery.m_119341_((ResourceLocation)modelResLoc);
        Object object = model instanceof BlockModel ? (bm2 = (BlockModel)model) : (model instanceof MultiVariant ? ((unbakedModel = modelBakery.m_119341_(((Variant)(mv = (MultiVariant)model).m_111848_().get(0)).m_111883_())) instanceof BlockModel ? (bm = (BlockModel)unbakedModel) : null) : (blockModel = null));
        if (blockModel == null || blockModel.m_111436_().isEmpty()) {
            return false;
        }
        for (BlockElement element : blockModel.m_111436_()) {
            if (element.f_111311_ != null && element.f_111311_.f_111379_ == Direction.Axis.Y) continue;
            return false;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61365_)) {
            return blockState.m_61143_((Property)BlockStateProperties.f_61365_) == Direction.Axis.Y;
        }
        if (blockState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            Direction facing = (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
            return facing == Direction.UP || facing == Direction.DOWN;
        }
        return true;
    }
}

