/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.MatrixUtils;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Tooltip;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.mod.item.BlockStateRenderingData;
import com.ldtteam.blockui.util.SpacerTextComponent;
import com.ldtteam.blockui.util.ToggleableTextComponent;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemIcon
extends Pane {
    protected static final float DEFAULT_ITEMSTACK_SIZE = 16.0f;
    protected static final MutableComponent FIX_VANILLA_TOOLTIP = SpacerTextComponent.of(1);
    @Nullable
    protected ItemStack itemStack;
    protected boolean tooltipUpdateScheduled = false;
    protected boolean renderItemDecorations = true;

    public ItemIcon() {
    }

    public ItemIcon(PaneParams params) {
        super(params);
        Item item;
        String itemName = params.getString("item");
        if (itemName != null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemName))) != null) {
            this.setItem(item.m_7968_());
        }
        this.renderItemDecorations = params.getBoolean("renderItemDecorations", this.renderItemDecorations);
    }

    public void setItem(ItemStack itemStack) {
        this.clearDataAndScheduleTooltipUpdate();
        this.itemStack = itemStack;
        this.onItemUpdate();
    }

    protected void onItemUpdate() {
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    public void setRenderItemDecorations(boolean renderDecorations) {
        this.renderItemDecorations = renderDecorations;
    }

    public boolean renderItemDecorations() {
        return this.renderItemDecorations;
    }

    public void setItemFromBlockState(BlockState blockState, @Nullable BlockEntity blockEntity) {
        this.setItemFromBlockState(BlockStateRenderingData.of(blockState, blockEntity));
    }

    public void setItemFromBlockState(BlockStateRenderingData blockStateExtension) {
        this.clearDataAndScheduleTooltipUpdate();
        this.itemStack = blockStateExtension.itemStack();
        if (this.itemStack.m_41619_() && !(blockStateExtension.blockState().m_60734_() instanceof AirBlock)) {
            Log.getLogger().warn("Cannot create proper itemStack for: " + blockStateExtension.blockState().toString());
        }
        if (!this.itemStack.m_41619_() && blockStateExtension.blockEntity() != null) {
            blockStateExtension.blockEntity().m_187476_(this.itemStack);
        }
        this.onItemUpdate();
    }

    public void clearDataAndScheduleTooltipUpdate() {
        this.itemStack = null;
        this.tooltipUpdateScheduled = true;
    }

    protected boolean isItemEmpty() {
        return this.itemStack == null || this.itemStack.m_41619_();
    }

    public boolean isDataEmpty() {
        return this.isItemEmpty();
    }

    protected void updateTooltipIfNeeded() {
        if (this.tooltipUpdateScheduled) {
            Pane pane = this.onHover;
            if (pane instanceof Tooltip.AutomaticTooltip) {
                Tooltip.AutomaticTooltip tooltip = (Tooltip.AutomaticTooltip)pane;
                tooltip.setTextOld(this.getModifiedItemStackTooltip());
            }
            this.tooltipUpdateScheduled = false;
        }
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        this.updateTooltipIfNeeded();
        if (!this.isDataEmpty()) {
            ms.m_85836_();
            ms.m_85837_((double)this.x, (double)this.y, 0.0);
            ms.m_85841_((float)this.getWidth() / 16.0f, (float)this.getHeight() / 16.0f, 1.0f);
            MatrixUtils.pushShaderMVstack(ms);
            Font font = IClientItemExtensions.DEFAULT.getFont(this.itemStack, IClientItemExtensions.FontContext.ITEM_COUNT);
            if (font == null) {
                font = this.mc.f_91062_;
            }
            this.mc.m_91291_().m_115203_(this.itemStack, 0, 0);
            if (this.renderItemDecorations) {
                this.mc.m_91291_().m_115169_(font, this.itemStack, 0, 0);
            }
            RenderSystem.m_69453_();
            RenderSystem.m_69461_();
            MatrixUtils.popShaderMVstack();
            ms.m_85849_();
        }
    }

    @Override
    public void onUpdate() {
        if (this.onHover == null && !this.isItemEmpty()) {
            new AbstractTextBuilder.AutomaticTooltipBuilder().hoverPane(this).build().setTextOld(this.getModifiedItemStackTooltip());
        }
    }

    protected int modifyTooltipName(List<Component> tooltipList, TooltipFlag tooltipFlags, int nameOffset) {
        return nameOffset;
    }

    protected int appendTooltip(List<Component> tooltipList, TooltipFlag tooltipFlags, int prevTooltipSize) {
        return prevTooltipSize;
    }

    public List<Component> getModifiedItemStackTooltip() {
        if (this.isDataEmpty()) {
            return Collections.emptyList();
        }
        TooltipFlag.Default tooltipFlags = this.mc.f_91066_.f_92125_ ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL;
        List tooltipList = this.itemStack.m_41651_((Player)this.mc.f_91074_, (TooltipFlag)tooltipFlags);
        int nameOffset = 1;
        nameOffset = this.modifyTooltipName(tooltipList, (TooltipFlag)tooltipFlags, nameOffset);
        int prevTooltipSize = tooltipList.size();
        if (tooltipFlags.m_7050_() && this.mc.f_91074_.m_7500_()) {
            Item item = this.itemStack.m_41720_();
            int nameoffset = nameOffset + 1;
            ForgeRegistries.ITEMS.getHolder((Object)item).map(Holder::getTagKeys).ifPresent(tags -> tags.forEach(tag -> tooltipList.add(nameoffset, ItemIcon.wrapShift(Component.m_237113_((String)("#" + tag.f_203868_())).m_130940_(ChatFormatting.DARK_PURPLE)))));
            if (item.m_41471_() != null) {
                tooltipList.add(nameOffset + 1, ItemIcon.wrapShift(item.m_41471_().m_40786_().m_6881_().m_130940_(ChatFormatting.BLUE)));
            }
        }
        if ((prevTooltipSize = this.appendTooltip(tooltipList, (TooltipFlag)tooltipFlags, prevTooltipSize)) != tooltipList.size()) {
            tooltipList.add(ToggleableTextComponent.ofNegated(Screen::m_96638_, Component.m_237119_()));
            tooltipList.add(ToggleableTextComponent.ofNegated(Screen::m_96638_, Component.m_237110_((String)"blockui.tooltip.item_additional_info", (Object[])new Object[]{Component.m_237115_((String)"key.keyboard.left.shift")}).m_130940_(ChatFormatting.GOLD)));
        }
        tooltipList.add(nameOffset, FIX_VANILLA_TOOLTIP);
        return tooltipList;
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped) {
        return ToggleableTextComponent.of(Screen::m_96638_, wrapped);
    }

    protected static MutableComponent wrapShift(MutableComponent wrapped, boolean shouldWrap) {
        return shouldWrap ? ToggleableTextComponent.of(Screen::m_96638_, wrapped) : wrapped;
    }
}

