/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.controls;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.Parsers;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.util.records.SizeI;
import com.ldtteam.blockui.util.resloc.OutOfJarResourceLocation;
import com.ldtteam.blockui.util.texture.OutOfJarTexture;
import com.ldtteam.blockui.util.texture.SpriteTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Objects;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class Image
extends Pane {
    protected ResourceLocation resourceLocation;
    protected int u = 0;
    protected int v = 0;
    protected int uWidth = 0;
    protected int vHeight = 0;
    protected int mapWidth = 0;
    protected int mapHeight = 0;

    public Image() {
    }

    public Image(PaneParams params) {
        super(params);
        params.applyShorthand("imageoffset", Parsers.INT, 2, a -> {
            this.u = (Integer)a.get(0);
            this.v = (Integer)a.get(1);
        });
        params.applyShorthand("imagesize", Parsers.INT, 2, a -> {
            this.uWidth = (Integer)a.get(0);
            this.vHeight = (Integer)a.get(1);
        });
        this.resourceLocation = params.getResource("source", this::loadMapDimensions);
    }

    private void loadMapDimensions(ResourceLocation rl) {
        AbstractTexture abstractTexture = OutOfJarTexture.assertLoadedDefaultManagers(rl);
        if (abstractTexture instanceof SpriteTexture) {
            SpriteTexture sprite = (SpriteTexture)abstractTexture;
            this.mapWidth = sprite.width();
            this.mapHeight = sprite.height();
            this.checkBlitSize();
            return;
        }
        SizeI dimensions = Image.getImageDimensions(rl);
        this.mapWidth = dimensions.width();
        this.mapHeight = dimensions.height();
        this.checkBlitSize();
    }

    private void checkBlitSize() {
        String xmlLoc = this.window == null ? "unknown" : this.window.getXmlResourceLocation().toString();
        if (this.u + (this.uWidth == 0 ? this.mapWidth : this.uWidth) > this.mapWidth) {
            throw new RuntimeException("Invalid blit width for image: id - " + this.id + ", window - " + xmlLoc);
        }
        if (this.v + (this.vHeight == 0 ? this.mapHeight : this.vHeight) > this.mapHeight) {
            throw new RuntimeException("Invalid blit height for image: id - " + this.id + ", window - " + xmlLoc);
        }
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.checkBlitSize();
    }

    public void setMapDimensions(int height, int width) {
        this.mapHeight = height;
        this.mapWidth = width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SizeI getImageDimensions(ResourceLocation resourceLocation) {
        OutOfJarTexture.assertLoadedDefaultManagers(resourceLocation);
        int pos = resourceLocation.m_135815_().lastIndexOf(".");
        if (pos == -1) {
            throw new IllegalStateException("No extension for file: " + resourceLocation.toString());
        }
        String suffix = resourceLocation.m_135815_().substring(pos + 1);
        Iterator<ImageReader> it = ImageIO.getImageReadersBySuffix(suffix);
        while (it.hasNext()) {
            ImageReader reader = it.next();
            try {
                SizeI sizeI;
                block15: {
                    ImageInputStream stream2 = ImageIO.createImageInputStream(OutOfJarResourceLocation.openStream(resourceLocation, Minecraft.m_91087_().m_91098_()));
                    try {
                        reader.setInput(stream2);
                        sizeI = new SizeI(reader.getWidth(reader.getMinIndex()), reader.getHeight(reader.getMinIndex()));
                        if (stream2 == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream2 != null) {
                                try {
                                    stream2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (FileNotFoundException | NoSuchFileException stream2) {
                            reader.dispose();
                            continue;
                        }
                        catch (IOException e) {
                            Log.getLogger().warn((Object)e);
                            continue;
                        }
                    }
                    stream2.close();
                }
                return sizeI;
            }
            finally {
                reader.dispose();
            }
        }
        return new SizeI(0, 0);
    }

    public void setImage(ResourceLocation rl, int u, int v, int uWidth, int vHeight) {
        if (!Objects.equals(rl, this.resourceLocation)) {
            this.loadMapDimensions(rl);
        }
        this.resourceLocation = rl;
        this.u = u;
        this.v = v;
        this.uWidth = uWidth;
        this.vHeight = vHeight;
    }

    public void setImage(ResourceLocation rl, boolean keepUv) {
        if (!Objects.equals(rl, this.resourceLocation)) {
            this.loadMapDimensions(rl);
        }
        this.resourceLocation = rl;
        if (!keepUv) {
            this.u = 0;
            this.v = 0;
            this.uWidth = 0;
            this.vHeight = 0;
        }
    }

    @Override
    public void drawSelf(PoseStack ms, double mx, double my) {
        if (!FMLEnvironment.production) {
            Objects.requireNonNull(this.resourceLocation, () -> this.id + " | " + this.window.getXmlResourceLocation());
        } else if (this.resourceLocation == null) {
            this.resourceLocation = MissingTextureAtlasSprite.m_118071_();
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        if (this.u != 0 || this.v != 0 || this.uWidth != 0 || this.vHeight != 0) {
            Image.blit(ms, this.resourceLocation, this.x, this.y, this.width, this.height, this.u, this.v, this.uWidth == 0 ? this.mapWidth : this.uWidth, this.vHeight == 0 ? this.mapHeight : this.vHeight, this.mapWidth, this.mapHeight);
        } else {
            Image.blit(ms, this.resourceLocation, this.x, this.y, this.width, this.height);
        }
        RenderSystem.m_69461_();
    }
}

