/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.storage;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.network.messages.NotifyServerAboutStructurePacksMessage;
import com.ldtteam.structurize.network.messages.SyncSettingsToServer;
import com.ldtteam.structurize.storage.StructurePackMeta;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.storage.rendering.RenderingCache;
import com.ldtteam.structurize.util.IOPool;
import com.ldtteam.structurize.util.JavaUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class ClientStructurePackLoader {
    public static volatile ClientLoadingState loadingState = ClientLoadingState.LOADING;

    public static void onClientLoading() {
        ArrayList<Path> modPaths = new ArrayList<Path>();
        ArrayList<String> modList = new ArrayList<String>();
        for (IModInfo mod : ModList.get().getMods()) {
            modPaths.add(mod.getOwningFile().getFile().findResource(new String[]{"blueprints", mod.getModId()}));
            modList.add(mod.getModId());
        }
        if (Minecraft.m_91087_() == null) {
            return;
        }
        Path gameFolder = Minecraft.m_91087_().f_91069_.toPath();
        IOPool.execute(() -> {
            Stream<Path> paths;
            for (Path modPath : modPaths) {
                try {
                    paths = Files.list(modPath);
                    try {
                        paths.forEach(element -> StructurePacks.discoverPackAtPath(element, true, modList, false, modPath.toString().split("/")[1]));
                    }
                    finally {
                        if (paths == null) continue;
                        paths.close();
                    }
                }
                catch (IOException e) {
                    Log.getLogger().warn("Failed loading packs from mod path: " + modPath.toString());
                }
            }
            try {
                Path clientPackPath;
                Path outputPath = gameFolder.resolve("blueprints");
                if (!Files.exists(outputPath, new LinkOption[0])) {
                    Files.createDirectory(outputPath, new FileAttribute[0]);
                }
                if (!Files.exists(clientPackPath = outputPath.resolve(Minecraft.m_91087_().m_91094_().m_92546_().toLowerCase(Locale.US)), new LinkOption[0])) {
                    Files.createDirectory(clientPackPath, new FileAttribute[0]);
                    Files.createDirectory(clientPackPath.resolve("scans"), new FileAttribute[0]);
                    JsonObject jsonObject = new JsonObject();
                    jsonObject.addProperty("version", (Number)1);
                    jsonObject.addProperty("pack-format", (Number)1);
                    jsonObject.addProperty("desc", "This is your local Structurepack. This is where all your scans go.");
                    JsonArray authorArray = new JsonArray();
                    authorArray.add(Minecraft.m_91087_().m_91094_().m_92546_());
                    jsonObject.add("authors", (JsonElement)authorArray);
                    JsonArray modsArray = new JsonArray();
                    modsArray.add("structurize");
                    jsonObject.add("mods", (JsonElement)modsArray);
                    jsonObject.addProperty("name", Minecraft.m_91087_().m_91094_().m_92546_());
                    jsonObject.addProperty("icon", "");
                    Files.write(clientPackPath.resolve("pack.json"), jsonObject.toString().getBytes(), new OpenOption[0]);
                }
                paths = Files.list(outputPath);
                try {
                    paths.forEach(element -> StructurePacks.discoverPackAtPath(element, false, modList, false, "Local"));
                }
                finally {
                    if (paths != null) {
                        paths.close();
                    }
                }
            }
            catch (IOException e) {
                Log.getLogger().warn("Failed loading packs from main folder path: " + gameFolder.toString());
            }
            Log.getLogger().warn("Finished discovering Client Structure packs");
            loadingState = ClientLoadingState.FINISHED_LOADING;
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (Minecraft.m_91087_().f_91073_ != null && loadingState == ClientLoadingState.FINISHED_LOADING) {
                if (Minecraft.m_91087_().m_91092_() != null && !Minecraft.m_91087_().m_91092_().m_6992_()) {
                    loadingState = ClientLoadingState.FINISHED_SYNCING;
                    StructurePacks.setFinishedLoading();
                    if (StructurePacks.selectedPack == null && !StructurePacks.getPackMetas().isEmpty()) {
                        StructurePacks.selectedPack = StructurePacks.getPackMetas().iterator().next();
                    }
                    return;
                }
                loadingState = ClientLoadingState.SYNCING;
                Network.getNetwork().sendToServer(new NotifyServerAboutStructurePacksMessage(StructurePacks.getPackMetas()));
            } else if (Minecraft.m_91087_().f_91073_ == null && (loadingState == ClientLoadingState.SYNCING || loadingState == ClientLoadingState.FINISHED_SYNCING)) {
                Log.getLogger().warn("Client logged off. Resetting Pack Meta and Reloading State");
                loadingState = ClientLoadingState.LOADING;
                StructurePacks.clearPacks();
                RenderingCache.clear();
                ClientStructurePackLoader.onClientLoading();
            }
        }
    }

    public static void onServerSyncAttempt(Map<String, Integer> serverStructurePacks) {
        Network.getNetwork().sendToServer(new SyncSettingsToServer());
        if (serverStructurePacks.isEmpty()) {
            loadingState = ClientLoadingState.FINISHED_SYNCING;
            StructurePacks.setFinishedLoading();
            if (StructurePacks.selectedPack == null && !StructurePacks.getPackMetas().isEmpty()) {
                StructurePacks.selectedPack = StructurePacks.getPackMetas().iterator().next();
            }
            return;
        }
        if (serverStructurePacks.containsKey(Minecraft.m_91087_().f_91074_.m_36316_().getName())) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237115_((String)"structurize.pack.equaluser.error"));
        }
        boolean needsChanges = false;
        for (StructurePackMeta pack : StructurePacks.getPackMetas()) {
            if (pack.isImmutable()) continue;
            int version = serverStructurePacks.getOrDefault(pack.getName(), -1);
            if (version == -1) {
                if (((Boolean)Structurize.getConfig().getServer().allowPlayerSchematics.get()).booleanValue()) continue;
                StructurePacks.disablePack(pack.getName());
                continue;
            }
            if (version == pack.getVersion()) continue;
            StructurePacks.disablePack(pack.getName());
            needsChanges = true;
        }
        for (String packKey : serverStructurePacks.keySet()) {
            if (StructurePacks.hasPack(packKey)) continue;
            needsChanges = true;
            break;
        }
        if (!needsChanges) {
            loadingState = ClientLoadingState.FINISHED_SYNCING;
            if (StructurePacks.selectedPack == null && !StructurePacks.getPackMetas().isEmpty()) {
                StructurePacks.selectedPack = StructurePacks.getPackMetas().iterator().next();
            }
            StructurePacks.setFinishedLoading();
        }
    }

    public static void onStructurePackTransfer(String packName, ByteBuf payload, boolean eol) {
        Log.getLogger().warn("Received Structure pack from the Server: " + packName);
        IOPool.execute(() -> {
            StructurePackMeta pack = StructurePacks.disablePack(packName);
            if (pack != null && !pack.isImmutable() && !JavaUtils.deleteDirectory(pack.getPath())) {
                Log.getLogger().warn("Error trying to delete pack: ");
            }
            try (ZipInputStream zis = new ZipInputStream((InputStream)new ByteBufInputStream(payload));){
                ZipEntry zipEntry = zis.getNextEntry();
                Path structureFolder = Minecraft.m_91087_().f_91069_.toPath().resolve("blueprints");
                JavaUtils.deleteDirectory(structureFolder.resolve(packName));
                Path rootPath = Files.createDirectory(structureFolder.resolve(packName), new FileAttribute[0]);
                while (zipEntry != null) {
                    boolean isDirectory = zipEntry.isDirectory();
                    Path newPath = ClientStructurePackLoader.zipSlipProtect(zipEntry, rootPath);
                    if (isDirectory) {
                        Files.createDirectories(newPath, new FileAttribute[0]);
                    } else {
                        if (newPath.getParent() != null && Files.notExists(newPath.getParent(), new LinkOption[0])) {
                            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                        }
                        Files.copy(zis, newPath, StandardCopyOption.REPLACE_EXISTING);
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
                ArrayList<String> modList = new ArrayList<String>();
                for (IModInfo mod : ModList.get().getMods()) {
                    modList.add(mod.getModId());
                }
                StructurePacks.discoverPackAtPath(rootPath, true, modList, false, "Local");
            }
            catch (IOException ex) {
                Log.getLogger().error("Unable to read datapack from zip", (Throwable)ex);
            }
            payload.release();
            if (eol) {
                loadingState = ClientLoadingState.FINISHED_SYNCING;
                StructurePacks.setFinishedLoading();
                StructurePacks.selectedPack = StructurePacks.getPackMetas().iterator().next();
            }
        });
    }

    public static Path zipSlipProtect(ZipEntry zipEntry, Path targetDir) throws IOException {
        Path targetDirResolved = targetDir.resolve(zipEntry.getName());
        Path normalizePath = targetDirResolved.normalize();
        if (!normalizePath.startsWith(targetDir.normalize())) {
            throw new IOException("Bad zip entry: " + zipEntry.getName());
        }
        return normalizePath;
    }

    public static void handleSaveScanMessage(CompoundTag compound, String fileName) {
        String packName = Minecraft.m_91087_().m_91094_().m_92546_().toLowerCase(Locale.US);
        StructurePacks.selectedPack = StructurePacks.getStructurePack(Minecraft.m_91087_().m_91094_().m_92546_());
        RenderingCache.getOrCreateBlueprintPreviewData("blueprint").setBlueprintFuture(StructurePacks.storeBlueprint(packName, compound, Minecraft.m_91087_().f_91069_.toPath().resolve("blueprints").resolve(Minecraft.m_91087_().m_91094_().m_92546_().toLowerCase(Locale.US)).resolve("scans").resolve(fileName)));
        RenderingCache.getOrCreateBlueprintPreviewData("blueprint").setPos(null);
        Minecraft.m_91087_().f_91074_.m_5661_((Component)Component.m_237110_((String)"Scan successfully saved as %s", (Object[])new Object[]{fileName}), false);
    }

    public static enum ClientLoadingState {
        LOADING,
        FINISHED_LOADING,
        SYNCING,
        FINISHED_SYNCING;

    }
}

