/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.RotationMirror;
import com.ldtteam.structurize.util.TickedWorldOperation;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class PasteFolderCommand
extends AbstractCommand {
    public static final String commandName = "pasteFolder";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String PASTE_SUCCESS_MESSAGE = "com.structurize.command.paste.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.paste.no.perm";
    private static final String NO_PACK_MESSAGE = "com.structurize.command.paste.no.pack";
    private static final String PLAYER_NAME = "player";
    private static final String POS = "pos";
    private static final String PACK_NAME = "pack";
    private static final String FILE_PATH = "path";
    private static final String ROTATION = "rotation";
    private static final String MIRROR = "mirror";
    private static final String PRETTY = "pretty";
    private static final String PLOT_SIZE = "plotSize";

    private static int execute(CommandSourceStack source, BlockPos pos, String pack, String tempPath, Rotation rotation, boolean mirrored, boolean pretty, int plotSize) throws CommandSyntaxException {
        @Nullable ServerLevel world = source.m_81372_();
        if (source.m_81373_() instanceof Player && !source.m_81375_().m_7500_()) {
            source.m_81352_((Component)Component.m_237113_((String)NO_PERMISSION_MESSAGE));
            return 0;
        }
        if (!(source.m_81373_() instanceof Player)) {
            source.m_81352_((Component)Component.m_237115_((String)PLAYER_NOT_FOUND));
            return 0;
        }
        ServerPlayer player = source.m_81375_();
        Mirror mirror = mirrored ? Mirror.FRONT_BACK : Mirror.NONE;
        String[] split = tempPath.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (String string : split) {
            if (!builder.toString().isEmpty()) {
                builder.append("/");
            }
            builder.append(string);
        }
        String path = builder.toString();
        String[] packSplit = pack.split("\\.");
        StringBuilder packBuilder = new StringBuilder();
        for (String part : packSplit) {
            if (!packBuilder.toString().isEmpty()) {
                packBuilder.append(" ");
            }
            packBuilder.append(part);
        }
        String string = packBuilder.toString();
        if (!StructurePacks.hasPack(string)) {
            source.m_81352_((Component)Component.m_237115_((String)NO_PACK_MESSAGE));
            return 0;
        }
        ServerFutureProcessor.queueBlueprintList(new ServerFutureProcessor.BlueprintListProcessingData(StructurePacks.getBlueprintsFuture(string, path), (Level)world, arg_0 -> PasteFolderCommand.lambda$execute$0(rotation, mirror, (Level)world, pos, (Player)player, pretty, string, path, plotSize, arg_0)));
        source.m_81354_((Component)Component.m_237115_((String)PASTE_SUCCESS_MESSAGE), true);
        return 1;
    }

    private static int onExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, Rotation.NONE, false, true, 34);
    }

    private static int onExecuteWithRotation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, false, true, 34);
    }

    private static int onExecuteWithRotationAndMirror(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        boolean mirror = BoolArgumentType.getBool(context, (String)MIRROR);
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, mirror, true, 34);
    }

    private static int onExecuteWithPretty(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        boolean mirror = BoolArgumentType.getBool(context, (String)MIRROR);
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, mirror, pretty, 34);
    }

    private static int onExecuteWithFull(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.m_174395_(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        Rotation rotation = Rotation.values()[IntegerArgumentType.getInteger(context, (String)ROTATION)];
        boolean mirror = BoolArgumentType.getBool(context, (String)MIRROR);
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        int plotSize = IntegerArgumentType.getInteger(context, (String)PLOT_SIZE);
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotation, mirror, pretty, plotSize);
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)PasteFolderCommand.newLiteral(commandName).then(PasteFolderCommand.newArgument(POS, BlockPosArgument.m_118239_()).then(PasteFolderCommand.newArgument(PACK_NAME, StringArgumentType.string()).then(((RequiredArgumentBuilder)PasteFolderCommand.newArgument(FILE_PATH, StringArgumentType.string()).executes(PasteFolderCommand::onExecute)).then(((RequiredArgumentBuilder)PasteFolderCommand.newArgument(ROTATION, IntegerArgumentType.integer((int)0, (int)3)).executes(PasteFolderCommand::onExecuteWithRotation)).then(PasteFolderCommand.newArgument(PLAYER_NAME, GameProfileArgument.m_94584_()).then(((RequiredArgumentBuilder)PasteFolderCommand.newArgument(MIRROR, BoolArgumentType.bool()).executes(PasteFolderCommand::onExecuteWithRotationAndMirror)).then(((RequiredArgumentBuilder)PasteFolderCommand.newArgument(PRETTY, BoolArgumentType.bool()).executes(PasteFolderCommand::onExecuteWithPretty)).then(PasteFolderCommand.newArgument(PLOT_SIZE, IntegerArgumentType.integer((int)16, (int)128)).executes(PasteFolderCommand::onExecuteWithFull)))))))));
    }

    private static /* synthetic */ void lambda$execute$0(Rotation rotation, Mirror mirror, Level world, BlockPos pos, Player player, boolean pretty, String packName, String path, int plotSize, List list) {
        LinkedHashMap<String, List> blueprintMapping = new LinkedHashMap<String, List>();
        for (Blueprint blueprint : list) {
            BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
            if (anchor.m_60734_() instanceof ILeveledBlueprintAnchorBlock) {
                int level = ((ILeveledBlueprintAnchorBlock)anchor.m_60734_()).getLevel(blueprint.getTileEntityData(BlockPos.f_121853_, blueprint.getPrimaryBlockOffset()));
                String name = blueprint.getFileName().replace(Integer.toString(level), "");
                List blueprintList = blueprintMapping.getOrDefault(name, new ArrayList());
                blueprintList.add(blueprint);
                blueprintMapping.put(name, blueprintList);
                continue;
            }
            String name = blueprint.getFileName();
            List blueprintList = blueprintMapping.getOrDefault(name, new ArrayList());
            blueprintList.add(blueprint);
            blueprintMapping.put(name, blueprintList);
        }
        int xOffset = 0;
        int zOffset = 0;
        for (List perTypeList : blueprintMapping.values()) {
            for (Blueprint blueprint : perTypeList) {
                AbstractStructureHandler structure;
                BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
                blueprint.setRotationMirror(RotationMirror.of(rotation, mirror), world);
                BlockPos placementPos = pos.m_7918_(xOffset, 0, zOffset).m_121955_((Vec3i)blueprint.getPrimaryBlockOffset());
                if (anchor.m_60734_() instanceof ISpecialCreativeHandlerAnchorBlock) {
                    if (!((ISpecialCreativeHandlerAnchorBlock)anchor.m_60734_()).setup((ServerPlayer)player, world, placementPos, blueprint, new PlacementSettings(mirror, rotation), pretty, packName, path)) {
                        return;
                    }
                    structure = ((ISpecialCreativeHandlerAnchorBlock)anchor.m_60734_()).getStructureHandler(world, placementPos, blueprint, new PlacementSettings(mirror, rotation), pretty);
                } else {
                    structure = new CreativeStructureHandler(world, placementPos, blueprint, new PlacementSettings(mirror, rotation), pretty);
                }
                StructurePlacer instantPlacer = new StructurePlacer(structure);
                Manager.addToQueue(new TickedWorldOperation(instantPlacer, player));
                zOffset += plotSize;
            }
            xOffset += plotSize;
            zOffset = 0;
        }
    }
}

