/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blueprints.v1;

import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.client.BlueprintBlockAccess;
import com.ldtteam.structurize.client.BlueprintBlockInfoTransformHandler;
import com.ldtteam.structurize.client.BlueprintEntityInfoTransformHandler;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public final class BlueprintUtils {
    private static final Function<BlockPos, BlockInfo> DEFAULT_FACTORY = pos -> new BlockInfo((BlockPos)pos, Blocks.f_50016_.m_49966_(), null);

    private BlueprintUtils() {
        throw new IllegalArgumentException("Utils class");
    }

    public static BlockEntity getTileEntityFromPos(Blueprint blueprint, BlockPos pos, BlueprintBlockAccess access) {
        BlockInfo blockInfo = BlueprintUtils.getBlockInfoFromPos(blueprint, pos);
        if (blockInfo.getTileEntityData() != null) {
            return BlueprintUtils.constructTileEntity(blockInfo, access);
        }
        return null;
    }

    public static BlockInfo getBlockInfoFromPos(Blueprint blueprint, BlockPos pos) {
        BlockInfo blockInfo = blueprint.getBlockInfoAsMap().get(pos);
        return blockInfo == null ? DEFAULT_FACTORY.apply(pos) : blockInfo;
    }

    public static List<BlockEntity> instantiateTileEntities(Blueprint blueprint, BlueprintBlockAccess blockAccess, Map<BlockPos, ModelData> teModelData) {
        return blueprint.getBlockInfoAsList().stream().map(blockInfo -> BlueprintBlockInfoTransformHandler.getInstance().Transform((BlockInfo)blockInfo)).filter(BlockInfo::hasTileEntityData).map(blockInfo -> {
            @Nullable BlockEntity be = BlueprintUtils.constructTileEntity(blockInfo, blockAccess);
            if (be != null) {
                teModelData.put(blockInfo.getPos(), be.getModelData());
            }
            return be;
        }).filter(Objects::nonNull).toList();
    }

    public static List<Entity> instantiateEntities(Blueprint blueprint, BlueprintBlockAccess blockAccess) {
        return blueprint.getEntitiesAsList().stream().map(entityInfo -> BlueprintEntityInfoTransformHandler.getInstance().Transform((CompoundTag)entityInfo)).map(entityInfo -> BlueprintUtils.constructEntity(entityInfo, blockAccess)).filter(Objects::nonNull).toList();
    }

    @Nullable
    private static BlockEntity constructTileEntity(BlockInfo info, BlueprintBlockAccess blockAccess) {
        if (info.getTileEntityData() == null) {
            return null;
        }
        String entityId = info.getTileEntityData().m_128461_("id");
        try {
            CompoundTag compound = info.getTileEntityData().m_6426_();
            compound.m_128405_("x", info.getPos().m_123341_());
            compound.m_128405_("y", info.getPos().m_123342_());
            compound.m_128405_("z", info.getPos().m_123343_());
            BlockEntity entity = BlockEntity.m_155241_((BlockPos)info.getPos(), (BlockState)Objects.requireNonNull(info.getState()), (CompoundTag)compound);
            if (entity != null) {
                entity.m_142339_((Level)blockAccess);
            }
            return entity;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create tile entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private static Entity constructEntity(@Nullable CompoundTag info, BlueprintBlockAccess blockAccess) {
        if (info == null) {
            return null;
        }
        String entityId = info.m_128461_("id");
        try {
            Entity entity;
            CompoundTag compound = info.m_6426_();
            compound.m_128362_("UUID", UUID.randomUUID());
            Optional type = EntityType.m_20637_((CompoundTag)compound);
            if (type.isPresent() && (entity = ((EntityType)type.get()).m_20615_((Level)blockAccess)) != null) {
                entity.deserializeNBT(compound);
                entity.m_146867_();
                if (entity instanceof LivingEntity) {
                    LivingEntity lentity = (LivingEntity)entity;
                    lentity.f_20886_ = lentity.f_20885_;
                    lentity.f_20884_ = lentity.f_20883_;
                }
                return entity;
            }
            return null;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }
}

