/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    private ItemStackUtils() {
    }

    public static List<ItemStack> getItemStacksOfTileEntity(CompoundTag compound, BlockState state) {
        if (state.m_60734_() instanceof BaseEntityBlock && compound.m_128441_("Items")) {
            return ItemStackUtils.getItemStacksFromNbt(compound);
        }
        BlockPos blockpos = new BlockPos(compound.m_128451_("x"), compound.m_128451_("y"), compound.m_128451_("z"));
        BlockEntity tileEntity = BlockEntity.m_155241_((BlockPos)blockpos, (BlockState)state, (CompoundTag)compound);
        if (tileEntity == null) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (IItemHandler handler : ItemStackUtils.getItemHandlersFromProvider((ICapabilityProvider)tileEntity)) {
            for (int slot = 0; slot < handler.getSlots(); ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (ItemStackUtils.isEmpty(stack).booleanValue()) continue;
                items.add(stack);
            }
        }
        return items;
    }

    @NotNull
    private static List<ItemStack> getItemStacksFromNbt(@NotNull CompoundTag compound) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        ListTag listtag = compound.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            ItemStack stack = ItemStack.m_41712_((CompoundTag)compoundtag);
            if (stack.m_41619_()) continue;
            items.add(stack);
        }
        return items;
    }

    public static Set<IItemHandler> getItemHandlersFromProvider(ICapabilityProvider provider) {
        HashSet<IItemHandler> handlerSet = new HashSet<IItemHandler>();
        for (Direction side : Direction.values()) {
            provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).ifPresent(handlerSet::add);
        }
        provider.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(handlerSet::add);
        return handlerSet;
    }

    public static Boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack == ItemStack.f_41583_ || stack.m_41613_() <= 0;
    }

    public static int getSize(ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack).booleanValue()) {
            return 0;
        }
        return stack.m_41613_();
    }

    public static List<ItemStack> getListOfStackForEntity(Entity entity, BlockPos pos) {
        if (entity != null) {
            ArrayList<ItemStack> request = new ArrayList<ItemStack>();
            if (entity instanceof ItemFrame) {
                ItemStack stack2 = ((ItemFrame)entity).m_31822_();
                if (!ItemStackUtils.isEmpty(stack2).booleanValue()) {
                    stack2.m_41764_(1);
                    request.add(stack2);
                }
                request.add(new ItemStack((ItemLike)Items.f_42617_, 1));
            } else if (entity instanceof ArmorStand) {
                request.add(entity.getPickedResult(new HitResult(Vec3.m_82528_((Vec3i)pos)){

                    public HitResult.Type m_6662_() {
                        return HitResult.Type.ENTITY;
                    }
                }));
                entity.m_6168_().forEach(request::add);
                entity.m_6167_().forEach(request::add);
            } else if (entity instanceof ContainerEntity) {
                ContainerEntity containerEntity = (ContainerEntity)entity;
                request.add(entity.getPickedResult(new HitResult(Vec3.m_82528_((Vec3i)pos)){

                    public HitResult.Type m_6662_() {
                        return HitResult.Type.ENTITY;
                    }
                }));
                request.addAll((Collection<ItemStack>)containerEntity.m_213659_());
            }
            return request.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        if (ItemStackUtils.isEmpty(itemStack1).booleanValue() && ItemStackUtils.isEmpty(itemStack2).booleanValue()) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.m_41720_() != itemStack2.m_41720_() || matchDamage && itemStack1.m_41773_() != itemStack2.m_41773_())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.m_41613_() > itemStack2.m_41613_()) {
                return false;
            }
            if (itemStack1.m_41782_() && itemStack2.m_41782_()) {
                CompoundTag nbt1 = itemStack1.m_41783_();
                CompoundTag nbt2 = itemStack2.m_41783_();
                for (String key : nbt1.m_128431_()) {
                    if (!matchDamage && key.equals("Damage") || nbt2.m_128441_(key) && nbt1.m_128423_(key).equals(nbt2.m_128423_(key))) continue;
                    return false;
                }
                return nbt1.m_128431_().size() == nbt2.m_128431_().size();
            }
            return !(itemStack1.m_41782_() && !itemStack1.m_41783_().m_128456_() || itemStack2.m_41782_() && !itemStack2.m_41783_().m_128456_());
        }
        return false;
    }
}

