/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.manager;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiChildControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.manager.GuiManagerItem;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;

public abstract class GuiManager {
    public static final NamedHandlerRegistry<GuiManagerType> REGISTRY = new NamedHandlerRegistry<Object>(null);
    public static final GuiManagerType<GuiManagerItem> ITEM = GuiManager.register("item", GuiManagerItem.class, GuiManagerItem::new);
    public final GuiLayer layer;

    public static <T extends GuiManager> GuiManagerType<T> register(String name, Class<T> managerClass, Function<GuiLayer, T> factory) {
        GuiManagerType<T> type = new GuiManagerType<T>(name, managerClass, factory);
        REGISTRY.register(name, type);
        return type;
    }

    public GuiManager(GuiLayer layer) {
        this.layer = layer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(PoseStack pose, GuiChildControl control, Rect rect, int mouseX, int mouseY) {
    }

    public void mouseReleased(double x, double y, int button) {
    }

    public void mouseClickedOutside(double x, double y) {
    }

    public void tick() {
    }

    public void closed() {
    }

    public record GuiManagerType<T extends GuiManager>(String name, Class<T> managerClass, Function<GuiLayer, T> factory) {
    }
}

