/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.sounds;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModSounds {
    private static final DeferredRegister<SoundEvent> SOUND_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"car");
    public static RegistryObject<SoundEvent> ENGINE_STOP = ModSounds.addSound("engine_stop");
    public static RegistryObject<SoundEvent> ENGINE_STARTING = ModSounds.addSound("engine_starting");
    public static RegistryObject<SoundEvent> ENGINE_START = ModSounds.addSound("engine_start");
    public static RegistryObject<SoundEvent> ENGINE_IDLE = ModSounds.addSound("engine_idle");
    public static RegistryObject<SoundEvent> ENGINE_HIGH = ModSounds.addSound("engine_high");
    public static RegistryObject<SoundEvent> ENGINE_FAIL = ModSounds.addSound("engine_fail");
    public static RegistryObject<SoundEvent> SPORT_ENGINE_STOP = ModSounds.addSound("sport_engine_stop");
    public static RegistryObject<SoundEvent> SPORT_ENGINE_STARTING = ModSounds.addSound("sport_engine_starting");
    public static RegistryObject<SoundEvent> SPORT_ENGINE_START = ModSounds.addSound("sport_engine_start");
    public static RegistryObject<SoundEvent> SPORT_ENGINE_IDLE = ModSounds.addSound("sport_engine_idle");
    public static RegistryObject<SoundEvent> SPORT_ENGINE_HIGH = ModSounds.addSound("sport_engine_high");
    public static RegistryObject<SoundEvent> SPORT_ENGINE_FAIL = ModSounds.addSound("sport_engine_fail");
    public static RegistryObject<SoundEvent> TRUCK_ENGINE_STOP = ModSounds.addSound("truck_engine_stop");
    public static RegistryObject<SoundEvent> TRUCK_ENGINE_STARTING = ModSounds.addSound("truck_engine_starting");
    public static RegistryObject<SoundEvent> TRUCK_ENGINE_START = ModSounds.addSound("truck_engine_start");
    public static RegistryObject<SoundEvent> TRUCK_ENGINE_IDLE = ModSounds.addSound("truck_engine_idle");
    public static RegistryObject<SoundEvent> TRUCK_ENGINE_HIGH = ModSounds.addSound("truck_engine_high");
    public static RegistryObject<SoundEvent> TRUCK_ENGINE_FAIL = ModSounds.addSound("truck_engine_fail");
    public static RegistryObject<SoundEvent> CAR_CRASH = ModSounds.addSound("car_crash");
    public static RegistryObject<SoundEvent> GAS_STATION = ModSounds.addSound("gas_station");
    public static RegistryObject<SoundEvent> GENERATOR = ModSounds.addSound("generator");
    public static RegistryObject<SoundEvent> CAR_HORN = ModSounds.addSound("car_horn");
    public static RegistryObject<SoundEvent> CAR_LOCK = ModSounds.addSound("car_lock");
    public static RegistryObject<SoundEvent> CAR_UNLOCK = ModSounds.addSound("car_unlock");
    public static RegistryObject<SoundEvent> RATCHET = ModSounds.addSound("ratchet");
    public static RegistryObject<SoundEvent> GAS_STATION_ATTENDANT = ModSounds.addSound("gas_station_attendant");

    public static RegistryObject<SoundEvent> addSound(String soundName) {
        return SOUND_REGISTER.register(soundName, () -> new SoundEvent(new ResourceLocation("car", soundName)));
    }

    public static void init() {
        SOUND_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume) {
        ModSounds.playSound(evt, world, pos, entity, category, volume, 1.0f);
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category, float volume, float pitch) {
        if (entity != null) {
            world.m_5594_(entity, pos, evt, category, volume, pitch);
        } else if (!world.f_46443_) {
            world.m_6263_(null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, evt, category, volume, pitch);
        }
    }

    public static void playSound(SoundEvent evt, Level world, BlockPos pos, Player entity, SoundSource category) {
        ModSounds.playSound(evt, world, pos, entity, category, 0.15f);
    }

    public static boolean isCarSoundCategory(SoundEvent event) {
        if (event == null) {
            return false;
        }
        return event.equals(ENGINE_STOP.get()) || event.equals(ENGINE_STARTING.get()) || event.equals(ENGINE_START.get()) || event.equals(ENGINE_IDLE.get()) || event.equals(ENGINE_HIGH.get()) || event.equals(ENGINE_FAIL.get()) || event.equals(SPORT_ENGINE_STOP.get()) || event.equals(SPORT_ENGINE_STARTING.get()) || event.equals(SPORT_ENGINE_START.get()) || event.equals(SPORT_ENGINE_IDLE.get()) || event.equals(SPORT_ENGINE_HIGH.get()) || event.equals(SPORT_ENGINE_FAIL.get()) || event.equals(TRUCK_ENGINE_STOP.get()) || event.equals(TRUCK_ENGINE_STARTING.get()) || event.equals(TRUCK_ENGINE_START.get()) || event.equals(TRUCK_ENGINE_IDLE.get()) || event.equals(TRUCK_ENGINE_HIGH.get()) || event.equals(TRUCK_ENGINE_FAIL.get()) || event.equals(CAR_CRASH.get()) || event.equals(CAR_HORN.get()) || event.equals(CAR_LOCK.get()) || event.equals(CAR_UNLOCK.get());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void playSoundLoop(AbstractTickableSoundInstance loop, Level world) {
        if (world.f_46443_) {
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)loop);
        }
    }
}

