/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.car.Main;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.corelib.inventory.ScreenBase;
import de.maxhenkel.car.corelib.math.MathUtils;
import de.maxhenkel.car.entity.car.base.EntityCarBase;
import de.maxhenkel.car.entity.car.base.EntityCarDamageBase;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.tools.EntityTools;
import java.util.ArrayList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public class GuiCarWorkshopRepair
extends ScreenBase<ContainerCarWorkshopRepair> {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("car", "textures/gui/gui_car_workshop_repair.png");
    private Player player;
    private TileEntityCarWorkshop tile;
    private Button buttonBack;
    private Button buttonRepair;
    private EntityTools.CarRenderer carRenderer;

    public GuiCarWorkshopRepair(ContainerCarWorkshopRepair container, Inventory playerInventory, Component title) {
        super(GUI_TEXTURE, container, playerInventory, title);
        this.player = container.getPlayer();
        this.tile = container.getTile();
        this.carRenderer = new EntityTools.CarRenderer();
        this.f_97726_ = 176;
        this.f_97727_ = 222;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttonRepair = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + this.f_97726_ - 7 - 60, this.f_97736_ + 105, 60, 20, (Component)Component.m_237115_((String)"button.car.repair_car"), button -> {
            if (this.tile.m_58904_().f_46443_) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageRepairCar(this.tile.m_58899_(), this.player));
            }
        }));
        this.buttonRepair.f_93623_ = false;
        this.buttonBack = (Button)this.m_142416_((GuiEventListener)new Button(this.f_97735_ + 7, this.f_97736_ + 105, 60, 20, (Component)Component.m_237115_((String)"button.car.back"), button -> {
            if (this.tile.m_58904_().f_46443_) {
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageOpenCarWorkshopGui(this.tile.m_58899_(), this.player, false));
            }
        }));
        this.buttonBack.f_93623_ = true;
    }

    @Override
    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        super.m_7027_(matrixStack, mouseX, mouseY);
        this.f_96547_.m_92877_(matrixStack, this.tile.m_5446_().m_7532_(), 8.0f, 6.0f, 0x404040);
        this.f_96547_.m_92877_(matrixStack, this.player.m_150109_().m_5446_().m_7532_(), 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
        EntityCarBase carTop = this.tile.getCarOnTop();
        if (!(carTop instanceof EntityCarDamageBase)) {
            this.buttonRepair.f_93623_ = false;
            return;
        }
        EntityCarDamageBase car = (EntityCarDamageBase)carTop;
        if (mouseX >= this.f_97735_ + 52 && mouseX <= this.f_97735_ + 123 && mouseY >= this.f_97736_ + 81 && mouseY <= this.f_97736_ + 90) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            list.add(Component.m_237110_((String)"tooltip.damage", (Object[])new Object[]{Float.valueOf(MathUtils.round(car.getDamage(), 2))}).m_7532_());
            this.m_96617_(matrixStack, list, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
        this.buttonRepair.f_93623_ = this.tile.areRepairItemsInside() && car.getDamage() > 0.0f;
        this.drawCar(matrixStack, carTop);
    }

    public void m_181908_() {
        super.m_181908_();
        this.carRenderer.tick();
    }

    private void drawCar(PoseStack matrixStack, EntityCarBase car) {
        this.carRenderer.render(matrixStack, car, this.f_97726_ / 2, 55, 23);
    }

    public double getDamagePercent(EntityCarDamageBase car) {
        float dmg = car.getDamage();
        dmg = Math.min(dmg, 100.0f);
        return MathUtils.round(dmg, 2);
    }

    @Override
    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        this.drawDamage(matrixStack);
    }

    public void drawDamage(PoseStack matrixStack) {
        EntityCarBase car = this.tile.getCarOnTop();
        if (!(car instanceof EntityCarDamageBase)) {
            return;
        }
        EntityCarDamageBase c = (EntityCarDamageBase)car;
        double percent = 100.0 - this.getDamagePercent(c);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        int scaled = (int)(72.0 * percent / 100.0);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i + 52, j + 81, 176, 0, scaled, 10);
    }

    public boolean m_7043_() {
        return false;
    }
}

