/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.blocks;

import de.maxhenkel.car.ModItemGroups;
import de.maxhenkel.car.blocks.BlockBase;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.corelib.block.IItemBlock;
import de.maxhenkel.car.corelib.block.VoxelUtils;
import de.maxhenkel.car.corelib.fluid.FluidUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockFluidPipe
extends BlockBase
implements IItemBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty DOWN = BooleanProperty.m_61465_((String)"down");
    public static final BooleanProperty UP = BooleanProperty.m_61465_((String)"up");
    public static final BooleanProperty NORTH = BooleanProperty.m_61465_((String)"north");
    public static final BooleanProperty SOUTH = BooleanProperty.m_61465_((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.m_61465_((String)"west");
    public static final BooleanProperty EAST = BooleanProperty.m_61465_((String)"east");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    public static final VoxelShape SHAPE_UP = Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape SHAPE_DOWN = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    public static final VoxelShape SHAPE_CORE = Block.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);

    public BlockFluidPipe() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76272_, (MaterialColor)MaterialColor.f_76419_).m_60978_(0.25f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public Item toItem() {
        return new BlockItem((Block)this, new Item.Properties().m_41491_(ModItemGroups.TAB_CAR));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getState(context.m_43725_(), context.m_8083_());
    }

    private BlockState getState(Level world, BlockPos pos) {
        FluidState ifluidstate = world.m_6425_(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)UP, (Comparable)Boolean.valueOf(BlockFluidPipe.isConnectedTo((LevelAccessor)world, pos, Direction.UP)))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(BlockFluidPipe.isConnectedTo((LevelAccessor)world, pos, Direction.DOWN)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(BlockFluidPipe.isConnectedTo((LevelAccessor)world, pos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(BlockFluidPipe.isConnectedTo((LevelAccessor)world, pos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(BlockFluidPipe.isConnectedTo((LevelAccessor)world, pos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(BlockFluidPipe.isConnectedTo((LevelAccessor)world, pos, Direction.WEST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_205070_(FluidTags.f_13131_) && ifluidstate.m_76186_() == 8));
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos pos1, boolean b) {
        super.m_6861_(state, world, pos, block, pos1, b);
        world.m_46597_(pos, this.getState(world, pos));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        BlockState newState = state;
        newState = this.setDirection(newState, rot.m_55954_(Direction.NORTH), (Boolean)state.m_61143_((Property)NORTH));
        newState = this.setDirection(newState, rot.m_55954_(Direction.SOUTH), (Boolean)state.m_61143_((Property)SOUTH));
        newState = this.setDirection(newState, rot.m_55954_(Direction.EAST), (Boolean)state.m_61143_((Property)EAST));
        newState = this.setDirection(newState, rot.m_55954_(Direction.WEST), (Boolean)state.m_61143_((Property)WEST));
        return newState;
    }

    private BlockState setDirection(BlockState state, Direction direction, boolean connected) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(connected));
            case Direction.SOUTH -> (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(connected));
            case Direction.EAST -> (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(connected));
            case Direction.WEST -> (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(connected));
            case Direction.UP -> (BlockState)state.m_61124_((Property)UP, (Comparable)Boolean.valueOf(connected));
            case Direction.DOWN -> (BlockState)state.m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(connected));
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        BlockState newState = state;
        newState = this.setDirection(newState, mirror.m_54846_(Direction.NORTH).m_55954_(Direction.NORTH), (Boolean)state.m_61143_((Property)NORTH));
        newState = this.setDirection(newState, mirror.m_54846_(Direction.SOUTH).m_55954_(Direction.SOUTH), (Boolean)state.m_61143_((Property)SOUTH));
        newState = this.setDirection(newState, mirror.m_54846_(Direction.EAST).m_55954_(Direction.EAST), (Boolean)state.m_61143_((Property)EAST));
        newState = this.setDirection(newState, mirror.m_54846_(Direction.WEST).m_55954_(Direction.WEST), (Boolean)state.m_61143_((Property)WEST));
        return newState;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VoxelShape shape = SHAPE_CORE;
        if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_UP);
        }
        if (((Boolean)state.m_61143_((Property)DOWN)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_DOWN);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)NORTH)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_NORTH);
        }
        if (((Boolean)state.m_61143_((Property)EAST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_EAST);
        }
        if (((Boolean)state.m_61143_((Property)WEST)).booleanValue()) {
            shape = VoxelUtils.combine(shape, SHAPE_WEST);
        }
        return shape;
    }

    public static boolean isConnectedTo(LevelAccessor world, BlockPos pos, Direction facing) {
        BlockState state = world.m_8055_(pos.m_121945_(facing));
        if (state.m_60734_().equals(ModBlocks.FLUID_PIPE.get()) || state.m_60734_().equals(ModBlocks.FLUID_EXTRACTOR.get())) {
            return true;
        }
        return FluidUtils.isFluidHandlerOffset(world, pos, facing);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }
}

