/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car;

import com.google.common.collect.ImmutableSet;
import com.mojang.brigadier.CommandDispatcher;
import de.maxhenkel.car.blocks.BlockGasStation;
import de.maxhenkel.car.blocks.ModBlocks;
import de.maxhenkel.car.blocks.tileentity.TileEntityBackmixReactor;
import de.maxhenkel.car.blocks.tileentity.TileEntityBlastFurnace;
import de.maxhenkel.car.blocks.tileentity.TileEntityCable;
import de.maxhenkel.car.blocks.tileentity.TileEntityCarWorkshop;
import de.maxhenkel.car.blocks.tileentity.TileEntityDynamo;
import de.maxhenkel.car.blocks.tileentity.TileEntityFluidExtractor;
import de.maxhenkel.car.blocks.tileentity.TileEntityGasStation;
import de.maxhenkel.car.blocks.tileentity.TileEntityGenerator;
import de.maxhenkel.car.blocks.tileentity.TileEntityOilMill;
import de.maxhenkel.car.blocks.tileentity.TileEntitySign;
import de.maxhenkel.car.blocks.tileentity.TileEntitySplitTank;
import de.maxhenkel.car.blocks.tileentity.TileEntityTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSign;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererSplitTank;
import de.maxhenkel.car.blocks.tileentity.render.TileEntitySpecialRendererTank;
import de.maxhenkel.car.blocks.tileentity.render.TileentitySpecialRendererGasStation;
import de.maxhenkel.car.commands.CommandCarDemo;
import de.maxhenkel.car.config.ClientConfig;
import de.maxhenkel.car.config.FuelConfig;
import de.maxhenkel.car.config.ServerConfig;
import de.maxhenkel.car.corelib.ClientRegistry;
import de.maxhenkel.car.corelib.CommonRegistry;
import de.maxhenkel.car.corelib.config.DynamicConfig;
import de.maxhenkel.car.corelib.dataserializers.DataSerializerItemList;
import de.maxhenkel.car.entity.car.base.EntityGenericCar;
import de.maxhenkel.car.entity.model.GenericCarModel;
import de.maxhenkel.car.events.BlockEvents;
import de.maxhenkel.car.events.KeyEvents;
import de.maxhenkel.car.events.PlayerEvents;
import de.maxhenkel.car.events.RenderEvents;
import de.maxhenkel.car.events.SoundEvents;
import de.maxhenkel.car.fluids.ModFluids;
import de.maxhenkel.car.gui.ContainerBackmixReactor;
import de.maxhenkel.car.gui.ContainerBlastFurnace;
import de.maxhenkel.car.gui.ContainerCar;
import de.maxhenkel.car.gui.ContainerCarInventory;
import de.maxhenkel.car.gui.ContainerCarWorkshopCrafting;
import de.maxhenkel.car.gui.ContainerCarWorkshopRepair;
import de.maxhenkel.car.gui.ContainerFactoryTileEntity;
import de.maxhenkel.car.gui.ContainerFluidExtractor;
import de.maxhenkel.car.gui.ContainerGasStation;
import de.maxhenkel.car.gui.ContainerGasStationAdmin;
import de.maxhenkel.car.gui.ContainerGenerator;
import de.maxhenkel.car.gui.ContainerLicensePlate;
import de.maxhenkel.car.gui.ContainerOilMill;
import de.maxhenkel.car.gui.ContainerPainter;
import de.maxhenkel.car.gui.ContainerSign;
import de.maxhenkel.car.gui.ContainerSplitTank;
import de.maxhenkel.car.gui.GuiBackmixReactor;
import de.maxhenkel.car.gui.GuiBlastFurnace;
import de.maxhenkel.car.gui.GuiCar;
import de.maxhenkel.car.gui.GuiCarInventory;
import de.maxhenkel.car.gui.GuiCarWorkshopCrafting;
import de.maxhenkel.car.gui.GuiCarWorkshopRepair;
import de.maxhenkel.car.gui.GuiFluidExtractor;
import de.maxhenkel.car.gui.GuiGasStation;
import de.maxhenkel.car.gui.GuiGasStationAdmin;
import de.maxhenkel.car.gui.GuiGenerator;
import de.maxhenkel.car.gui.GuiLicensePlate;
import de.maxhenkel.car.gui.GuiOilMill;
import de.maxhenkel.car.gui.GuiPainter;
import de.maxhenkel.car.gui.GuiSign;
import de.maxhenkel.car.gui.GuiSplitTank;
import de.maxhenkel.car.integration.IMC;
import de.maxhenkel.car.items.ItemLicensePlate;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.loottable.CopyFluid;
import de.maxhenkel.car.net.MessageCarGui;
import de.maxhenkel.car.net.MessageCarHorn;
import de.maxhenkel.car.net.MessageCenterCar;
import de.maxhenkel.car.net.MessageCenterCarClient;
import de.maxhenkel.car.net.MessageControlCar;
import de.maxhenkel.car.net.MessageCrash;
import de.maxhenkel.car.net.MessageEditLicensePlate;
import de.maxhenkel.car.net.MessageEditSign;
import de.maxhenkel.car.net.MessageGasStationAdminAmount;
import de.maxhenkel.car.net.MessageOpenCarWorkshopGui;
import de.maxhenkel.car.net.MessageRepairCar;
import de.maxhenkel.car.net.MessageSpawnCar;
import de.maxhenkel.car.net.MessageStartFuel;
import de.maxhenkel.car.net.MessageStarting;
import de.maxhenkel.car.net.MessageSyncTileEntity;
import de.maxhenkel.car.recipes.BlastFurnaceRecipe;
import de.maxhenkel.car.recipes.KeyRecipe;
import de.maxhenkel.car.recipes.OilMillRecipe;
import de.maxhenkel.car.recipes.RecipeSerializerBlastFurnace;
import de.maxhenkel.car.recipes.RecipeSerializerOilMill;
import de.maxhenkel.car.sounds.ModSounds;
import de.maxhenkel.car.villagers.VillagerEvents;
import de.maxhenkel.tools.EntityTools;
import java.util.Collection;
import java.util.Set;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="car")
public class Main {
    public static final String MODID = "car";
    public static final Logger LOGGER = LogManager.getLogger((String)"car");
    public static SimpleChannel SIMPLE_CHANNEL;
    private static final DeferredRegister<EntityType<?>> ENTITY_REGISTER;
    public static final RegistryObject<EntityType<EntityGenericCar>> CAR_ENTITY_TYPE;
    public static LootItemFunctionType COPY_FLUID;
    private static final DeferredRegister<PoiType> POI_TYPE_REGISTER;
    public static final RegistryObject<PoiType> POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT;
    private static final DeferredRegister<VillagerProfession> VILLAGER_PROFESSION_REGISTER;
    public static final RegistryObject<VillagerProfession> VILLAGER_PROFESSION_GAS_STATION_ATTENDANT;
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPE_REGISTER;
    public static final RegistryObject<RecipeType<BlastFurnaceRecipe>> RECIPE_TYPE_BLAST_FURNACE;
    public static final RegistryObject<RecipeType<OilMillRecipe>> RECIPE_TYPE_OIL_MILL;
    private static final DeferredRegister<EntityDataSerializer<?>> ENTITY_DATA_SERIALIZER_REGISTER;
    public static final RegistryObject<EntityDataSerializer<NonNullList<ItemStack>>> ITEM_LIST;
    public static ServerConfig SERVER_CONFIG;
    public static FuelConfig FUEL_CONFIG;
    public static ClientConfig CLIENT_CONFIG;
    public static KeyMapping FORWARD_KEY;
    public static KeyMapping BACK_KEY;
    public static KeyMapping LEFT_KEY;
    public static KeyMapping RIGHT_KEY;
    public static KeyMapping CAR_GUI_KEY;
    public static KeyMapping START_KEY;
    public static KeyMapping HORN_KEY;
    public static KeyMapping CENTER_KEY;
    private static final DeferredRegister<MenuType<?>> MENU_TYPE_REGISTER;
    public static final RegistryObject<MenuType<ContainerBackmixReactor>> BACKMIX_REACTOR_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerBlastFurnace>> BLAST_FURNACE_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerCar>> CAR_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerCarInventory>> CAR_INVENTORY_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerCarWorkshopCrafting>> CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerCarWorkshopRepair>> CAR_WORKSHOP_REPAIR_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerFluidExtractor>> FLUID_EXTRACTOR_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerGasStation>> GAS_STATION_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerGasStationAdmin>> GAS_STATION_ADMIN_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerGenerator>> GENERATOR_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerLicensePlate>> LICENSE_PLATE_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerOilMill>> OIL_MILL_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerPainter>> PAINTER_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerSign>> SIGN_CONTAINER_TYPE;
    public static final RegistryObject<MenuType<ContainerSplitTank>> SPLIT_TANK_CONTAINER_TYPE;
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_REGISTER;
    public static final RegistryObject<BlockEntityType<TileEntityGenerator>> GENERATOR_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityBackmixReactor>> BACKMIX_REACTOR_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityBlastFurnace>> BLAST_FURNACE_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityCable>> CABLE_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityCarWorkshop>> CAR_WORKSHOP_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityDynamo>> DYNAMO_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityFluidExtractor>> FLUID_EXTRACTOR_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityOilMill>> OIL_MILL_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntitySign>> SIGN_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntitySplitTank>> SPLIT_TANK_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityTank>> TANK_TILE_ENTITY_TYPE;
    public static final RegistryObject<BlockEntityType<TileEntityGasStation>> GAS_STATION_TILE_ENTITY_TYPE;
    private static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZER_REGISTER;
    public static final RegistryObject<RecipeSerializer<KeyRecipe>> CRAFTING_SPECIAL_KEY;
    public static final RegistryObject<RecipeSerializer<BlastFurnaceRecipe>> CRAFTING_BLAST_FURNACE;
    public static final RegistryObject<RecipeSerializer<OilMillRecipe>> CRAFTING_OIL_MILL;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(IMC::enqueueIMC);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class, true);
        FUEL_CONFIG = CommonRegistry.registerDynamicConfig(DynamicConfig.DynamicConfigType.SERVER, MODID, "fuel", FuelConfig.class);
        CLIENT_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.CLIENT, ClientConfig.class);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterKeyBinds);
        });
        ModFluids.init();
        ModBlocks.init();
        ModItems.init();
        ModSounds.init();
        MENU_TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCK_ENTITY_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITY_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        RECIPE_TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        RECIPE_SERIALIZER_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        POI_TYPE_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        VILLAGER_PROFESSION_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
        ENTITY_DATA_SERIALIZER_REGISTER.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandCarDemo.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)new VillagerEvents());
        COPY_FLUID = (LootItemFunctionType)Registry.m_122965_((Registry)Registry.f_122876_, (ResourceLocation)new ResourceLocation(MODID, "copy_fluid"), (Object)new LootItemFunctionType((Serializer)new CopyFluid.Serializer()));
        SIMPLE_CHANNEL = CommonRegistry.registerChannel(MODID, "default");
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 0, MessageControlCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 1, MessageCarGui.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 2, MessageStarting.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 3, MessageCrash.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 4, MessageStartFuel.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 6, MessageSyncTileEntity.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 7, MessageSpawnCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 8, MessageOpenCarWorkshopGui.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 9, MessageRepairCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 10, MessageCarHorn.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 11, MessageEditSign.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 12, MessageGasStationAdminAmount.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 13, MessageCenterCar.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 14, MessageCenterCarClient.class);
        CommonRegistry.registerMessage(SIMPLE_CHANNEL, 15, MessageEditLicensePlate.class);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CANOLA_SEEDS.get()), 0.3f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CANOLA_CAKE.get()), 0.5f);
        ComposterBlock.f_51914_.put((Object)((ItemLike)ModItems.CANOLA.get()), 0.65f);
        Villager.f_35372_ = ImmutableSet.builder().addAll((Iterable)Villager.f_35372_).add((Object)((Item)ModItems.CANOLA_SEEDS.get())).add((Object)((Item)ModItems.CANOLA.get())).build();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)GAS_STATION_TILE_ENTITY_TYPE.get()), TileentitySpecialRendererGasStation::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SPLIT_TANK_TILE_ENTITY_TYPE.get()), TileEntitySpecialRendererSplitTank::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)TANK_TILE_ENTITY_TYPE.get()), TileEntitySpecialRendererTank::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)SIGN_TILE_ENTITY_TYPE.get()), TileEntitySpecialRendererSign::new);
        ClientRegistry.registerScreen((MenuType)BACKMIX_REACTOR_CONTAINER_TYPE.get(), GuiBackmixReactor::new);
        ClientRegistry.registerScreen((MenuType)BLAST_FURNACE_CONTAINER_TYPE.get(), GuiBlastFurnace::new);
        ClientRegistry.registerScreen((MenuType)CAR_CONTAINER_TYPE.get(), GuiCar::new);
        ClientRegistry.registerScreen((MenuType)CAR_INVENTORY_CONTAINER_TYPE.get(), GuiCarInventory::new);
        ClientRegistry.registerScreen((MenuType)CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE.get(), GuiCarWorkshopCrafting::new);
        ClientRegistry.registerScreen((MenuType)CAR_WORKSHOP_REPAIR_CONTAINER_TYPE.get(), GuiCarWorkshopRepair::new);
        ClientRegistry.registerScreen((MenuType)FLUID_EXTRACTOR_CONTAINER_TYPE.get(), GuiFluidExtractor::new);
        ClientRegistry.registerScreen((MenuType)GAS_STATION_CONTAINER_TYPE.get(), GuiGasStation::new);
        ClientRegistry.registerScreen((MenuType)GAS_STATION_ADMIN_CONTAINER_TYPE.get(), GuiGasStationAdmin::new);
        ClientRegistry.registerScreen((MenuType)GENERATOR_CONTAINER_TYPE.get(), GuiGenerator::new);
        ClientRegistry.registerScreen((MenuType)LICENSE_PLATE_CONTAINER_TYPE.get(), GuiLicensePlate::new);
        ClientRegistry.registerScreen((MenuType)OIL_MILL_CONTAINER_TYPE.get(), GuiOilMill::new);
        ClientRegistry.registerScreen((MenuType)PAINTER_CONTAINER_TYPE.get(), GuiPainter::new);
        ClientRegistry.registerScreen((MenuType)SIGN_CONTAINER_TYPE.get(), GuiSign::new);
        ClientRegistry.registerScreen((MenuType)SPLIT_TANK_CONTAINER_TYPE.get(), GuiSplitTank::new);
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new SoundEvents());
        MinecraftForge.EVENT_BUS.register((Object)new KeyEvents());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEvents());
        EntityRenderers.m_174036_((EntityType)((EntityType)CAR_ENTITY_TYPE.get()), GenericCarModel::new);
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.CANOLA_OIL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.CANOLA_OIL_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.METHANOL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.METHANOL_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.CANOLA_METHANOL_MIX.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.CANOLA_METHANOL_MIX_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.GLYCERIN.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.GLYCERIN_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.BIO_DIESEL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModFluids.BIO_DIESEL_FLOWING.get()), (RenderType)RenderType.m_110466_());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onRegisterKeyBinds(RegisterKeyMappingsEvent event) {
        FORWARD_KEY = new KeyMapping("key.car_forward", 87, "category.car");
        BACK_KEY = new KeyMapping("key.car_back", 83, "category.car");
        LEFT_KEY = new KeyMapping("key.car_left", 65, "category.car");
        RIGHT_KEY = new KeyMapping("key.car_right", 68, "category.car");
        CAR_GUI_KEY = new KeyMapping("key.car_gui", 73, "category.car");
        START_KEY = new KeyMapping("key.car_start", 82, "category.car");
        HORN_KEY = new KeyMapping("key.car_horn", 72, "category.car");
        CENTER_KEY = new KeyMapping("key.center_car", 32, "category.car");
        event.register(FORWARD_KEY);
        event.register(BACK_KEY);
        event.register(LEFT_KEY);
        event.register(RIGHT_KEY);
        event.register(CAR_GUI_KEY);
        event.register(START_KEY);
        event.register(HORN_KEY);
        event.register(CENTER_KEY);
    }

    private static EntityType<EntityGenericCar> createCarEntityType() {
        return CommonRegistry.registerEntity(MODID, MODID, MobCategory.MISC, EntityGenericCar.class, builder -> builder.setTrackingRange(128).setUpdateInterval(1).setShouldReceiveVelocityUpdates(true).m_20699_(1.0f, 1.0f).setCustomClientFactory((spawnEntity, world) -> new EntityGenericCar((Level)world)));
    }

    static {
        ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)MODID);
        CAR_ENTITY_TYPE = ENTITY_REGISTER.register(MODID, Main::createCarEntityType);
        POI_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)MODID);
        POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT = POI_TYPE_REGISTER.register("gas_station_attendant", () -> new PoiType((Set)ImmutableSet.copyOf((Collection)((BlockGasStation)ModBlocks.GAS_STATION.get()).m_49965_().m_61056_()), 1, 1));
        VILLAGER_PROFESSION_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.VILLAGER_PROFESSIONS, (String)MODID);
        VILLAGER_PROFESSION_GAS_STATION_ATTENDANT = VILLAGER_PROFESSION_REGISTER.register("gas_station_attendant", () -> new VillagerProfession("gas_station_attendant", poi -> poi.m_203565_(POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT.getKey()), poi -> poi.m_203565_(POINT_OF_INTEREST_TYPE_GAS_STATION_ATTENDANT.getKey()), ImmutableSet.of(), ImmutableSet.of(), (SoundEvent)ModSounds.GAS_STATION_ATTENDANT.get()));
        RECIPE_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)MODID);
        RECIPE_TYPE_BLAST_FURNACE = RECIPE_TYPE_REGISTER.register("blast_furnace", () -> new RecipeType<BlastFurnaceRecipe>(){});
        RECIPE_TYPE_OIL_MILL = RECIPE_TYPE_REGISTER.register("oil_mill", () -> new RecipeType<OilMillRecipe>(){});
        ENTITY_DATA_SERIALIZER_REGISTER = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ENTITY_DATA_SERIALIZERS, (String)MODID);
        ITEM_LIST = ENTITY_DATA_SERIALIZER_REGISTER.register("serializer_item_list", () -> DataSerializerItemList.create());
        MENU_TYPE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)MODID);
        BACKMIX_REACTOR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("backmix_reactor", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerBackmixReactor, TileEntityBackmixReactor>(ContainerBackmixReactor::new)));
        BLAST_FURNACE_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("blast_furnace", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerBlastFurnace, TileEntityBlastFurnace>(ContainerBlastFurnace::new)));
        CAR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register(MODID, () -> IForgeMenuType.create((windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.f_35978_, data.m_130259_());
            if (car == null) {
                return null;
            }
            return new ContainerCar(windowId, car, inv);
        }));
        CAR_INVENTORY_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("car_inventory", () -> IForgeMenuType.create((windowId, inv, data) -> {
            EntityGenericCar car = EntityTools.getCarByUUID(inv.f_35978_, data.m_130259_());
            if (car == null) {
                return null;
            }
            return new ContainerCarInventory(windowId, car, inv);
        }));
        CAR_WORKSHOP_CRAFTING_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("car_workshop_crafting", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerCarWorkshopCrafting, TileEntityCarWorkshop>(ContainerCarWorkshopCrafting::new)));
        CAR_WORKSHOP_REPAIR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("car_workshop_repair", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerCarWorkshopRepair, TileEntityCarWorkshop>(ContainerCarWorkshopRepair::new)));
        FLUID_EXTRACTOR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("fluid_extractor", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerFluidExtractor, TileEntityFluidExtractor>(ContainerFluidExtractor::new)));
        GAS_STATION_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("gas_station", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerGasStation, TileEntityGasStation>(ContainerGasStation::new)));
        GAS_STATION_ADMIN_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("gas_station_admin", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerGasStationAdmin, TileEntityGasStation>(ContainerGasStationAdmin::new)));
        GENERATOR_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("generator", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerGenerator, TileEntityGenerator>(ContainerGenerator::new)));
        LICENSE_PLATE_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("license_plate", () -> IForgeMenuType.create((windowId, inv, data) -> {
            ItemStack licensePlate = null;
            for (InteractionHand hand : InteractionHand.values()) {
                ItemStack stack = inv.f_35978_.m_21120_(hand);
                if (!(stack.m_41720_() instanceof ItemLicensePlate)) continue;
                licensePlate = stack;
                break;
            }
            if (licensePlate != null) {
                return new ContainerLicensePlate(windowId, licensePlate);
            }
            return null;
        }));
        OIL_MILL_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("oil_mill", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerOilMill, TileEntityOilMill>(ContainerOilMill::new)));
        PAINTER_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("painter", () -> IForgeMenuType.create((windowId, inv, data) -> new ContainerPainter(windowId, inv, data.readBoolean())));
        SIGN_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("sign", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerSign, TileEntitySign>(ContainerSign::new)));
        SPLIT_TANK_CONTAINER_TYPE = MENU_TYPE_REGISTER.register("split_tank", () -> IForgeMenuType.create(new ContainerFactoryTileEntity<ContainerSplitTank, TileEntitySplitTank>(ContainerSplitTank::new)));
        BLOCK_ENTITY_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)MODID);
        GENERATOR_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("generator", () -> BlockEntityType.Builder.m_155273_(TileEntityGenerator::new, (Block[])new Block[]{(Block)ModBlocks.GENERATOR.get()}).m_58966_(null));
        BACKMIX_REACTOR_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("backmix_reactor", () -> BlockEntityType.Builder.m_155273_(TileEntityBackmixReactor::new, (Block[])new Block[]{(Block)ModBlocks.BACKMIX_REACTOR.get()}).m_58966_(null));
        BLAST_FURNACE_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("blast_furnace", () -> BlockEntityType.Builder.m_155273_(TileEntityBlastFurnace::new, (Block[])new Block[]{(Block)ModBlocks.BLAST_FURNACE.get()}).m_58966_(null));
        CABLE_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("cable", () -> BlockEntityType.Builder.m_155273_(TileEntityCable::new, (Block[])new Block[]{(Block)ModBlocks.CABLE.get()}).m_58966_(null));
        CAR_WORKSHOP_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("car_workshop", () -> BlockEntityType.Builder.m_155273_(TileEntityCarWorkshop::new, (Block[])new Block[]{(Block)ModBlocks.CAR_WORKSHOP.get()}).m_58966_(null));
        DYNAMO_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("dynamo", () -> BlockEntityType.Builder.m_155273_(TileEntityDynamo::new, (Block[])new Block[]{(Block)ModBlocks.DYNAMO.get()}).m_58966_(null));
        FLUID_EXTRACTOR_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("fluid_extractor", () -> BlockEntityType.Builder.m_155273_(TileEntityFluidExtractor::new, (Block[])new Block[]{(Block)ModBlocks.FLUID_EXTRACTOR.get()}).m_58966_(null));
        OIL_MILL_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("oil_mill", () -> BlockEntityType.Builder.m_155273_(TileEntityOilMill::new, (Block[])new Block[]{(Block)ModBlocks.OIL_MILL.get()}).m_58966_(null));
        SIGN_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("sign", () -> BlockEntityType.Builder.m_155273_(TileEntitySign::new, (Block[])new Block[]{(Block)ModBlocks.SIGN.get()}).m_58966_(null));
        SPLIT_TANK_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("split_tank", () -> BlockEntityType.Builder.m_155273_(TileEntitySplitTank::new, (Block[])new Block[]{(Block)ModBlocks.SPLIT_TANK.get()}).m_58966_(null));
        TANK_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("tank", () -> BlockEntityType.Builder.m_155273_(TileEntityTank::new, (Block[])new Block[]{(Block)ModBlocks.TANK.get()}).m_58966_(null));
        GAS_STATION_TILE_ENTITY_TYPE = BLOCK_ENTITY_REGISTER.register("gas_station", () -> BlockEntityType.Builder.m_155273_(TileEntityGasStation::new, (Block[])new Block[]{(Block)ModBlocks.GAS_STATION.get()}).m_58966_(null));
        RECIPE_SERIALIZER_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)MODID);
        CRAFTING_SPECIAL_KEY = RECIPE_SERIALIZER_REGISTER.register("crafting_special_key", () -> new SimpleRecipeSerializer(KeyRecipe::new));
        CRAFTING_BLAST_FURNACE = RECIPE_SERIALIZER_REGISTER.register("blast_furnace", () -> new RecipeSerializerBlastFurnace(BlastFurnaceRecipe::new));
        CRAFTING_OIL_MILL = RECIPE_SERIALIZER_REGISTER.register("oil_mill", () -> new RecipeSerializerOilMill(OilMillRecipe::new));
    }
}

