/*
 * Decompiled with CFR 0.152.
 */
package mtr.sound.bve;

import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import mtr.MTRClient;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.TrainClient;
import mtr.sound.TrainLoopingSoundInstance;
import mtr.sound.TrainSoundBase;
import mtr.sound.bve.BveTrainSoundConfig;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;

public class BveTrainSound
extends TrainSoundBase {
    private float accelLastElapsed;
    private boolean onRouteLastElapsed = false;
    private float motorCurrentOutput = 0.0f;
    private float motorBreakerTimer = -1.0f;
    private int mrPress;
    private boolean isCompressorActive;
    private boolean isCompressorActiveLastElapsed;
    private final TrainClient train;
    public final BveTrainSoundConfig config;
    private final TrainLoopingSoundInstance[] soundLoopMotor;
    private final TrainLoopingSoundInstance soundLoopRun;
    private final TrainLoopingSoundInstance soundLoopFlange;
    private final TrainLoopingSoundInstance soundLoopNoise;
    private final TrainLoopingSoundInstance soundLoopShoe;
    private final TrainLoopingSoundInstance soundLoopCompressor;
    private final int[][] bogieRailId;

    private BveTrainSound(BveTrainSoundConfig config, TrainClient train) {
        this.config = config;
        this.train = train;
        if (train == null) {
            this.soundLoopMotor = new TrainLoopingSoundInstance[0];
            this.soundLoopRun = null;
            this.soundLoopFlange = null;
            this.soundLoopNoise = null;
            this.soundLoopShoe = null;
            this.soundLoopCompressor = null;
            this.bogieRailId = new int[0][0];
        } else {
            this.bogieRailId = new int[train.trainCars][2];
            this.mrPress = ThreadLocalRandom.current().nextInt(config.soundCfg.mrPressMin, config.soundCfg.mrPressMax + 1);
            this.isCompressorActiveLastElapsed = this.isCompressorActive = ThreadLocalRandom.current().nextInt(0, 20) == 0;
            this.soundLoopRun = config.soundCfg.run[0] == null ? null : new TrainLoopingSoundInstance(config.soundCfg.run[0], train);
            this.soundLoopFlange = config.soundCfg.flange[0] == null ? null : new TrainLoopingSoundInstance(config.soundCfg.flange[0], train);
            this.soundLoopNoise = config.soundCfg.noise == null ? null : new TrainLoopingSoundInstance(config.soundCfg.noise, train);
            this.soundLoopShoe = config.soundCfg.shoe == null ? null : new TrainLoopingSoundInstance(config.soundCfg.shoe, train);
            this.soundLoopCompressor = config.soundCfg.compressorLoop == null ? null : new TrainLoopingSoundInstance(config.soundCfg.compressorLoop, train);
            this.soundLoopMotor = new TrainLoopingSoundInstance[config.soundCfg.motor.length];
            for (int i = 0; i < Math.min(config.soundCfg.motor.length, config.motorData.getSoundCount()); ++i) {
                if (config.soundCfg.motor[i] == null) continue;
                this.soundLoopMotor[i] = new TrainLoopingSoundInstance(config.soundCfg.motor[i], train);
            }
        }
    }

    public BveTrainSound(BveTrainSoundConfig config) {
        this(config, null);
    }

    @Override
    public TrainSoundBase createTrainInstance(TrainClient train) {
        return new BveTrainSound(this.config, train);
    }

    @Override
    public void playNearestCar(Level world, BlockPos pos, int carIndex) {
        float motorTarget;
        if (this.train == null) {
            return;
        }
        float deltaT = MTRClient.getLastFrameDuration() / 20.0f;
        float speed = this.train.getSpeed() * 20.0f;
        float accel = this.train.speedChange() / deltaT;
        float speedKph = speed * 3.6f;
        if (this.soundLoopRun != null) {
            this.soundLoopRun.setData(Math.min(1.0f, speed * 0.04f), speed * 0.04f, pos);
        }
        if ((motorTarget = Math.signum(accel)) == 0.0f && speed != 0.0f) {
            motorTarget = this.config.soundCfg.motorOutputAtCoast;
        }
        if (motorTarget < 0.0f && speed < this.config.soundCfg.regenerationLimit) {
            this.motorCurrentOutput = 0.0f;
            this.motorBreakerTimer = -1.0f;
        } else if (motorTarget > 0.0f && speed < 1.0f) {
            this.motorCurrentOutput = 1.0f;
            this.motorBreakerTimer = -1.0f;
        } else if (motorTarget != this.motorCurrentOutput && this.motorBreakerTimer < 0.0f) {
            this.motorBreakerTimer = 0.0f;
            if (motorTarget != 0.0f && this.motorCurrentOutput != 0.0f) {
                this.motorCurrentOutput = 0.0f;
            }
        }
        if (this.motorBreakerTimer >= 0.0f) {
            this.motorBreakerTimer += deltaT;
            if (this.motorBreakerTimer > this.config.soundCfg.breakerDelay) {
                this.motorBreakerTimer = -1.0f;
                this.motorCurrentOutput = motorTarget;
            }
        }
        if (this.mrPress <= this.config.soundCfg.mrPressMin) {
            this.isCompressorActive = true;
            this.mrPress = this.config.soundCfg.mrPressMin;
        } else if (this.mrPress >= this.config.soundCfg.mrPressMax) {
            this.isCompressorActive = false;
            this.mrPress = this.config.soundCfg.mrPressMax;
        }
        if (this.isCompressorActive) {
            float f = this.mrPress;
            Objects.requireNonNull(this.config.soundCfg);
            this.mrPress = (int)(f + deltaT * 5.0f);
        }
        if (this.soundLoopCompressor != null) {
            this.soundLoopCompressor.setData(this.isCompressorActive ? 1.0f : 0.0f, 1.0f, pos);
        }
        if (this.isCompressorActive && !this.isCompressorActiveLastElapsed) {
            BveTrainSound.playLocalSound(world, this.config.soundCfg.compressorAttack, pos);
        } else if (!this.isCompressorActive && this.isCompressorActiveLastElapsed) {
            BveTrainSound.playLocalSound(world, this.config.soundCfg.compressorRelease, pos);
        }
        for (int i = 0; i < this.config.motorData.getSoundCount(); ++i) {
            if (this.soundLoopMotor[i] == null) continue;
            this.soundLoopMotor[i].setData(this.config.motorData.getVolume(i, speedKph, this.motorCurrentOutput) * this.config.soundCfg.motorVolumeMultiply, this.config.motorData.getPitch(i, speedKph, this.motorCurrentOutput), pos);
        }
        if (this.soundLoopFlange != null) {
            this.soundLoopFlange.setData(0.0f, 1.0f, pos);
        }
        if (this.soundLoopShoe != null) {
            float shoeGain;
            float shoePitch = 1.0f / (speed + 1.0f) + 1.0f;
            float f = shoeGain = speed < this.config.soundCfg.regenerationLimit && accel < 0.0f ? 1.0f : 0.0f;
            if ((double)speed < 1.39) {
                double t = speed * speed;
                shoeGain = (float)((double)shoeGain * (1.5552 * t - 0.746496 * (double)speed * t));
            } else if ((double)speed > 12.5) {
                double t = (double)speed - 12.5;
                shoeGain = (float)((double)shoeGain * (1.0 / (0.1 * t * t + 1.0)));
            }
            this.soundLoopShoe.setData(shoeGain, shoePitch, pos);
        }
        if (this.soundLoopNoise != null) {
            this.soundLoopNoise.setData(this.train.getIsOnRoute() ? 1.0f : 0.0f, 1.0f, pos);
        }
        if (this.accelLastElapsed < 0.0f && accel >= 0.0f) {
            BveTrainSound.playLocalSound(world, this.config.soundCfg.brakeHandleRelease, pos);
            if (speed < this.config.soundCfg.regenerationLimit) {
                BveTrainSound.playLocalSound(world, this.config.soundCfg.airZero, pos);
            }
        } else if (this.accelLastElapsed <= 0.0f && accel > 0.0f && (double)speed < 0.3) {
            BveTrainSound.playLocalSound(world, this.config.soundCfg.airHigh, pos);
        } else if (this.accelLastElapsed >= 0.0f && accel < 0.0f) {
            float f = this.mrPress;
            Objects.requireNonNull(this.config.soundCfg);
            this.mrPress = (int)(f - 5.0f);
            BveTrainSound.playLocalSound(world, this.config.soundCfg.brakeHandleApply, pos);
        }
        if (this.onRouteLastElapsed && !this.train.getIsOnRoute()) {
            BveTrainSound.playLocalSound(world, this.config.soundCfg.brakeEmergency, pos);
        }
        this.accelLastElapsed = accel;
        this.onRouteLastElapsed = this.train.getIsOnRoute();
        this.isCompressorActiveLastElapsed = this.isCompressorActive;
    }

    @Override
    public void playAllCars(Level world, BlockPos pos, int carIndex) {
        int indexRear;
        int indexFront;
        float gain;
        float bogieOffsetRear;
        float bogieOffsetFront;
        if (this.train == null) {
            return;
        }
        TrainProperties trainProperties = TrainClientRegistry.getTrainProperties(this.train.trainId);
        if (this.config.soundCfg.joint[0] == null || trainProperties.bogiePosition == 0.0f) {
            return;
        }
        if (trainProperties.isJacobsBogie) {
            if (carIndex == 0) {
                bogieOffsetFront = (float)this.train.spacing / 2.0f - trainProperties.bogiePosition;
                bogieOffsetRear = -1.0f;
            } else if (carIndex == this.train.trainCars - 1) {
                bogieOffsetFront = 0.0f;
                bogieOffsetRear = (float)this.train.spacing / 2.0f + trainProperties.bogiePosition;
            } else {
                bogieOffsetFront = 0.0f;
                bogieOffsetRear = -1.0f;
            }
        } else {
            bogieOffsetFront = (float)this.train.spacing / 2.0f - trainProperties.bogiePosition;
            bogieOffsetRear = (float)this.train.spacing / 2.0f + trainProperties.bogiePosition;
        }
        float pitch = this.train.getSpeed() * 20.0f / 12.5f;
        float f = gain = pitch < 0.5f ? 2.0f * pitch : 1.0f;
        if (bogieOffsetFront >= 0.0f && (indexFront = this.train.getIndex(this.train.getRailProgress() - (double)(this.train.spacing * carIndex) - (double)bogieOffsetFront, false)) != this.bogieRailId[carIndex][0]) {
            this.bogieRailId[carIndex][0] = indexFront;
            BveTrainSound.playLocalSound(world, this.config.soundCfg.joint[0], pos, gain, pitch);
        }
        if (bogieOffsetRear >= 0.0f && (indexRear = this.train.getIndex(this.train.getRailProgress() - (double)(this.train.spacing * carIndex) - (double)bogieOffsetRear, false)) != this.bogieRailId[carIndex][1]) {
            this.bogieRailId[carIndex][1] = indexRear;
            BveTrainSound.playLocalSound(world, this.config.soundCfg.joint[0], pos, gain, pitch);
        }
    }

    @Override
    public void playAllCarsDoorOpening(Level world, BlockPos pos, int carIndex) {
        if (!(world instanceof ClientLevel) || this.train == null) {
            return;
        }
        Object soundEvent = this.train.justOpening() && this.config.soundCfg.doorOpen != null ? this.config.soundCfg.doorOpen : (this.train.justClosing(this.config.soundCfg.doorCloseSoundLength) && this.config.soundCfg.doorClose != null ? this.config.soundCfg.doorClose : null);
        BveTrainSound.playLocalSound(world, soundEvent, pos);
    }

    private static void playLocalSound(Level world, SoundEvent event, BlockPos pos, float gain, float pitch) {
        if (event == null) {
            return;
        }
        ((ClientLevel)world).m_104677_(pos, event, SoundSource.BLOCKS, Math.min(1.0f, gain), pitch, true);
    }

    private static void playLocalSound(Level world, SoundEvent event, BlockPos pos) {
        if (event == null) {
            return;
        }
        ((ClientLevel)world).m_104677_(pos, event, SoundSource.BLOCKS, 1.0f, 1.0f, true);
    }
}

