/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Locale;
import java.util.Random;
import java.util.function.Consumer;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.mappings.ButtonMapper;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.StringUtils;

public class WidgetColorSelector
extends ButtonMapper
implements IGui {
    private int color;
    private final ScreenMapper screen;
    private final Runnable callback;

    public WidgetColorSelector(ScreenMapper screen, Runnable callback) {
        super(0, 0, 0, 20, (Component)Text.literal(""), button -> {});
        this.screen = screen;
        this.callback = callback;
    }

    public void m_6303_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        super.m_6303_(matrices, mouseX, mouseY, delta);
        Gui.m_93172_((PoseStack)matrices, (int)(UtilitiesClient.getWidgetX((AbstractWidget)this) - 1), (int)(UtilitiesClient.getWidgetY((AbstractWidget)this) - 1), (int)(UtilitiesClient.getWidgetX((AbstractWidget)this) + this.f_93618_ + 1), (int)(UtilitiesClient.getWidgetY((AbstractWidget)this) + this.f_93619_ + 1), (int)(0xFF000000 | this.color));
    }

    public void m_5691_() {
        UtilitiesClient.setScreen(Minecraft.m_91087_(), new ColorSelectorScreen(this.color, color -> {
            UtilitiesClient.setScreen(Minecraft.m_91087_(), this.screen);
            this.setColor((int)color);
            this.callback.run();
        }));
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int newColor) {
        int clampedColor = (newColor & 0xFFFFFF) == 0 ? new Random().nextInt(0x1000000) : newColor & 0xFFFFFF;
        this.color = clampedColor;
    }

    private static class ColorSelectorScreen
    extends ScreenMapper {
        private float hue;
        private float saturation;
        private float brightness;
        private DraggingState draggingState = DraggingState.NONE;
        private final int oldColor;
        private final Consumer<Integer> colorCallback;
        private final WidgetBetterTextField textFieldColor;
        private final WidgetBetterTextField textFieldRed;
        private final WidgetBetterTextField textFieldGreen;
        private final WidgetBetterTextField textFieldBlue;
        private final Button buttonReset;
        private static final int RIGHT_WIDTH = 60;

        private ColorSelectorScreen(int oldColor, Consumer<Integer> colorCallback) {
            super((Component)Text.literal(""));
            this.oldColor = oldColor;
            this.colorCallback = colorCallback;
            this.textFieldColor = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.HEX, Text.literal(Integer.toHexString(oldColor).toUpperCase(Locale.ENGLISH)).getString(), 6);
            this.textFieldRed = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, Text.literal(String.valueOf(oldColor >> 16 & 0xFF)).getString(), 3);
            this.textFieldGreen = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, Text.literal(String.valueOf(oldColor >> 8 & 0xFF)).getString(), 3);
            this.textFieldBlue = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, Text.literal(String.valueOf(oldColor & 0xFF)).getString(), 3);
            this.buttonReset = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.reset_sign", new Object[0]), button -> {
                this.setHsb(oldColor, true);
                button.f_93623_ = false;
            });
        }

        protected void m_7856_() {
            super.m_7856_();
            int startX = 80 + this.getMainWidth();
            int startY = 36;
            IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldColor, startX + 2, 36, 56);
            IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldRed, startX + 2, 80, 56);
            IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldGreen, startX + 2, 104, 56);
            IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldBlue, startX + 2, 128, 56);
            IDrawing.setPositionAndWidth((AbstractWidget)this.buttonReset, startX, this.getMainHeight(), 60);
            this.setHsb(this.oldColor, true);
            this.textFieldColor.m_94151_(text -> this.textCallback((String)text, -1));
            this.textFieldRed.m_94151_(text -> this.textCallback((String)text, 16));
            this.textFieldGreen.m_94151_(text -> this.textCallback((String)text, 8));
            this.textFieldBlue.m_94151_(text -> this.textCallback((String)text, 0));
            this.addDrawableChild(this.textFieldColor);
            this.addDrawableChild(this.textFieldRed);
            this.addDrawableChild(this.textFieldGreen);
            this.addDrawableChild(this.textFieldBlue);
            this.addDrawableChild(this.buttonReset);
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            try {
                this.m_7333_(matrices);
                super.m_6305_(matrices, mouseX, mouseY, delta);
                int mainWidth = this.getMainWidth();
                int mainHeight = this.getMainHeight();
                ColorSelectorScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.color", new Object[0]), (int)(80 + mainWidth + 30), (int)20, (int)-1);
                ColorSelectorScreen.m_93208_((PoseStack)matrices, (Font)this.f_96547_, (String)"RGB", (int)(80 + mainWidth + 30), (int)64, (int)-1);
                Tesselator tesselator = Tesselator.m_85913_();
                BufferBuilder buffer = tesselator.m_85915_();
                UtilitiesClient.beginDrawingRectangle(buffer);
                int selectedColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness);
                IDrawing.drawRectangle((VertexConsumer)buffer, 80 + mainWidth + 1, 157.0, 80 + mainWidth + 60 - 1, mainHeight - 1, selectedColor);
                for (int drawHue = 0; drawHue < mainHeight; ++drawHue) {
                    int color = Color.HSBtoRGB((float)drawHue / (float)(mainHeight - 1), 1.0f, 1.0f);
                    IDrawing.drawRectangle((VertexConsumer)buffer, 40 + mainWidth, 20 + drawHue, 60 + mainWidth, 20 + drawHue + 1, color);
                }
                for (int drawSaturation = 0; drawSaturation < mainWidth; ++drawSaturation) {
                    for (int drawBrightness = 0; drawBrightness < mainHeight; ++drawBrightness) {
                        int color = Color.HSBtoRGB(this.hue, (float)drawSaturation / (float)(mainWidth - 1), (float)drawBrightness / (float)(mainHeight - 1));
                        IDrawing.drawRectangle((VertexConsumer)buffer, 20 + drawSaturation, 20 + mainHeight - drawBrightness - 1, 20 + drawSaturation + 1, 20 + mainHeight - drawBrightness, color);
                    }
                }
                int selectedHueInt = Math.round(this.hue * (float)(mainHeight - 1));
                int selectedSaturationInt = Math.round(this.saturation * (float)(mainWidth - 1));
                int selectedBrightnessInt = Math.round(this.brightness * (float)(mainHeight - 1));
                IDrawing.drawRectangle((VertexConsumer)buffer, 40 + mainWidth, 20 + selectedHueInt - 1, 60 + mainWidth, 20 + selectedHueInt + 2, -16777216);
                IDrawing.drawRectangle((VertexConsumer)buffer, 40 + mainWidth, 20 + selectedHueInt, 60 + mainWidth, 20 + selectedHueInt + 1, -1);
                IDrawing.drawRectangle((VertexConsumer)buffer, 20 + selectedSaturationInt - 1, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 2, 20 + mainHeight - selectedBrightnessInt, -16777216);
                IDrawing.drawRectangle((VertexConsumer)buffer, 20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 2, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt + 1, -16777216);
                IDrawing.drawRectangle((VertexConsumer)buffer, 20 + selectedSaturationInt, 20 + mainHeight - selectedBrightnessInt - 1, 20 + selectedSaturationInt + 1, 20 + mainHeight - selectedBrightnessInt, -1);
                tesselator.m_85914_();
                UtilitiesClient.finishDrawingRectangle();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void m_86600_() {
            this.textFieldRed.m_94120_();
            this.textFieldGreen.m_94120_();
            this.textFieldBlue.m_94120_();
            this.textFieldColor.m_94120_();
        }

        public void m_7379_() {
            this.colorCallback.accept(Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            this.draggingState = DraggingState.NONE;
            if (mouseY >= 20.0 && mouseY < (double)(20 + mainHeight)) {
                if (mouseX >= 20.0 && mouseX < (double)(20 + mainWidth)) {
                    this.draggingState = DraggingState.SATURATION_BRIGHTNESS;
                } else if (mouseX >= (double)(40 + mainWidth) && mouseX < (double)(60 + mainWidth)) {
                    this.draggingState = DraggingState.HUE;
                }
            }
            this.selectColor(mouseX, mouseY);
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            this.selectColor(mouseX, mouseY);
            return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        private void selectColor(double mouseX, double mouseY) {
            int mainWidth = this.getMainWidth();
            int mainHeight = this.getMainHeight();
            switch (this.draggingState) {
                case SATURATION_BRIGHTNESS: {
                    this.saturation = (float)Mth.m_14008_((double)((mouseX - 20.0) / (double)mainWidth), (double)0.0, (double)1.0);
                    this.brightness = 1.0f - (float)Mth.m_14008_((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                    break;
                }
                case HUE: {
                    this.hue = (float)Mth.m_14008_((double)((mouseY - 20.0) / (double)mainHeight), (double)0.0, (double)1.0);
                    this.setColorText(Color.HSBtoRGB(this.hue, this.saturation, this.brightness), true);
                }
            }
        }

        private void setHsb(int color, boolean padZero) {
            float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
            this.hue = hsb[0];
            this.saturation = hsb[1];
            this.brightness = hsb[2];
            this.setColorText(color, padZero);
        }

        private void setColorText(int color, boolean padZero) {
            String colorString = Integer.toHexString(color & 0xFFFFFF).toUpperCase(Locale.ENGLISH);
            this.textFieldColor.m_94144_(padZero ? StringUtils.leftPad((String)colorString, (int)6, (String)"0") : colorString);
            this.textFieldRed.m_94144_(String.valueOf(color >> 16 & 0xFF));
            this.textFieldGreen.m_94144_(String.valueOf(color >> 8 & 0xFF));
            this.textFieldBlue.m_94144_(String.valueOf(color & 0xFF));
            this.buttonReset.f_93623_ = (color & 0xFFFFFF) != this.oldColor;
        }

        private void textCallback(String text, int shift) {
            try {
                boolean isHex = shift < 0;
                int compare = Integer.parseInt(text, isHex ? 16 : 10);
                int currentColor = Color.HSBtoRGB(this.hue, this.saturation, this.brightness) & 0xFFFFFF;
                if ((isHex ? currentColor : currentColor >> shift & 0xFF) != compare) {
                    this.setHsb(isHex ? compare : (currentColor & ~(255 << shift)) + (compare << shift), !isHex);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getMainWidth() {
            return this.f_96543_ - 100 - 60;
        }

        private int getMainHeight() {
            return this.f_96544_ - 40;
        }
    }

    private static enum DraggingState {
        NONE,
        SATURATION_BRIGHTNESS,
        HUE;

    }
}

