/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mtr.Icons;
import mtr.Patreon;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.client.TrainClientRegistry;
import mtr.client.TrainProperties;
import mtr.data.DataConverter;
import mtr.data.NameColorDataBase;
import mtr.data.RailType;
import mtr.data.RailwayData;
import mtr.data.Siding;
import mtr.data.Train;
import mtr.data.TrainType;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardScreen;
import mtr.screen.SavedRailScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class SidingScreen
extends SavedRailScreenBase<Siding>
implements Icons {
    private boolean isSelectingTrain;
    private final float oldAcceleration;
    private final boolean oldIsManual;
    private final int oldMaxManualSpeed;
    private final int oldDwellTime;
    private final TransportMode transportMode;
    private final Button buttonSelectTrain;
    private final DashboardList availableTrainsList;
    private final WidgetBetterCheckbox buttonUnlimitedTrains;
    private final WidgetBetterTextField textFieldMaxTrains;
    private final WidgetShorterSlider sliderAccelerationConstant;
    private final WidgetBetterCheckbox buttonIsManual;
    private final WidgetShorterSlider sliderMaxManualSpeed;
    private static final Component SELECTED_TRAIN_TEXT = Text.translatable("gui.mtr.selected_vehicle", new Object[0]);
    private static final Component MAX_TRAINS_TEXT = Text.translatable("gui.mtr.max_vehicles", new Object[0]);
    private static final Component ACCELERATION_CONSTANT_TEXT = Text.translatable("gui.mtr.acceleration", new Object[0]);
    private static final Component MANUAL_TO_AUTOMATIC_TIME = Text.translatable("gui.mtr.manual_to_automatic_time", new Object[0]);
    private static final Component MAX_MANUAL_SPEED = Text.translatable("gui.mtr.max_manual_speed", new Object[0]);
    private static final int MAX_TRAINS_TEXT_LENGTH = 3;
    private static final int MAX_TRAINS_WIDTH = 80;
    private static final int DESCRIPTION_WIDTH = 160;
    private static final int SLIDER_SCALE = 1000;
    private static final float ACCELERATION_UNIT_CONVERSION_1 = 400.0f;
    private static final float ACCELERATION_UNIT_CONVERSION_2 = 1440.0f;
    private static final Map<String, String> WIKIPEDIA_ARTICLES = new HashMap<String, String>();

    public SidingScreen(Siding siding, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(siding, transportMode, dashboardScreen, SELECTED_TRAIN_TEXT, MAX_TRAINS_TEXT, ACCELERATION_CONSTANT_TEXT, MANUAL_TO_AUTOMATIC_TIME, MAX_MANUAL_SPEED);
        this.transportMode = transportMode;
        this.buttonSelectTrain = UtilitiesClient.newButton(button -> this.onSelectingTrain());
        this.availableTrainsList = new DashboardList(null, null, null, null, this::onAdd, null, null, () -> ClientData.TRAINS_SEARCH, text -> {
            ClientData.TRAINS_SEARCH = text;
        });
        this.textFieldMaxTrains = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "", 3);
        this.sliderAccelerationConstant = new WidgetShorterSlider(0, 80, Math.round(49.000004f), this::accelerationSliderFormatter, null);
        this.buttonIsManual = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.is_manual", new Object[0]), checked -> {
            if (checked && !this.textFieldMaxTrains.m_94155_().equals("1")) {
                this.textFieldMaxTrains.m_94144_("1");
            }
            this.setIsSelectingTrain(false);
        });
        this.sliderMaxManualSpeed = new WidgetShorterSlider(0, 80, RailType.DIAMOND.ordinal(), this::speedSliderFormatter, null);
        this.buttonUnlimitedTrains = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.unlimited_vehicles", new Object[0]), checked -> {
            if (checked) {
                this.buttonIsManual.setChecked(false);
            }
            if (checked && !this.textFieldMaxTrains.m_94155_().isEmpty()) {
                this.textFieldMaxTrains.m_94144_("");
            } else if (!checked && this.textFieldMaxTrains.m_94155_().isEmpty()) {
                this.textFieldMaxTrains.m_94144_("1");
            }
            this.setIsSelectingTrain(false);
        });
        this.oldAcceleration = ((Siding)this.savedRailBase).getAccelerationConstant();
        this.oldIsManual = ((Siding)this.savedRailBase).getIsManual();
        this.oldMaxManualSpeed = ((Siding)this.savedRailBase).getMaxManualSpeed();
        this.oldDwellTime = ((Siding)this.savedRailBase).getDwellTime();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonSelectTrain, 20 + this.textWidth, 44, this.f_96543_ - this.textWidth - 40);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonUnlimitedTrains, 20 + this.textWidth + 80 + 4 + 4, 66, this.f_96543_ - this.textWidth - 40);
        this.addDrawableChild(this.buttonSelectTrain);
        this.availableTrainsList.y = 20;
        this.availableTrainsList.height = this.f_96544_ - 40;
        this.availableTrainsList.width = this.f_96543_ - 160 - 60;
        this.availableTrainsList.init(this::addDrawableChild);
        this.buttonIsManual.setChecked(((Siding)this.savedRailBase).getIsManual());
        this.buttonUnlimitedTrains.setChecked(((Siding)this.savedRailBase).getUnlimitedTrains());
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldMaxTrains, 20 + this.textWidth + 2, 66, 76);
        this.textFieldMaxTrains.m_94144_(((Siding)this.savedRailBase).getUnlimitedTrains() ? "" : String.valueOf(((Siding)this.savedRailBase).getMaxTrains() + 1));
        this.textFieldMaxTrains.m_94151_(text -> {
            this.buttonUnlimitedTrains.setChecked(text.isEmpty());
            if (!text.equals("1")) {
                this.buttonIsManual.setChecked(false);
            }
            this.setIsSelectingTrain(false);
        });
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderAccelerationConstant, 20 + this.textWidth);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderAccelerationConstant, 88);
        this.sliderAccelerationConstant.setHeight(20);
        this.sliderAccelerationConstant.setValue(Math.round((((Siding)this.savedRailBase).getAccelerationConstant() - 0.001f) * 1000.0f));
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonIsManual, 20, 128, this.f_96543_ - this.textWidth - 40);
        UtilitiesClient.setWidgetX((AbstractWidget)this.sliderMaxManualSpeed, 20 + this.textWidth);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderMaxManualSpeed, 148);
        this.sliderMaxManualSpeed.setHeight(20);
        this.sliderMaxManualSpeed.setValue(((Siding)this.savedRailBase).getMaxManualSpeed());
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderDwellTimeMin, 168);
        UtilitiesClient.setWidgetY((AbstractWidget)this.sliderDwellTimeSec, 178);
        this.setIsSelectingTrain(false);
        if (this.showScheduleControls) {
            this.addDrawableChild(this.buttonUnlimitedTrains);
            this.addDrawableChild(this.textFieldMaxTrains);
            this.addDrawableChild(this.sliderAccelerationConstant);
            this.addDrawableChild(this.buttonIsManual);
            this.addDrawableChild(this.sliderMaxManualSpeed);
        }
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.availableTrainsList.tick();
        this.textFieldMaxTrains.m_94120_();
    }

    @Override
    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        block6: {
            block5: {
                super.m_6305_(matrices, mouseX, mouseY, delta);
                if (this.isSelectingTrain) break block5;
                this.f_96547_.m_92889_(matrices, SELECTED_TRAIN_TEXT, 20.0f, 50.0f, -1);
                if (!this.showScheduleControls) break block6;
                this.f_96547_.m_92889_(matrices, MAX_TRAINS_TEXT, 20.0f, 72.0f, -1);
                this.f_96547_.m_92889_(matrices, ACCELERATION_CONSTANT_TEXT, 20.0f, 94.0f, -1);
                if (!this.buttonIsManual.m_93840_()) break block6;
                this.f_96547_.m_92889_(matrices, MAX_MANUAL_SPEED, 20.0f, 154.0f, -1);
                this.f_96547_.m_92889_(matrices, MANUAL_TO_AUTOMATIC_TIME, 20.0f, 174.0f, -1);
                break block6;
            }
            int index = this.availableTrainsList.getHoverItemIndex();
            if (index >= 0) {
                TrainProperties properties = TrainClientRegistry.getTrainProperties(this.transportMode, index);
                int spacing = TrainType.getSpacing(properties.baseTrainType);
                int cars = (int)Math.floor(((Siding)this.savedRailBase).railLength / (float)spacing);
                int y = 20;
                y = this.drawWrappedText(matrices, properties.name, y, -1);
                y = this.drawWrappedText(matrices, (Component)Text.translatable("gui.mtr.vehicle_length", spacing - 1), y, -1);
                y = this.drawWrappedText(matrices, (Component)Text.translatable("gui.mtr.cars_to_spawn", (cars == 0 ? "\u26a0 " : "") + Math.min(cars, ((Siding)this.savedRailBase).transportMode.maxLength)), y, -1);
                if (properties.description != null) {
                    for (String text : properties.description.split("[|\n]")) {
                        y = this.drawWrappedText(matrices, (Component)Text.literal(text), y, -5592406);
                    }
                }
                if (properties.wikipediaArticle != null) {
                    String fullText = SidingScreen.fetchWikipediaArticle(properties.wikipediaArticle);
                    for (String text : fullText.split("\n")) {
                        y = this.drawWrappedText(matrices, (Component)Text.literal(text), y, -5592406);
                    }
                }
            }
        }
    }

    @Override
    public void m_7379_() {
        float accelerationConstant;
        int maxTrains;
        try {
            maxTrains = Math.max(0, Integer.parseInt(this.textFieldMaxTrains.m_94155_()) - 1);
        }
        catch (Exception ignored) {
            maxTrains = 0;
        }
        try {
            accelerationConstant = RailwayData.round(Mth.m_14036_((float)((float)this.sliderAccelerationConstant.getIntValue() / 1000.0f + 0.001f), (float)0.001f, (float)0.05f), 3);
        }
        catch (Exception ignored) {
            accelerationConstant = 0.01f;
        }
        boolean isManual = this.buttonIsManual.m_93840_();
        int maxManualSpeed = this.sliderMaxManualSpeed.getIntValue();
        int minutes = this.sliderDwellTimeMin.getIntValue();
        float second = (float)this.sliderDwellTimeSec.getIntValue() / 2.0f;
        int dwellTime = (int)((second + (float)(minutes * 60)) * 2.0f);
        ((Siding)this.savedRailBase).setUnlimitedTrains(this.buttonUnlimitedTrains.m_93840_(), maxTrains, isManual, maxManualSpeed, accelerationConstant, dwellTime, this.oldAcceleration != accelerationConstant || this.oldIsManual != isManual || this.oldMaxManualSpeed != maxManualSpeed || this.oldDwellTime != dwellTime, packet -> PacketTrainDataGuiClient.sendUpdate(this.getPacketIdentifier(), packet));
        super.m_7379_();
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.availableTrainsList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.availableTrainsList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    protected boolean shouldRenderExtra() {
        return this.isSelectingTrain;
    }

    @Override
    protected void renderExtra(PoseStack matrices, int mouseX, int mouseY, float delta) {
        this.availableTrainsList.render(matrices, this.f_96547_);
    }

    @Override
    protected String getNumberStringKey() {
        return "gui.mtr.siding_number";
    }

    @Override
    protected ResourceLocation getPacketIdentifier() {
        return PACKET_UPDATE_SIDING;
    }

    private void onSelectingTrain() {
        ArrayList trainList = new ArrayList();
        TrainClientRegistry.forEach(this.transportMode, (id, trainProperties) -> {
            boolean isAvailable = ((Siding)this.savedRailBase).isValidVehicle(TrainType.getSpacing(trainProperties.baseTrainType));
            trainList.add(new DataConverter((String)(isAvailable ? trainProperties.name.getString() : "\u26a0 " + trainProperties.name.getString()), isAvailable ? trainProperties.color : 0));
        });
        this.availableTrainsList.setData(trainList, false, false, false, false, true, false);
        this.setIsSelectingTrain(true);
    }

    private void setIsSelectingTrain(boolean isSelectingTrain) {
        this.isSelectingTrain = isSelectingTrain;
        this.buttonSelectTrain.f_93624_ = !isSelectingTrain;
        this.buttonUnlimitedTrains.f_93624_ = !isSelectingTrain;
        this.textFieldMaxTrains.f_93624_ = !isSelectingTrain;
        this.sliderAccelerationConstant.f_93624_ = !isSelectingTrain;
        this.buttonIsManual.f_93624_ = !isSelectingTrain;
        this.sliderMaxManualSpeed.f_93624_ = !isSelectingTrain && this.buttonIsManual.m_93840_();
        this.sliderDwellTimeMin.f_93624_ = !isSelectingTrain && this.buttonIsManual.m_93840_();
        this.sliderDwellTimeSec.f_93624_ = !isSelectingTrain && this.buttonIsManual.m_93840_();
        this.buttonSelectTrain.m_93666_(TrainClientRegistry.getTrainProperties((String)((Siding)this.savedRailBase).getTrainId()).name);
        this.availableTrainsList.x = isSelectingTrain ? 20 : this.f_96543_;
    }

    private void onAdd(NameColorDataBase data, int index) {
        String baseTrainType = TrainClientRegistry.getTrainProperties((TransportMode)this.transportMode, (int)index).baseTrainType;
        if (((Siding)this.savedRailBase).isValidVehicle(TrainType.getSpacing(baseTrainType))) {
            ((Siding)this.savedRailBase).setTrainIdAndBaseType(TrainClientRegistry.getTrainId(this.transportMode, index), baseTrainType, packet -> PacketTrainDataGuiClient.sendUpdate(IPacket.PACKET_UPDATE_SIDING, packet));
            this.setIsSelectingTrain(false);
        }
    }

    private String accelerationSliderFormatter(int value) {
        float valueMeterPerTickSquared = (float)value / 1000.0f + 0.001f;
        return String.format("%s m/s\u00b2 (%s km/h/s)", Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 400.0f, 1)), Float.valueOf(RailwayData.round(valueMeterPerTickSquared * 1440.0f, 1)));
    }

    private String speedSliderFormatter(int value) {
        RailType railType = Train.convertMaxManualSpeed(value);
        return railType == null ? Text.translatable("gui.mtr.unlimited", new Object[0]).getString() : String.format("%s km/h", railType.speedLimit);
    }

    private int drawWrappedText(PoseStack matrices, Component component, int y, int color) {
        List splitText = this.f_96547_.m_92923_((FormattedText)component, 160);
        int newY = y;
        for (FormattedCharSequence formattedCharSequence : splitText) {
            int nextY = newY + 8 + 2;
            if (nextY > this.f_96544_ - 20 - 8) {
                this.f_96547_.m_92883_(matrices, "...", (float)(this.f_96543_ - 160 - 20), (float)newY, color);
                return this.f_96544_;
            }
            this.f_96547_.m_92877_(matrices, formattedCharSequence, (float)(this.f_96543_ - 160 - 20), (float)newY, color);
            newY = nextY;
        }
        return newY + 6;
    }

    private static String fetchWikipediaArticle(String wikipediaArticle) {
        String result = WIKIPEDIA_ARTICLES.get(wikipediaArticle);
        if (result == null) {
            CompletableFuture.runAsync(() -> Patreon.openConnectionSafeJson("https://en.wikipedia.org/w/api.php?format=json&action=query&prop=extracts&explaintext&exintro&titles=" + wikipediaArticle, jsonElement -> {
                JsonObject pagesObject = jsonElement.getAsJsonObject().getAsJsonObject("query").getAsJsonObject("pages");
                pagesObject.entrySet().stream().findFirst().ifPresent(entry -> WIKIPEDIA_ARTICLES.put(wikipediaArticle, pagesObject.getAsJsonObject((String)entry.getKey()).get("extract").getAsString()));
            }, new String[0]));
            WIKIPEDIA_ARTICLES.put(wikipediaArticle, "");
            return "";
        }
        return result;
    }
}

