/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.NameColorDataBase;
import mtr.data.Station;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetBetterTextField;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class EditStationScreen
extends EditNameColorScreenBase<Station> {
    String editingExit;
    int editingDestinationIndex;
    private final Component stationZoneText = Text.translatable("gui.mtr.zone", new Object[0]);
    private final Component exitParentsText = Text.translatable("gui.mtr.exit_parents", new Object[0]);
    private final Component exitDestinationsText = Text.translatable("gui.mtr.exit_destinations", new Object[0]);
    private final WidgetBetterTextField textFieldZone = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.INTEGER, "", 6);
    private final WidgetBetterTextField textFieldExitParentLetter = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.LETTER, "A", 1);
    private final WidgetBetterTextField textFieldExitParentNumber = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.POSITIVE_INTEGER, "1", 2);
    private final WidgetBetterTextField textFieldExitDestination = new WidgetBetterTextField("");
    private final Button buttonAddExitParent = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.add_exit", new Object[0]), button -> this.changeEditingExit("", -1));
    private final Button buttonDoneExitParent = UtilitiesClient.newButton((Component)Text.translatable("gui.done", new Object[0]), button -> this.onDoneExitParent());
    private final Button buttonAddExitDestination = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.add_exit_destination", new Object[0]), button -> this.changeEditingExit(this.editingExit, station.exits.containsKey(this.editingExit) ? station.exits.get(this.editingExit).size() : -1));
    private final Button buttonDoneExitDestination = UtilitiesClient.newButton((Component)Text.translatable("gui.done", new Object[0]), button -> this.onDoneExitDestination());
    private final DashboardList exitParentList = new DashboardList(null, null, this::onEditExitParent, null, null, this::onDeleteExitParent, null, () -> ClientData.EXIT_PARENTS_SEARCH, text -> {
        ClientData.EXIT_PARENTS_SEARCH = text;
    });
    private final DashboardList exitDestinationList = new DashboardList(null, null, this::onEditExitDestination, this::onSortExitDestination, null, this::onDeleteExitDestination, this::getExitDestinationList, () -> ClientData.EXIT_DESTINATIONS_SEARCH, text -> {
        ClientData.EXIT_DESTINATIONS_SEARCH = text;
    });
    private static final int EXIT_PANELS_START = 70;

    public EditStationScreen(Station station, DashboardScreen dashboardScreen) {
        super(station, dashboardScreen, "gui.mtr.station_name", "gui.mtr.station_color");
    }

    protected void m_7856_() {
        this.setPositionsAndInit(0, this.f_96543_ / 2, this.f_96543_ / 4 * 3);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldZone, this.f_96543_ / 4 * 3 + 2, 22, this.f_96543_ / 4 - 4);
        int yExitText = this.f_96544_ - 40 - 2;
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldExitParentLetter, 2, yExitText, this.f_96543_ / 4 - 4);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldExitParentNumber, 2 + this.f_96543_ / 4, yExitText, this.f_96543_ / 4 - 4);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldExitDestination, this.f_96543_ / 2 + 2, yExitText, this.f_96543_ / 2 - 4);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonAddExitParent, 0, this.f_96544_ - 20, this.f_96543_ / 2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoneExitParent, 0, this.f_96544_ - 20, this.f_96543_ / 2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonAddExitDestination, this.f_96543_ / 2, this.f_96544_ - 20, this.f_96543_ / 2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoneExitDestination, this.f_96543_ / 2, this.f_96544_ - 20, this.f_96543_ / 2);
        this.textFieldZone.m_94144_(String.valueOf(((Station)this.data).zone));
        this.exitParentList.x = 0;
        this.exitParentList.y = 70;
        this.exitParentList.height = this.f_96544_ - 70 - 20;
        this.exitParentList.width = this.f_96543_ / 2;
        this.exitDestinationList.x = this.f_96543_ / 2;
        this.exitDestinationList.y = 70;
        this.exitDestinationList.height = this.f_96544_ - 70 - 20;
        this.exitDestinationList.width = this.f_96543_ / 2;
        this.exitParentList.init(this::addDrawableChild);
        this.exitDestinationList.init(this::addDrawableChild);
        this.addDrawableChild(this.textFieldZone);
        this.addDrawableChild(this.textFieldExitParentLetter);
        this.addDrawableChild(this.textFieldExitParentNumber);
        this.addDrawableChild(this.textFieldExitDestination);
        this.addDrawableChild(this.buttonAddExitParent);
        this.addDrawableChild(this.buttonDoneExitParent);
        this.addDrawableChild(this.buttonAddExitDestination);
        this.addDrawableChild(this.buttonDoneExitDestination);
        this.changeEditingExit(null, -1);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.textFieldZone.m_94120_();
        this.textFieldExitParentLetter.m_94120_();
        this.textFieldExitParentNumber.m_94120_();
        this.textFieldExitDestination.m_94120_();
        this.exitParentList.tick();
        this.exitDestinationList.tick();
        List exitParents = ((Station)this.data).exits.keySet().stream().sorted().map(value -> {
            List<String> destinations = ((Station)this.data).exits.get(value);
            String additional = destinations.size() > 1 ? "(+" + (destinations.size() - 1) + ")" : "";
            return new DataConverter((String)(destinations.size() > 0 ? value + "|" + destinations.get(0) + "|" + additional : value), 0);
        }).collect(Collectors.toList());
        this.exitParentList.setData(exitParents, false, false, true, false, false, true);
        ArrayList exitDestinations = this.parentExists() ? ((Station)this.data).exits.get(this.editingExit).stream().map(value -> new DataConverter((String)value, 0)).collect(Collectors.toList()) : new ArrayList();
        this.exitDestinationList.setData(exitDestinations, false, false, true, true, false, true);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.renderTextFields(matrices);
            this.m_93222_(matrices, this.f_96543_ / 2, 50, this.f_96544_, Integer.MAX_VALUE);
            this.exitParentList.render(matrices, this.f_96547_);
            this.exitDestinationList.render(matrices, this.f_96547_);
            EditStationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.stationZoneText, (int)(this.f_96543_ / 8 * 7), (int)6, (int)-1);
            EditStationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.exitParentsText, (int)(this.f_96543_ / 4), (int)56, (int)-1);
            if (this.parentExists()) {
                EditStationScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.exitDestinationsText, (int)(3 * this.f_96543_ / 4), (int)56, (int)-1);
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.exitParentList.mouseMoved(mouseX, mouseY);
        this.exitDestinationList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.exitParentList.mouseScrolled(mouseX, mouseY, amount);
        this.exitDestinationList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    protected void saveData() {
        super.saveData();
        try {
            ((Station)this.data).zone = Integer.parseInt(this.textFieldZone.m_94155_());
        }
        catch (Exception ignored) {
            ((Station)this.data).zone = 0;
        }
        ((Station)this.data).setZone(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
    }

    private void changeEditingExit(String editingExit, int editingDestinationIndex) {
        this.editingExit = editingExit;
        int n = this.editingDestinationIndex = this.parentExists() ? editingDestinationIndex : -1;
        if (editingExit != null) {
            this.textFieldExitParentLetter.m_94144_(editingExit.toUpperCase(Locale.ENGLISH).replaceAll("[^A-Z]", ""));
            this.textFieldExitParentNumber.m_94144_(editingExit.replaceAll("\\D", ""));
        }
        if (editingDestinationIndex >= 0 && editingDestinationIndex < ((Station)this.data).exits.get(editingExit).size()) {
            this.textFieldExitDestination.m_94144_(((Station)this.data).exits.get(editingExit).get(editingDestinationIndex));
        } else {
            this.textFieldExitDestination.m_94144_("");
        }
        this.textFieldExitParentLetter.f_93624_ = editingExit != null;
        this.textFieldExitParentNumber.f_93624_ = editingExit != null;
        this.textFieldExitDestination.f_93624_ = editingDestinationIndex >= 0;
        this.buttonAddExitParent.f_93624_ = editingExit == null;
        this.buttonDoneExitParent.f_93624_ = editingExit != null;
        this.buttonAddExitDestination.f_93624_ = this.parentExists() && editingDestinationIndex < 0;
        this.buttonDoneExitDestination.f_93624_ = editingDestinationIndex >= 0;
        this.exitDestinationList.x = this.parentExists() ? this.f_96543_ / 2 : this.f_96543_;
        this.exitParentList.height = this.f_96544_ - 70 - (editingExit == null ? 20 : 44);
        this.exitDestinationList.height = this.f_96544_ - 70 - (editingDestinationIndex >= 0 ? 44 : 20);
    }

    private void onDoneExitParent() {
        String parentLetter = this.textFieldExitParentLetter.m_94155_();
        String parentNumber = this.textFieldExitParentNumber.m_94155_();
        if (!parentLetter.isEmpty() && !parentNumber.isEmpty()) {
            try {
                String exitParent = parentLetter + Integer.parseInt(parentNumber);
                ((Station)this.data).setExitParent(this.editingExit, exitParent, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.changeEditingExit(null, -1);
    }

    private void onDoneExitDestination() {
        String destination = this.textFieldExitDestination.m_94155_();
        if (this.parentExists() && this.editingDestinationIndex >= 0 && !destination.isEmpty()) {
            List<String> destinations = ((Station)this.data).exits.get(this.editingExit);
            if (this.editingDestinationIndex < destinations.size()) {
                destinations.set(this.editingDestinationIndex, destination);
            } else {
                destinations.add(destination);
            }
            ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onEditExitParent(NameColorDataBase listData, int index) {
        this.changeEditingExit(EditStationScreen.formatExitName(listData.name), -1);
    }

    private void onDeleteExitParent(NameColorDataBase listData, int index) {
        ((Station)this.data).deleteExitParent(EditStationScreen.formatExitName(listData.name), packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        this.changeEditingExit(null, -1);
    }

    private void onEditExitDestination(NameColorDataBase listData, int index) {
        this.changeEditingExit(this.editingExit, index);
    }

    private void onSortExitDestination() {
        ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        this.changeEditingExit(this.editingExit, -1);
    }

    private void onDeleteExitDestination(NameColorDataBase listData, int index) {
        if (this.parentExists()) {
            ((Station)this.data).exits.get(this.editingExit).remove(listData.name);
            ((Station)this.data).setExitDestinations(this.editingExit, packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_STATION, packet));
        }
        this.changeEditingExit(this.editingExit, -1);
    }

    private List<String> getExitDestinationList() {
        return this.parentExists() ? ((Station)this.data).exits.get(this.editingExit) : new ArrayList<String>();
    }

    private boolean parentExists() {
        return this.editingExit != null && ((Station)this.data).exits.containsKey(this.editingExit);
    }

    private static String formatExitName(String text) {
        return text.split("\\|")[0];
    }
}

