/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.DataConverter;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.Siding;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.DashboardList;
import mtr.screen.DashboardListSelectorScreen;
import mtr.screen.DashboardScreen;
import mtr.screen.EditNameColorScreenBase;
import mtr.screen.WidgetBetterCheckbox;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetShorterSlider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.StringUtils;

public class EditDepotScreen
extends EditNameColorScreenBase<Depot> {
    private final int sliderX;
    private final int sliderWidthWithText;
    private final int rightPanelsX;
    private final boolean showScheduleControls;
    private final boolean showCruisingAltitude;
    private final Map<Long, Siding> sidingsInDepot;
    private final Button buttonUseRealTime;
    private final Button buttonReset;
    private final WidgetShorterSlider[] sliders = new WidgetShorterSlider[24];
    private final WidgetBetterTextField textFieldDeparture;
    private final Button buttonAddDeparture;
    private final Button buttonEditInstructions;
    private final Button buttonGenerateRoute;
    private final Button buttonClearTrains;
    private final WidgetBetterCheckbox checkboxRepeatIndefinitely;
    private final WidgetBetterTextField textFieldCruisingAltitude;
    private final DashboardList departuresList;
    private final Component cruisingAltitudeText = Text.translatable("gui.mtr.cruising_altitude", new Object[0]);
    private static final int PANELS_START = 44;
    private static final int SLIDER_WIDTH = 64;
    private static final int MAX_TRAINS_PER_HOUR = 5;
    private static final int SECONDS_PER_MC_HOUR = 50;

    public EditDepotScreen(Depot depot, TransportMode transportMode, DashboardScreen dashboardScreen) {
        super(depot, dashboardScreen, "gui.mtr.depot_name", "gui.mtr.depot_color");
        this.sidingsInDepot = ClientData.DATA_CACHE.requestDepotIdToSidings(depot.id);
        this.f_96547_ = Minecraft.m_91087_().f_91062_;
        this.sliderX = this.f_96547_.m_92895_(EditDepotScreen.getTimeString(0)) + 12;
        this.sliderWidthWithText = 70 + this.f_96547_.m_92895_(EditDepotScreen.getSliderString(0));
        this.rightPanelsX = this.sliderX + 64 + 12 + this.f_96547_.m_92895_(EditDepotScreen.getSliderString(1));
        this.showScheduleControls = !transportMode.continuousMovement;
        this.showCruisingAltitude = transportMode == TransportMode.AIRPLANE;
        this.buttonUseRealTime = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.schedule_mode_real_time_off", new Object[0]), button -> {
            depot.useRealTime = !depot.useRealTime;
            this.toggleRealTime();
            this.saveData();
        });
        this.buttonReset = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.reset_sign", new Object[0]), button -> {
            for (int i = 0; i < 24; ++i) {
                this.sliders[i].setValue(0);
            }
            ((Depot)this.data).departures.clear();
            this.updateList();
            this.saveData();
        });
        int i = 0;
        while (i < 24) {
            int currentIndex = i++;
            this.sliders[currentIndex] = new WidgetShorterSlider(this.sliderX, 64, 10, EditDepotScreen::getSliderString, value -> {
                for (int j = 0; j < 24; ++j) {
                    if (j == currentIndex) continue;
                    this.sliders[j].setValue((int)value);
                }
            });
        }
        this.departuresList = new DashboardList(null, null, null, null, null, this::onDeleteDeparture, null, () -> "", text -> {});
        this.textFieldDeparture = new WidgetBetterTextField("[^\\d:+* ]", "07:10:00 + 10 * 00:03:00", 25);
        this.buttonAddDeparture = UtilitiesClient.newButton((Component)Text.literal("+"), button -> {
            this.checkDeparture(this.textFieldDeparture.m_94155_(), true, false);
            this.saveData();
        });
        this.buttonEditInstructions = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.edit_instructions", new Object[0]), button -> {
            if (this.f_96541_ != null) {
                this.saveData();
                ArrayList<NameColorDataBase> routes = new ArrayList<NameColorDataBase>(ClientData.getFilteredDataSet(transportMode, ClientData.ROUTES));
                Collections.sort(routes);
                UtilitiesClient.setScreen(this.f_96541_, new DashboardListSelectorScreen(this, routes, ((Depot)this.data).routeIds, false, true));
            }
        });
        this.buttonGenerateRoute = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.refresh_path", new Object[0]), button -> {
            this.saveData();
            depot.clientPathGenerationSuccessfulSegments = -1;
            PacketTrainDataGuiClient.generatePathC2S(depot.id);
        });
        this.buttonClearTrains = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.clear_vehicles", new Object[0]), button -> {
            this.sidingsInDepot.values().forEach(Siding::clearTrains);
            PacketTrainDataGuiClient.clearTrainsC2S(depot.id, this.sidingsInDepot.values());
        });
        this.checkboxRepeatIndefinitely = new WidgetBetterCheckbox(0, 0, 0, 20, (Component)Text.translatable("gui.mtr.repeat_indefinitely", new Object[0]), button -> {
            this.saveData();
            depot.clientPathGenerationSuccessfulSegments = -1;
            PacketTrainDataGuiClient.generatePathC2S(depot.id);
        });
        this.textFieldCruisingAltitude = new WidgetBetterTextField(WidgetBetterTextField.TextFieldFilter.INTEGER, String.valueOf(256), 5);
    }

    protected void m_7856_() {
        this.setPositionsAndInit(this.rightPanelsX, this.f_96543_ / 4 * 3, this.f_96543_);
        int buttonWidth = (this.f_96543_ - this.rightPanelsX) / 2;
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonEditInstructions, this.rightPanelsX, 44, buttonWidth * 2);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonGenerateRoute, this.rightPanelsX, 64, buttonWidth * (this.showScheduleControls ? 1 : 2));
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonClearTrains, this.rightPanelsX + buttonWidth, 64, buttonWidth);
        IDrawing.setPositionAndWidth((AbstractWidget)this.checkboxRepeatIndefinitely, this.rightPanelsX, 84 + (this.showCruisingAltitude ? 24 : 0), buttonWidth * 2);
        this.checkboxRepeatIndefinitely.setChecked(((Depot)this.data).repeatInfinitely);
        int cruisingAltitudeTextWidth = this.f_96547_.m_92852_((FormattedText)this.cruisingAltitudeText) + 12;
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldCruisingAltitude, this.rightPanelsX + Math.min(cruisingAltitudeTextWidth, buttonWidth * 2 - 60) + 2, 86, 56);
        this.textFieldCruisingAltitude.m_94144_(String.valueOf(((Depot)this.data).cruisingAltitude));
        if (this.showScheduleControls) {
            for (WidgetShorterSlider slider : this.sliders) {
                this.addDrawableChild(slider);
            }
        }
        for (int i = 0; i < 24; ++i) {
            this.sliders[i].setValue(((Depot)this.data).getFrequency(i));
        }
        int leftWidth = this.rightPanelsX - 1;
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonUseRealTime, 0, 0, leftWidth - 60);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonReset, leftWidth - 60, 0, 60);
        this.departuresList.y = 20;
        this.departuresList.height = this.f_96544_ - 40 - 4;
        this.departuresList.width = leftWidth;
        this.departuresList.init(this::addDrawableChild);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldDeparture, 2, this.f_96544_ - 20 - 2, leftWidth - 4 - 20);
        this.addDrawableChild(this.textFieldDeparture);
        this.textFieldDeparture.m_94151_(text -> {
            this.buttonAddDeparture.f_93623_ = this.checkDeparture((String)text, false, false);
        });
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonAddDeparture, leftWidth - 20, this.f_96544_ - 20 - 2, 20);
        this.addDrawableChild(this.buttonAddDeparture);
        this.buttonAddDeparture.f_93623_ = false;
        this.addDrawableChild(this.buttonEditInstructions);
        this.addDrawableChild(this.buttonGenerateRoute);
        if (this.showScheduleControls) {
            this.addDrawableChild(this.buttonUseRealTime);
            this.addDrawableChild(this.buttonReset);
            this.addDrawableChild(this.buttonClearTrains);
            this.addDrawableChild(this.checkboxRepeatIndefinitely);
        }
        if (this.showCruisingAltitude) {
            this.addDrawableChild(this.textFieldCruisingAltitude);
        }
        this.toggleRealTime();
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        this.buttonGenerateRoute.f_93623_ = ((Depot)this.data).clientPathGenerationSuccessfulSegments >= 0;
        this.departuresList.tick();
        this.textFieldDeparture.m_94120_();
        this.textFieldCruisingAltitude.m_94120_();
        for (int i = 0; i < 24; ++i) {
            ((Depot)this.data).setFrequency(this.sliders[i].getIntValue(), i);
        }
        if (((Depot)this.data).routeIds.isEmpty()) {
            this.checkboxRepeatIndefinitely.f_93624_ = false;
        } else {
            Route firstRoute = (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(0));
            Route lastRoute = (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(((Depot)this.data).routeIds.size() - 1));
            this.checkboxRepeatIndefinitely.f_93624_ = firstRoute != null && lastRoute != null && !firstRoute.platformIds.isEmpty() && !lastRoute.platformIds.isEmpty() && firstRoute.getFirstPlatformId() == lastRoute.getLastPlatformId();
        }
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            MutableComponent text;
            this.m_7333_(matrices);
            this.m_93222_(matrices, this.rightPanelsX - 1, -1, this.f_96544_, Integer.MAX_VALUE);
            this.renderTextFields(matrices);
            if (this.showScheduleControls && ((Depot)this.data).useRealTime) {
                this.departuresList.render(matrices, this.f_96547_);
            }
            int lineHeight = Math.min(20, (this.f_96544_ - 40) / 24);
            for (int i = 0; i < 24; ++i) {
                if (this.showScheduleControls && !((Depot)this.data).useRealTime) {
                    EditDepotScreen.m_93236_((PoseStack)matrices, (Font)this.f_96547_, (String)EditDepotScreen.getTimeString(i), (int)6, (int)(40 + lineHeight * i + (int)((float)(lineHeight - 8) / 2.0f)), (int)-1);
                }
                UtilitiesClient.setWidgetY((AbstractWidget)this.sliders[i], 40 + lineHeight * i);
                this.sliders[i].setHeight(lineHeight);
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
            int yStartRightPane = 44 + 20 * (this.checkboxRepeatIndefinitely.f_93624_ ? 3 : 2) + (this.showCruisingAltitude ? 24 : 0) + 6;
            if (this.showCruisingAltitude) {
                this.f_96547_.m_92889_(matrices, this.cruisingAltitudeText, (float)(this.rightPanelsX + 6), 92.0f, -1);
            }
            this.f_96547_.m_92889_(matrices, (Component)Text.translatable("gui.mtr.sidings_in_depot", this.sidingsInDepot.size()), (float)(this.rightPanelsX + 6), (float)yStartRightPane, -1);
            ((Depot)this.data).generateTempDepartures((Level)Minecraft.m_91087_().f_91073_);
            int nextDepartureMillis = ((Depot)this.data).getMillisUntilDeploy(1);
            if (nextDepartureMillis >= 0) {
                long hour = TimeUnit.MILLISECONDS.toHours(nextDepartureMillis);
                long minute = TimeUnit.MILLISECONDS.toMinutes(nextDepartureMillis) % 60L;
                long second = TimeUnit.MILLISECONDS.toSeconds(nextDepartureMillis) % 60L;
                text = Text.translatable("gui.mtr.next_departure", String.format("%2s:%2s:%2s", hour, minute, second).replace(' ', '0'));
            } else {
                text = Text.translatable("gui.mtr.next_departure_none", new Object[0]);
            }
            this.f_96547_.m_92889_(matrices, (Component)text, (float)(this.rightPanelsX + 6), (float)(yStartRightPane + 20), -1);
            String[] stringSplit = this.getSuccessfulSegmentsText().getString().split("\\|");
            for (int i = 0; i < stringSplit.length; ++i) {
                this.f_96547_.m_92883_(matrices, stringSplit[i], (float)(this.rightPanelsX + 6), (float)(yStartRightPane + 40 + 14 * i), -1);
            }
            if (this.showScheduleControls && !((Depot)this.data).useRealTime) {
                EditDepotScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.game_time", new Object[0]), (int)(this.sliderX / 2), (int)26, (int)-5592406);
                EditDepotScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)Text.translatable("gui.mtr.vehicles_per_hour", new Object[0]), (int)(this.sliderX + this.sliderWidthWithText / 2), (int)26, (int)-5592406);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.departuresList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.departuresList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    @Override
    protected void saveData() {
        super.saveData();
        ((Depot)this.data).repeatInfinitely = this.checkboxRepeatIndefinitely.f_93624_ && this.checkboxRepeatIndefinitely.m_93840_();
        try {
            ((Depot)this.data).cruisingAltitude = Integer.parseInt(this.textFieldCruisingAltitude.m_94155_());
        }
        catch (Exception e) {
            e.printStackTrace();
            ((Depot)this.data).cruisingAltitude = 256;
        }
        ((Depot)this.data).setData(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_DEPOT, packet));
    }

    private void toggleRealTime() {
        for (WidgetShorterSlider slider : this.sliders) {
            slider.f_93624_ = !((Depot)this.data).useRealTime;
        }
        this.departuresList.x = ((Depot)this.data).useRealTime ? 0 : this.f_96543_;
        UtilitiesClient.setWidgetX((AbstractWidget)this.textFieldDeparture, ((Depot)this.data).useRealTime ? 2 : this.f_96543_);
        this.buttonAddDeparture.f_93624_ = ((Depot)this.data).useRealTime;
        this.buttonUseRealTime.m_93666_((Component)Text.translatable(((Depot)this.data).useRealTime ? "gui.mtr.schedule_mode_real_time_on" : "gui.mtr.schedule_mode_real_time_off", new Object[0]));
        this.updateList();
    }

    private void onDeleteDeparture(NameColorDataBase data, int index) {
        this.checkDeparture(data.name, false, true);
        this.saveData();
    }

    private void updateList() {
        ArrayList departureData = new ArrayList();
        long offset = System.currentTimeMillis() / 86400000L * 86400000L;
        ((Depot)this.data).departures.stream().map(departure -> {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis((long)departure.intValue() + offset);
            return calendar;
        }).sorted(Comparator.comparingInt(calendar -> {
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            return hour * 3600 + minute * 60 + second;
        })).forEach(calendar -> {
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            int second = calendar.get(13);
            departureData.add(new DataConverter(String.format("%2s:%2s:%2s", hour, minute, second).replace(' ', '0'), 0));
        });
        this.departuresList.setData(departureData, false, false, false, false, false, true);
        ((Depot)this.data).generateTempDepartures((Level)Minecraft.m_91087_().f_91073_);
    }

    private boolean checkDeparture(String text, boolean addToList, boolean removeFromList) {
        try {
            int interval;
            int multiple;
            String[] departureSplit = text.replace(" ", "").split("\\+");
            String[] timeSplit1 = departureSplit[0].split(":");
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, Integer.parseInt(timeSplit1[0]) % 24);
            calendar.set(12, Integer.parseInt(timeSplit1[1]) % 60);
            calendar.set(13, Integer.parseInt(timeSplit1[2]) % 60);
            calendar.set(14, 0);
            int departure = (int)(calendar.getTimeInMillis() % 86400000L);
            if (departureSplit.length > 1) {
                String[] intervalSplit = departureSplit[1].split("\\*");
                multiple = Integer.parseInt(intervalSplit[0]) + 1;
                String[] timeSplit2 = intervalSplit[1].split(":");
                interval = (Integer.parseInt(timeSplit2[0]) * 3600 + Integer.parseInt(timeSplit2[1]) * 60 + Integer.parseInt(timeSplit2[2])) * 1000;
            } else {
                multiple = 1;
                interval = 0;
            }
            if (addToList || removeFromList) {
                for (int i = 0; i < multiple; ++i) {
                    int rawDeparture = (departure + i * interval) % 86400000;
                    if (addToList) {
                        if (((Depot)this.data).departures.contains(rawDeparture)) continue;
                        ((Depot)this.data).departures.add(rawDeparture);
                        continue;
                    }
                    ((Depot)this.data).departures.remove((Object)rawDeparture);
                }
                this.updateList();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Component getSuccessfulSegmentsText() {
        int successfulSegments = ((Depot)this.data).clientPathGenerationSuccessfulSegments;
        if (successfulSegments < 0) {
            return Text.translatable("gui.mtr.generating_path", new Object[0]);
        }
        if (successfulSegments == 0) {
            return Text.translatable("gui.mtr.path_not_generated", new Object[0]);
        }
        ArrayList<String> stationNames = new ArrayList<String>();
        ArrayList<String> routeNames = new ArrayList<String>();
        String depotName = IGui.textOrUntitled(IGui.formatStationName(((Depot)this.data).name));
        if (successfulSegments == 1) {
            RailwayData.useRoutesAndStationsFromIndex(0, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
                stationNames.add(IGui.textOrUntitled(thisStation == null ? "" : IGui.formatStationName(thisStation.name)));
                routeNames.add(IGui.textOrUntitled(thisRoute == null ? "" : IGui.formatStationName(thisRoute.name)));
            });
            stationNames.add("-");
            routeNames.add("-");
            return Text.translatable("gui.mtr.path_not_found_between", routeNames.get(0), depotName, stationNames.get(0));
        }
        int sum = 0;
        for (int i = 0; i < ((Depot)this.data).routeIds.size(); ++i) {
            Route nextRoute2;
            Route thisRoute2 = (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(i));
            Route route = nextRoute2 = i < ((Depot)this.data).routeIds.size() - 1 ? (Route)ClientData.DATA_CACHE.routeIdMap.get(((Depot)this.data).routeIds.get(i + 1)) : null;
            if (thisRoute2 == null) continue;
            sum += thisRoute2.platformIds.size();
            if (thisRoute2.platformIds.isEmpty() || nextRoute2 == null || nextRoute2.platformIds.isEmpty() || thisRoute2.getLastPlatformId() != nextRoute2.getFirstPlatformId()) continue;
            --sum;
        }
        if (successfulSegments >= sum + 2) {
            return Text.translatable("gui.mtr.path_found", new Object[0]);
        }
        RailwayData.useRoutesAndStationsFromIndex(successfulSegments - 2, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex, thisRoute, nextRoute, thisStation, nextStation, lastStation) -> {
            stationNames.add(IGui.textOrUntitled(thisStation == null ? "" : IGui.formatStationName(thisStation.name)));
            if (nextStation == null) {
                RailwayData.useRoutesAndStationsFromIndex(successfulSegments - 1, ((Depot)this.data).routeIds, ClientData.DATA_CACHE, (currentStationIndex1, thisRoute1, nextRoute1, thisStation1, nextStation1, lastStation1) -> stationNames.add(IGui.textOrUntitled(thisStation1 == null ? "" : IGui.formatStationName(thisStation1.name))));
            } else {
                stationNames.add(IGui.textOrUntitled(IGui.formatStationName(nextStation.name)));
            }
            routeNames.add(IGui.textOrUntitled(IGui.formatStationName(thisRoute.name)));
        });
        stationNames.add("-");
        stationNames.add("-");
        routeNames.add("-");
        if (successfulSegments < sum + 1) {
            return Text.translatable("gui.mtr.path_not_found_between", routeNames.get(0), stationNames.get(0), stationNames.get(1));
        }
        return Text.translatable("gui.mtr.path_not_found_between", routeNames.get(0), stationNames.get(0), depotName);
    }

    private static String getSliderString(int value) {
        Object headwayText = value == 0 ? "" : " (" + RailwayData.round(200.0f / (float)value, 1) + Text.translatable("gui.mtr.s", new Object[0]).getString() + ")";
        return (float)value / 4.0f + Text.translatable("gui.mtr.tph", new Object[0]).getString() + (String)headwayText;
    }

    private static String getTimeString(int hour) {
        String hourString = StringUtils.leftPad((String)String.valueOf(hour), (int)2, (String)"0");
        return String.format("%s:00-%s:59", hourString, hourString);
    }
}

