/*
 * Decompiled with CFR 0.152.
 */
package mtr.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.AreaBase;
import mtr.data.DataConverter;
import mtr.data.Depot;
import mtr.data.IGui;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.Siding;
import mtr.data.Station;
import mtr.data.TransportMode;
import mtr.mappings.ScreenMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.screen.ConfigScreen;
import mtr.screen.DashboardList;
import mtr.screen.DeleteConfirmationScreen;
import mtr.screen.EditDepotScreen;
import mtr.screen.EditRouteScreen;
import mtr.screen.EditStationScreen;
import mtr.screen.PlatformScreen;
import mtr.screen.RailActionsScreen;
import mtr.screen.SidingScreen;
import mtr.screen.WidgetBetterTextField;
import mtr.screen.WidgetColorSelector;
import mtr.screen.WidgetMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Tuple;

public class DashboardScreen
extends ScreenMapper
implements IGui,
IPacket {
    private SelectedTab selectedTab;
    private AreaBase editingArea;
    private Route editingRoute;
    private int editingRoutePlatformIndex;
    private boolean isNew;
    private final TransportMode transportMode;
    private final WidgetMap widgetMap;
    private final Button buttonTabStations;
    private final Button buttonTabRoutes;
    private final Button buttonTabDepots;
    private final Button buttonAddStation;
    private final Button buttonAddRoute;
    private final Button buttonAddDepot;
    private final Button buttonDoneEditingStation;
    private final Button buttonDoneEditingRoute;
    private final Button buttonDoneEditingRouteDestination;
    private final Button buttonZoomIn;
    private final Button buttonZoomOut;
    private final Button buttonRailActions;
    private final Button buttonOptions;
    private final WidgetBetterTextField textFieldName;
    private final WidgetBetterTextField textFieldCustomDestination;
    private final WidgetColorSelector colorSelector;
    private final DashboardList dashboardList;
    public static final int MAX_COLOR_ZONE_LENGTH = 6;
    private static final int COLOR_WIDTH = 48;

    public DashboardScreen(TransportMode transportMode, boolean useTimeAndWindSync) {
        super((Component)Text.literal(""));
        this.transportMode = transportMode;
        this.textFieldName = new WidgetBetterTextField(Text.translatable("gui.mtr.name", new Object[0]).getString());
        this.textFieldCustomDestination = new WidgetBetterTextField(Text.translatable("gui.mtr.custom_destination_suggestion", new Object[0]).getString());
        this.colorSelector = new WidgetColorSelector(this, this::toggleButtons);
        this.widgetMap = new WidgetMap(transportMode, this::onDrawCorners, this::onDrawCornersMouseRelease, this::onClickAddPlatformToRoute, this::onClickEditSavedRail, (arg_0, arg_1) -> ((WidgetColorSelector)this.colorSelector).m_5953_(arg_0, arg_1));
        this.buttonTabStations = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.stations", new Object[0]), button -> this.onSelectTab(SelectedTab.STATIONS));
        this.buttonTabRoutes = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.routes", new Object[0]), button -> this.onSelectTab(SelectedTab.ROUTES));
        this.buttonTabDepots = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.depots", new Object[0]), button -> this.onSelectTab(SelectedTab.DEPOTS));
        this.buttonAddStation = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.add_station", new Object[0]), button -> this.startEditingArea(new Station(), true));
        this.buttonAddRoute = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.add_route", new Object[0]), button -> this.startEditingRoute(new Route(transportMode), true));
        this.buttonAddDepot = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.add_depot", new Object[0]), button -> this.startEditingArea(new Depot(transportMode), true));
        this.buttonDoneEditingStation = UtilitiesClient.newButton((Component)Text.translatable("gui.done", new Object[0]), button -> this.onDoneEditingArea());
        this.buttonDoneEditingRoute = UtilitiesClient.newButton((Component)Text.translatable("gui.done", new Object[0]), button -> this.onDoneEditingRoute());
        this.buttonDoneEditingRouteDestination = UtilitiesClient.newButton((Component)Text.translatable("gui.done", new Object[0]), button -> this.onDoneEditingRouteDestination());
        this.buttonZoomIn = UtilitiesClient.newButton((Component)Text.literal("+"), button -> this.widgetMap.scale(1.0));
        this.buttonZoomOut = UtilitiesClient.newButton((Component)Text.literal("-"), button -> this.widgetMap.scale(-1.0));
        this.buttonRailActions = UtilitiesClient.newButton((Component)Text.translatable("gui.mtr.rail_actions_button", new Object[0]), button -> {
            if (this.f_96541_ != null) {
                UtilitiesClient.setScreen(this.f_96541_, new RailActionsScreen());
            }
        });
        this.buttonOptions = UtilitiesClient.newButton((Component)Text.translatable("menu.options", new Object[0]), button -> {
            if (this.f_96541_ != null) {
                UtilitiesClient.setScreen(this.f_96541_, new ConfigScreen(useTimeAndWindSync));
            }
        });
        this.dashboardList = new DashboardList(this::onFind, this::onDrawArea, this::onEdit, this::onSort, null, this::onDelete, this::getList, () -> ClientData.DASHBOARD_SEARCH, text -> {
            ClientData.DASHBOARD_SEARCH = text;
        });
        this.onSelectTab(SelectedTab.STATIONS);
    }

    protected void m_7856_() {
        super.m_7856_();
        int tabCount = 3;
        int bottomRowY = this.f_96544_ - 20;
        this.widgetMap.setPositionAndSize(144, 0, this.f_96543_ - 144, this.f_96544_);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonTabStations, 0, 0, 48);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonTabRoutes, 48, 0, 48);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonTabDepots, 96, 0, 48);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonAddStation, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonAddRoute, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonAddDepot, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoneEditingStation, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoneEditingRoute, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonDoneEditingRouteDestination, 0, bottomRowY, 144);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonZoomIn, this.f_96543_ - 40, bottomRowY, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonZoomOut, this.f_96543_ - 20, bottomRowY, 20);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonRailActions, this.f_96543_ - 200, bottomRowY, 100);
        IDrawing.setPositionAndWidth((AbstractWidget)this.buttonOptions, this.f_96543_ - 100, bottomRowY, 60);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldName, 2, bottomRowY - 20 - 2, 92);
        IDrawing.setPositionAndWidth((AbstractWidget)this.textFieldCustomDestination, 2, bottomRowY - 20 - 2, 140);
        IDrawing.setPositionAndWidth((AbstractWidget)this.colorSelector, 98, bottomRowY - 20 - 2, 44);
        this.dashboardList.x = 0;
        this.dashboardList.y = 20;
        this.dashboardList.width = 144;
        this.toggleButtons();
        this.dashboardList.init(this::addDrawableChild);
        this.m_7787_(this.widgetMap);
        this.addDrawableChild(this.buttonTabStations);
        this.addDrawableChild(this.buttonTabRoutes);
        this.addDrawableChild(this.buttonTabDepots);
        this.addDrawableChild(this.buttonAddStation);
        this.addDrawableChild(this.buttonAddRoute);
        this.addDrawableChild(this.buttonAddDepot);
        this.addDrawableChild(this.buttonDoneEditingStation);
        this.addDrawableChild(this.buttonDoneEditingRoute);
        this.addDrawableChild(this.buttonDoneEditingRouteDestination);
        this.addDrawableChild(this.buttonZoomIn);
        this.addDrawableChild(this.buttonZoomOut);
        this.addDrawableChild(this.buttonRailActions);
        this.addDrawableChild(this.buttonOptions);
        this.addDrawableChild(this.textFieldName);
        this.addDrawableChild(this.textFieldCustomDestination);
        this.addDrawableChild(this.colorSelector);
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        try {
            this.m_7333_(matrices);
            this.widgetMap.m_6305_(matrices, mouseX, mouseY, delta);
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 500.0);
            Gui.m_93172_((PoseStack)matrices, (int)0, (int)0, (int)144, (int)this.f_96544_, (int)-15592942);
            this.dashboardList.render(matrices, this.f_96547_);
            super.m_6305_(matrices, mouseX, mouseY, delta);
            matrices.m_85849_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.dashboardList.mouseMoved(mouseX, mouseY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        this.dashboardList.mouseScrolled(mouseX, mouseY, amount);
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void m_86600_() {
        this.textFieldName.m_94120_();
        this.textFieldCustomDestination.m_94120_();
        this.dashboardList.tick();
        try {
            switch (this.selectedTab) {
                case STATIONS: {
                    if (this.editingArea == null) {
                        this.dashboardList.setData(ClientData.STATIONS, true, true, true, false, false, true);
                        break;
                    }
                    Map<Long, Platform> platformData = ClientData.DATA_CACHE.requestStationIdToPlatforms(this.editingArea.id);
                    this.dashboardList.setData(platformData == null ? new ArrayList() : new ArrayList<Platform>(platformData.values()), true, false, true, false, false, false);
                    break;
                }
                case ROUTES: {
                    if (this.editingRoute == null) {
                        this.dashboardList.setData(ClientData.getFilteredDataSet(this.transportMode, ClientData.ROUTES), false, true, true, false, false, true);
                        break;
                    }
                    List routeData = this.editingRoute.platformIds.stream().map(platformId -> {
                        Platform platform = (Platform)ClientData.DATA_CACHE.platformIdMap.get(platformId.platformId);
                        if (platform == null) {
                            return null;
                        }
                        String customDestinationPrefix = platformId.customDestination.isEmpty() ? "" : (Route.destinationIsReset(platformId.customDestination) ? "\"" : "*");
                        Station station = (Station)ClientData.DATA_CACHE.platformIdToStation.get(platform.id);
                        if (station != null) {
                            return new DataConverter(String.format("%s%s (%s)", customDestinationPrefix, station.name, platform.name), station.color);
                        }
                        return new DataConverter(String.format("%s(%s)", customDestinationPrefix, platform.name), 0);
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                    this.dashboardList.setData(routeData, false, false, true, true, false, true);
                    break;
                }
                case DEPOTS: {
                    if (this.editingArea == null) {
                        this.dashboardList.setData(ClientData.getFilteredDataSet(this.transportMode, ClientData.DEPOTS), true, true, true, false, false, true);
                        break;
                    }
                    Map<Long, Siding> sidingData = ClientData.DATA_CACHE.requestDepotIdToSidings(this.editingArea.id);
                    this.dashboardList.setData(sidingData == null ? new ArrayList() : new ArrayList<Siding>(sidingData.values()), true, false, true, false, false, false);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private void onSelectTab(SelectedTab tab) {
        this.selectedTab = tab;
        this.buttonTabStations.f_93623_ = tab != SelectedTab.STATIONS;
        this.buttonTabRoutes.f_93623_ = tab != SelectedTab.ROUTES;
        this.buttonTabDepots.f_93623_ = tab != SelectedTab.DEPOTS;
        this.stopEditing();
        this.widgetMap.setShowStations(this.selectedTab != SelectedTab.DEPOTS);
    }

    private void onFind(NameColorDataBase data, int index) {
        if (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) {
            if (this.editingArea == null && data instanceof AreaBase) {
                AreaBase area = (AreaBase)data;
                if (AreaBase.nonNullCorners(area)) {
                    this.widgetMap.find(((Integer)area.corner1.m_14418_()).intValue(), ((Integer)area.corner1.m_14419_()).intValue(), ((Integer)area.corner2.m_14418_()).intValue(), ((Integer)area.corner2.m_14419_()).intValue());
                }
            } else if (this.selectedTab == SelectedTab.STATIONS) {
                Platform platform = (Platform)data;
                this.widgetMap.find(platform.getMidPos());
            }
        }
    }

    private void onDrawArea(NameColorDataBase data, int index) {
        switch (this.selectedTab) {
            case STATIONS: 
            case DEPOTS: {
                if (this.editingArea != null || !(data instanceof AreaBase)) break;
                this.startEditingArea((AreaBase)data, false);
                break;
            }
            case ROUTES: {
                if (!(data instanceof Route)) break;
                this.startEditingRoute((Route)data, false);
            }
        }
        this.dashboardList.clearSearch();
    }

    private void onEdit(NameColorDataBase data, int index) {
        if (this.f_96541_ != null) {
            switch (this.selectedTab) {
                case STATIONS: {
                    if (this.editingArea == null) {
                        if (!(data instanceof Station)) break;
                        UtilitiesClient.setScreen(this.f_96541_, new EditStationScreen((Station)data, this));
                        break;
                    }
                    if (!(data instanceof Platform)) break;
                    UtilitiesClient.setScreen(this.f_96541_, new PlatformScreen((Platform)data, this.transportMode, this));
                    break;
                }
                case ROUTES: {
                    if (this.editingRoute == null && data instanceof Route) {
                        UtilitiesClient.setScreen(this.f_96541_, new EditRouteScreen((Route)data, this));
                        break;
                    }
                    this.startEditingRouteDestination(index);
                    break;
                }
                case DEPOTS: {
                    if (this.editingArea == null) {
                        if (!(data instanceof Depot)) break;
                        UtilitiesClient.setScreen(this.f_96541_, new EditDepotScreen((Depot)data, this.transportMode, this));
                        break;
                    }
                    if (!(data instanceof Siding)) break;
                    UtilitiesClient.setScreen(this.f_96541_, new SidingScreen((Siding)data, this.transportMode, this));
                }
            }
        }
    }

    private void onSort() {
        if (this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null) {
            this.editingRoute.setPlatformIds(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
        }
    }

    private void onDelete(NameColorDataBase data, int index) {
        try {
            switch (this.selectedTab) {
                case STATIONS: {
                    if (this.f_96541_ == null) break;
                    Station station = (Station)data;
                    UtilitiesClient.setScreen(this.f_96541_, new DeleteConfirmationScreen(() -> {
                        PacketTrainDataGuiClient.sendDeleteData(PACKET_DELETE_STATION, station.id);
                        ClientData.STATIONS.remove(station);
                    }, IGui.formatStationName(station.name), this));
                    break;
                }
                case ROUTES: {
                    if (this.editingRoute == null) {
                        if (this.f_96541_ == null || !(data instanceof Route)) break;
                        Route route = (Route)data;
                        UtilitiesClient.setScreen(this.f_96541_, new DeleteConfirmationScreen(() -> {
                            PacketTrainDataGuiClient.sendDeleteData(PACKET_DELETE_ROUTE, route.id);
                            ClientData.ROUTES.remove(route);
                        }, IGui.formatStationName(route.name), this));
                        break;
                    }
                    this.editingRoute.platformIds.remove(index);
                    this.editingRoute.setPlatformIds(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
                    break;
                }
                case DEPOTS: {
                    if (this.f_96541_ == null || !(data instanceof Depot)) break;
                    Depot depot = (Depot)data;
                    UtilitiesClient.setScreen(this.f_96541_, new DeleteConfirmationScreen(() -> {
                        PacketTrainDataGuiClient.sendDeleteData(PACKET_DELETE_DEPOT, depot.id);
                        ClientData.DEPOTS.remove(depot);
                    }, IGui.formatStationName(depot.name), this));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Route.RoutePlatform> getList() {
        return this.editingRoute == null ? new ArrayList() : this.editingRoute.platformIds;
    }

    private void startEditingArea(AreaBase editingArea, boolean isNew) {
        this.editingArea = editingArea;
        this.editingRoute = null;
        this.isNew = isNew;
        this.textFieldName.m_94144_(editingArea.name);
        this.colorSelector.setColor(editingArea.color);
        this.widgetMap.startEditingArea(editingArea);
        this.toggleButtons();
    }

    private void startEditingRoute(Route editingRoute, boolean isNew) {
        this.editingArea = null;
        this.editingRoute = editingRoute;
        this.isNew = isNew;
        this.editingRoutePlatformIndex = -1;
        this.textFieldName.m_94144_(editingRoute.name);
        this.colorSelector.setColor(editingRoute.color);
        this.widgetMap.startEditingRoute();
        this.toggleButtons();
    }

    private void startEditingRouteDestination(int index) {
        this.editingRoutePlatformIndex = index;
        if (this.isValidRoutePlatformIndex()) {
            this.textFieldCustomDestination.m_94144_(this.editingRoute.platformIds.get((int)index).customDestination);
        }
        this.toggleButtons();
    }

    private void onDrawCorners(Tuple<Integer, Integer> corner1, Tuple<Integer, Integer> corner2) {
        this.editingArea.corner1 = corner1;
        this.editingArea.corner2 = corner2;
        this.toggleButtons();
    }

    private void onDrawCornersMouseRelease() {
        this.editingArea.setCorners(packet -> PacketTrainDataGuiClient.sendUpdate(this.editingArea instanceof Station ? PACKET_UPDATE_STATION : PACKET_UPDATE_DEPOT, packet));
    }

    private void onClickAddPlatformToRoute(long platformId) {
        this.editingRoute.platformIds.add(new Route.RoutePlatform(platformId));
        this.editingRoute.setPlatformIds(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
    }

    private void onClickEditSavedRail(SavedRailBase savedRail) {
        if (savedRail instanceof Platform) {
            UtilitiesClient.setScreen(Minecraft.m_91087_(), new PlatformScreen((Platform)savedRail, this.transportMode, this));
        } else if (savedRail instanceof Siding) {
            UtilitiesClient.setScreen(Minecraft.m_91087_(), new SidingScreen((Siding)savedRail, this.transportMode, this));
        }
    }

    private void onDoneEditingArea() {
        if (this.editingArea instanceof Station || this.editingArea instanceof Depot) {
            boolean isStation = this.editingArea instanceof Station;
            if (this.isNew) {
                if (isStation) {
                    ClientData.STATIONS.add((Station)this.editingArea);
                } else {
                    ClientData.DEPOTS.add((Depot)this.editingArea);
                }
            }
            this.editingArea.name = IGui.textOrUntitled(this.textFieldName.m_94155_());
            this.editingArea.color = this.colorSelector.getColor();
            this.editingArea.setNameColor(packet -> PacketTrainDataGuiClient.sendUpdate(isStation ? PACKET_UPDATE_STATION : PACKET_UPDATE_DEPOT, packet));
        }
        this.stopEditing();
    }

    private void onDoneEditingRoute() {
        if (this.isNew) {
            try {
                ClientData.ROUTES.add(this.editingRoute);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.editingRoute.name = IGui.textOrUntitled(this.textFieldName.m_94155_());
        this.editingRoute.color = this.colorSelector.getColor();
        this.editingRoute.setNameColor(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
        this.stopEditing();
    }

    private void onDoneEditingRouteDestination() {
        if (this.isValidRoutePlatformIndex()) {
            this.editingRoute.platformIds.get((int)this.editingRoutePlatformIndex).customDestination = this.textFieldCustomDestination.m_94155_();
            this.editingRoute.setPlatformIds(packet -> PacketTrainDataGuiClient.sendUpdate(PACKET_UPDATE_ROUTE, packet));
        }
        this.startEditingRoute(this.editingRoute, this.isNew);
    }

    private void stopEditing() {
        this.editingArea = null;
        this.editingRoute = null;
        this.widgetMap.stopEditing();
        this.toggleButtons();
    }

    private boolean isValidRoutePlatformIndex() {
        return this.editingRoute != null && this.editingRoutePlatformIndex >= 0 && this.editingRoutePlatformIndex < this.editingRoute.platformIds.size();
    }

    private void toggleButtons() {
        boolean showTextFields;
        boolean hasPermission = ClientData.hasPermission();
        boolean showRouteDestinationFields = this.isValidRoutePlatformIndex();
        this.buttonAddStation.f_93624_ = this.selectedTab == SelectedTab.STATIONS && this.editingArea == null && hasPermission;
        this.buttonAddRoute.f_93624_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute == null && hasPermission;
        this.buttonAddDepot.f_93624_ = this.selectedTab == SelectedTab.DEPOTS && this.editingArea == null && hasPermission;
        this.buttonDoneEditingStation.f_93624_ = (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) && this.editingArea != null;
        this.buttonDoneEditingStation.f_93623_ = AreaBase.nonNullCorners(this.editingArea);
        this.buttonDoneEditingRoute.f_93624_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null && !showRouteDestinationFields;
        this.buttonDoneEditingRouteDestination.f_93624_ = this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null && showRouteDestinationFields;
        this.textFieldName.f_93624_ = showTextFields = (this.selectedTab == SelectedTab.STATIONS || this.selectedTab == SelectedTab.DEPOTS) && this.editingArea != null || this.selectedTab == SelectedTab.ROUTES && this.editingRoute != null && !showRouteDestinationFields;
        this.textFieldCustomDestination.f_93624_ = showRouteDestinationFields;
        this.colorSelector.f_93624_ = showTextFields;
        this.dashboardList.height = this.f_96544_ - 40 - (showTextFields || showRouteDestinationFields ? 24 : 0);
    }

    private static enum SelectedTab {
        STATIONS,
        ROUTES,
        DEPOTS;

    }
}

