/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.block.BlockStationNameBase;
import mtr.block.BlockStationNameEntrance;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.render.RenderStationNameBase;
import mtr.render.RenderTrains;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class RenderStationNameTiled<T extends BlockStationNameBase.TileEntityStationNameBase>
extends RenderStationNameBase<T> {
    private final boolean showLogo;

    public RenderStationNameTiled(BlockEntityRenderDispatcher dispatcher, boolean showLogo) {
        super(dispatcher);
        this.showLogo = showLogo;
    }

    @Override
    protected void drawStationName(BlockGetter world, BlockPos pos, BlockState state, Direction facing, StoredMatrixTransformations storedMatrixTransformations, MultiBufferSource vertexConsumers, String stationName, int stationColor, int color, int light) {
        int lengthLeft = this.getLength(world, pos, false);
        int lengthRight = this.getLength(world, pos, true);
        int totalLength = lengthLeft + lengthRight - 1;
        if (this.showLogo) {
            int propagateProperty = (Integer)IBlock.getStatePropertySafe(world, pos, BlockStationNameEntrance.STYLE);
            float logoSize = propagateProperty % 2 == 0 ? 0.5f : 1.0f;
            RenderTrains.scheduleRender(ClientData.DATA_CACHE.getStationNameEntrance((int)(propagateProperty < 2 || propagateProperty >= 4 ? -1 : -16777216), (String)IGui.insertTranslation((String)"gui.mtr.station_cjk", (String)"gui.mtr.station", (int)1, (String[])new String[]{stationName}), (float)((float)totalLength / logoSize)).resourceLocation, false, RenderTrains.QueuedRenderLayer.INTERIOR, (matrices, vertexConsumer) -> {
                storedMatrixTransformations.transform((PoseStack)matrices);
                IDrawing.drawTexture(matrices, vertexConsumer, -0.5f, -logoSize / 2.0f, 1.0f, logoSize, (float)(lengthLeft - 1) / (float)totalLength, 0.0f, (float)lengthLeft / (float)totalLength, 1.0f, facing, color, light);
                matrices.m_85849_();
            });
        } else {
            RenderTrains.scheduleRender(ClientData.DATA_CACHE.getStationName((String)stationName, (float)((float)totalLength)).resourceLocation, false, RenderTrains.QueuedRenderLayer.EXTERIOR, (matrices, vertexConsumer) -> {
                storedMatrixTransformations.transform((PoseStack)matrices);
                IDrawing.drawTexture(matrices, vertexConsumer, -0.5f, -0.5f, 1.0f, 1.0f, (float)(lengthLeft - 1) / (float)totalLength, 0.0f, (float)lengthLeft / (float)totalLength, 1.0f, facing, color, light);
                matrices.m_85849_();
            });
        }
    }

    private int getLength(BlockGetter world, BlockPos pos, boolean lookRight) {
        Block checkBlock;
        if (world == null) {
            return 1;
        }
        Direction facing = (Direction)IBlock.getStatePropertySafe(world, pos, BlockStationNameBase.f_54117_);
        Block thisBlock = world.m_8055_(pos).m_60734_();
        int length = 1;
        while ((checkBlock = world.m_8055_(pos.m_5484_(lookRight ? facing.m_122427_() : facing.m_122428_(), length)).m_60734_()) instanceof BlockStationNameBase && checkBlock == thisBlock) {
            ++length;
        }
        return length;
    }
}

