/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import mtr.block.BlockStationNameBase;
import mtr.block.IBlock;
import mtr.client.ClientData;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.data.RailwayData;
import mtr.data.Station;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.Text;
import mtr.mappings.UtilitiesClient;
import mtr.render.RenderRouteBase;
import mtr.render.StoredMatrixTransformations;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public abstract class RenderStationNameBase<T extends BlockStationNameBase.TileEntityStationNameBase>
extends BlockEntityRendererMapper<T>
implements IGui,
IDrawing {
    public RenderStationNameBase(BlockEntityRenderDispatcher dispatcher) {
        super(dispatcher);
    }

    public void render(T entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        Level world = entity.m_58904_();
        if (world == null) {
            return;
        }
        BlockPos pos = entity.m_58899_();
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, BlockStationNameBase.f_54117_);
        int color = RenderRouteBase.getShadingColor(facing, ((BlockStationNameBase.TileEntityStationNameBase)entity).getColor(state));
        StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations();
        storedMatrixTransformations.add(matricesNew -> {
            matricesNew.m_85837_(0.5 + (double)entity.m_58899_().m_123341_(), 0.5 + (double)entity.yOffset + (double)entity.m_58899_().m_123342_(), 0.5 + (double)entity.m_58899_().m_123343_());
            UtilitiesClient.rotateYDegrees(matricesNew, -facing.m_122435_());
            UtilitiesClient.rotateZDegrees(matricesNew, 180.0f);
        });
        Station station = RailwayData.getStation(ClientData.STATIONS, ClientData.DATA_CACHE, pos);
        for (int i = 0; i < (((BlockStationNameBase.TileEntityStationNameBase)entity).isDoubleSided ? 2 : 1); ++i) {
            StoredMatrixTransformations storedMatrixTransformations2 = storedMatrixTransformations.copy();
            boolean shouldFlip = i == 1;
            storedMatrixTransformations2.add(matricesNew -> {
                if (shouldFlip) {
                    UtilitiesClient.rotateYDegrees(matricesNew, 180.0f);
                }
                matricesNew.m_85837_(0.0, 0.0, 0.5 - (double)entity.zOffset - (double)0.003125f);
            });
            this.drawStationName((BlockGetter)world, pos, state, facing, storedMatrixTransformations2, vertexConsumers, station == null ? Text.translatable("gui.mtr.untitled", new Object[0]).getString() : station.name, station == null ? 0 : station.color, color, light);
        }
    }

    protected abstract void drawStationName(BlockGetter var1, BlockPos var2, BlockState var3, Direction var4, StoredMatrixTransformations var5, MultiBufferSource var6, String var7, int var8, int var9, int var10);
}

