/*
 * Decompiled with CFR 0.152.
 */
package mtr.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.block.BlockSignalSemaphoreBase;
import mtr.client.IDrawing;
import mtr.mappings.UtilitiesClient;
import mtr.render.MoreRenderLayers;
import mtr.render.RenderSignalBase;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class RenderSignalSemaphore<T extends BlockSignalSemaphoreBase.TileEntitySignalSemaphoreBase>
extends RenderSignalBase<T> {
    private static final int ANGLE = 55;
    private static final int SPEED = 4;

    public RenderSignalSemaphore(BlockEntityRenderDispatcher dispatcher, boolean isSingleSided) {
        super(dispatcher, isSingleSided, 2);
    }

    @Override
    protected void render(PoseStack matrices, MultiBufferSource vertexConsumers, VertexConsumer vertexConsumer, T entity, float tickDelta, Direction facing, int occupiedAspect, boolean isBackSide) {
        float angle = isBackSide ? ((BlockSignalSemaphoreBase.TileEntitySignalSemaphoreBase)((Object)entity)).angle2 : ((BlockSignalSemaphoreBase.TileEntitySignalSemaphoreBase)((Object)entity)).angle1;
        IDrawing.drawTexture(matrices, vertexConsumer, -0.0625f, 0.296875f, -0.190625f, 0.0625f, 0.453125f, -0.190625f, facing.m_122424_(), angle < 27.5f ? -65536 : -16711936, 0xF000F0);
        matrices.m_85837_(0.1875, 0.375, 0.0);
        UtilitiesClient.rotateZDegrees(matrices, -180.0f - angle);
        Level world = entity.m_58904_();
        if (world != null) {
            BlockPos pos = entity.m_58899_();
            VertexConsumer vertexConsumer2 = vertexConsumers.m_6299_(MoreRenderLayers.getExterior(new ResourceLocation("mtr:textures/block/semaphore.png")));
            int light = LightTexture.m_109885_((int)world.m_45517_(LightLayer.BLOCK, pos), (int)world.m_45517_(LightLayer.SKY, pos));
            IDrawing.drawTexture(matrices, vertexConsumer2, -0.705f, -0.5f, -0.19375f, 0.295f, 0.5f, -0.19375f, facing.m_122424_(), -1, light);
            IDrawing.drawTexture(matrices, vertexConsumer2, 0.295f, -0.5f, -0.19375f, -0.705f, 0.5f, -0.19375f, 1.0f, 0.0f, 0.0f, 1.0f, facing.m_122424_(), -1, light);
        }
        float newAngle = occupiedAspect > 0 ? Math.max(0.0f, angle - 4.0f * tickDelta) : Math.min(55.0f, angle + 4.0f * tickDelta);
        if (isBackSide) {
            ((BlockSignalSemaphoreBase.TileEntitySignalSemaphoreBase)((Object)entity)).angle2 = newAngle;
        } else {
            ((BlockSignalSemaphoreBase.TileEntitySignalSemaphoreBase)((Object)entity)).angle1 = newAngle;
        }
    }
}

