/*
 * Decompiled with CFR 0.152.
 */
package mtr.model;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import mtr.MTRClient;
import mtr.client.DoorAnimationType;
import mtr.client.IDrawing;
import mtr.client.ScrollingText;
import mtr.data.IGui;
import mtr.data.Route;
import mtr.data.Station;
import mtr.data.TrainClient;
import mtr.mappings.UtilitiesClient;
import mtr.model.ModelDoorOverlay;
import mtr.model.ModelDoorOverlayTopBase;
import mtr.model.ModelTrainBase;
import mtr.render.RenderTrains;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;

public abstract class ModelSimpleTrainBase<T>
extends ModelTrainBase {
    public ModelSimpleTrainBase(DoorAnimationType doorAnimationType, boolean renderDoorOverlay) {
        super(doorAnimationType, renderDoorOverlay);
    }

    @Override
    protected final void render(PoseStack matrices, VertexConsumer vertices, ModelTrainBase.RenderStage renderStage, int light, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ, int car, int totalCars, boolean head1IsFront, boolean renderDetails) {
        boolean isEnd1Head = car == 0;
        boolean isEnd2Head = car == totalCars - 1;
        for (int position : this.getWindowPositions()) {
            this.renderWindowPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        for (int position : this.getDoorPositions()) {
            this.renderDoorPositions(matrices, vertices, renderStage, light, position, renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, isEnd1Head, isEnd2Head);
        }
        if (isEnd1Head) {
            this.renderHeadPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, head1IsFront);
        } else {
            this.renderEndPosition1(matrices, vertices, renderStage, light, this.getEndPositions()[0], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
        if (isEnd2Head) {
            this.renderHeadPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ, !head1IsFront);
        } else {
            this.renderEndPosition2(matrices, vertices, renderStage, light, this.getEndPositions()[1], renderDetails, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderExtraDetails1(PoseStack matrices, MultiBufferSource vertexConsumers, int light, int lightOnInteriorLevel, boolean lightsOn, float doorLeftX, float doorRightX, float doorLeftZ, float doorRightZ) {
        for (int position : this.getDoorPositions()) {
            ModelDoorOverlayTopBase modelDoorOverlayTop;
            ModelDoorOverlay modelDoorOverlay;
            ModelDoorOverlay modelDoorOverlay2 = modelDoorOverlay = this.renderDoorOverlay ? this.getModelDoorOverlay() : null;
            if (modelDoorOverlay != null) {
                modelDoorOverlay.render(matrices, vertexConsumers, ModelTrainBase.RenderStage.INTERIOR, lightOnInteriorLevel, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
                modelDoorOverlay.render(matrices, vertexConsumers, ModelTrainBase.RenderStage.EXTERIOR, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ, lightsOn);
            }
            ModelDoorOverlayTopBase modelDoorOverlayTopBase = modelDoorOverlayTop = this.renderDoorOverlay ? this.getModelDoorOverlayTop() : null;
            if (modelDoorOverlayTop == null) continue;
            modelDoorOverlayTop.render(matrices, vertexConsumers, light, position, doorLeftX, doorRightX, doorLeftZ, doorRightZ);
        }
    }

    @Override
    protected void renderExtraDetails2(PoseStack matrices, MultiBufferSource vertexConsumers, TrainClient train, int car, int totalCars, boolean atPlatform) {
        MultiBufferSource.BufferSource immediate = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        Route thisRoute = train.getThisRoute();
        Route nextRoute = train.getNextRoute();
        Station thisStation = train.getThisStation();
        Station nextStation = train.getNextStation();
        Station lastStation = train.getLastStation();
        this.renderTextDisplays(matrices, vertexConsumers, Minecraft.m_91087_().f_91062_, immediate, thisRoute, nextRoute, thisStation, nextStation, lastStation, thisRoute == null ? null : thisRoute.getDestination(train.getCurrentStationIndex()), car, totalCars, atPlatform, train.scrollingTexts);
        immediate.m_109911_();
    }

    protected void renderTextDisplays(PoseStack matrices, MultiBufferSource vertexConsumers, Font font, MultiBufferSource.BufferSource immediate, Route thisRoute, Route nextRoute, Station thisStation, Station nextStation, Station lastStation, String customDestination, int car, int totalCars, boolean atPlatform, List<ScrollingText> scrollingTexts) {
    }

    protected void renderFrontDestination(PoseStack matrices, Font font, MultiBufferSource.BufferSource immediate, float x1, float y1, float z1, float x2, float y2, float z2, float rotationX, float rotationY, float maxWidth, float maxHeight, int colorCjk, int color, float fontSizeRatio, String text, boolean padOneLine, int car, int totalCars) {
        boolean isEnd1Head = car == 0;
        boolean isEnd2Head = car == totalCars - 1;
        for (int i = 0; i < 2; ++i) {
            if ((i != 0 || !isEnd1Head) && (i != 1 || !isEnd2Head)) continue;
            matrices.m_85836_();
            if (i == 1) {
                UtilitiesClient.rotateYDegrees(matrices, 180.0f);
            }
            matrices.m_85837_((double)x1, (double)y1, (double)z1);
            if (rotationY != 0.0f) {
                UtilitiesClient.rotateYDegrees(matrices, rotationY);
            }
            if (rotationX != 0.0f) {
                UtilitiesClient.rotateXDegrees(matrices, rotationX);
            }
            matrices.m_85837_((double)x2, (double)y2, (double)z2);
            IDrawing.drawStringWithFont(matrices, font, immediate, text, IGui.HorizontalAlignment.CENTER, IGui.VerticalAlignment.CENTER, IGui.HorizontalAlignment.CENTER, 0.0f, 0.0f, maxWidth, (padOneLine && !text.contains("|") ? (IGui.isCjk(text) ? fontSizeRatio / (fontSizeRatio + 1.0f) : 0.5f) : 1.0f) * maxHeight, 1.0f, colorCjk, color, fontSizeRatio, false, 0xF000F0, null);
            matrices.m_85849_();
        }
    }

    protected String getDestinationString(Station station, String customDestination, TextSpacingType textSpacingType, boolean toUpperCase) {
        String finalResult;
        String text;
        String string = customDestination == null ? (station == null ? this.defaultDestinationString() : station.name) : (text = customDestination);
        if (textSpacingType == TextSpacingType.NORMAL) {
            finalResult = text;
        } else {
            String[] textSplit = text.split("\\|");
            ArrayList<Object> result = new ArrayList<Object>();
            boolean hasCjk = false;
            for (String textPart : textSplit) {
                StringBuilder stringBuilder;
                int i;
                boolean isCjk = IGui.isCjk(textPart);
                if (textSpacingType == TextSpacingType.SPACE_CJK || textSpacingType == TextSpacingType.SPACE_CJK_FLIPPED) {
                    result.add(textSpacingType == TextSpacingType.SPACE_CJK ? result.size() : 0, isCjk && textPart.length() == 2 ? textPart.charAt(0) + " " + textPart.charAt(1) : textPart);
                    continue;
                }
                if (textSpacingType == TextSpacingType.SPACE_CJK_LARGE) {
                    if (isCjk) {
                        StringBuilder cjkResult = new StringBuilder();
                        for (i = 0; i < textPart.length(); ++i) {
                            cjkResult.append(textPart.charAt(i));
                            for (int j = 0; j < (textPart.length() == 2 ? 3 : 1); ++j) {
                                cjkResult.append("   ");
                            }
                        }
                        result.add(cjkResult.toString().trim());
                        continue;
                    }
                    result.add(textPart);
                    continue;
                }
                if (textSpacingType != TextSpacingType.MLR_SPACING) continue;
                if (isCjk) {
                    stringBuilder = new StringBuilder(textPart);
                    for (i = textPart.length(); i < 3; ++i) {
                        stringBuilder.append(" ");
                    }
                    hasCjk = true;
                } else {
                    stringBuilder = new StringBuilder();
                    for (i = textPart.length(); i < 9; ++i) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(textPart);
                }
                result.add(stringBuilder.toString());
            }
            if (!hasCjk && textSpacingType == TextSpacingType.MLR_SPACING) {
                result.add(0, " ");
                result.add(0, " ");
            }
            finalResult = String.join((CharSequence)"|", result);
        }
        return toUpperCase ? finalResult.toUpperCase(Locale.ENGLISH) : finalResult;
    }

    protected String defaultDestinationString() {
        return "";
    }

    public abstract T createNew(DoorAnimationType var1, boolean var2);

    protected abstract void renderWindowPositions(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderDoorPositions(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11, boolean var12);

    protected abstract void renderHeadPosition1(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderHeadPosition2(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10, boolean var11);

    protected abstract void renderEndPosition1(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract void renderEndPosition2(PoseStack var1, VertexConsumer var2, ModelTrainBase.RenderStage var3, int var4, int var5, boolean var6, float var7, float var8, float var9, float var10);

    protected abstract ModelDoorOverlay getModelDoorOverlay();

    protected abstract ModelDoorOverlayTopBase getModelDoorOverlayTop();

    protected abstract int[] getWindowPositions();

    protected abstract int[] getDoorPositions();

    protected abstract int[] getEndPositions();

    protected static String getAlternatingString(String text) {
        String[] textSplit = text.split("\\|");
        return textSplit[(int)Math.floor(MTRClient.getGameTick() / 30.0f) % textSplit.length];
    }

    protected static String getLondonNextStationString(Route thisRoute, Route nextRoute, Station thisStation, Station nextStation, Station lastStation, String destinationString, boolean atPlatform) {
        boolean isTerminating;
        Station station;
        Station station2 = station = atPlatform ? thisStation : nextStation;
        if (station == null || thisRoute == null) {
            return "";
        }
        ArrayList<String> messages = new ArrayList<String>();
        boolean bl = isTerminating = lastStation != null && station.id == lastStation.id && nextRoute == null;
        if (!isTerminating) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_route_announcement_cjk", "gui.mtr.london_train_route_announcement", 2, IGui.textOrUntitled(thisRoute.name), IGui.textOrUntitled(destinationString)));
        }
        if (atPlatform) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_this_station_announcement_cjk", "gui.mtr.london_train_this_station_announcement", 1, IGui.textOrUntitled(station.name)));
        } else {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_next_station_announcement_cjk", "gui.mtr.london_train_next_station_announcement", 1, IGui.textOrUntitled(station.name)));
        }
        String mergedInterchangeRoutes = RenderTrains.getInterchangeRouteNames(station, thisRoute, nextRoute);
        if (!mergedInterchangeRoutes.isEmpty()) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_interchange_announcement_cjk", "gui.mtr.london_train_interchange_announcement", 1, mergedInterchangeRoutes));
        }
        if (isTerminating) {
            messages.add(IGui.insertTranslation("gui.mtr.london_train_terminating_announcement_cjk", "gui.mtr.london_train_terminating_announcement", 1, IGui.textOrUntitled(station.name)));
        }
        return IGui.formatStationName(IGui.mergeStations(messages, "", " "));
    }

    protected static enum TextSpacingType {
        NORMAL,
        SPACE_CJK,
        SPACE_CJK_FLIPPED,
        SPACE_CJK_LARGE,
        MLR_SPACING;

    }
}

