/*
 * Decompiled with CFR 0.152.
 */
package mtr.mappings;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.architectury.registry.item.ItemPropertiesRegistry;
import java.util.function.Consumer;
import java.util.function.Function;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.BlockEntityRendererMapper;
import mtr.mappings.EntityRendererMapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public interface RegistryUtilitiesClient {
    public static void registerItemModelPredicate(String id, Item item, String tag) {
        ItemPropertiesRegistry.register((ItemLike)item, (ResourceLocation)new ResourceLocation(id), (itemStack, clientWorld, livingEntity, i) -> itemStack.m_41784_().m_128441_(tag) ? 1.0f : 0.0f);
    }

    public static <T extends BlockEntityMapper> void registerTileEntityRenderer(BlockEntityType<T> type, Function<BlockEntityRenderDispatcher, BlockEntityRendererMapper<T>> factory) {
        BlockEntityRendererRegistry.register(type, context -> (BlockEntityRenderer)factory.apply(null));
    }

    public static <T extends Entity> void registerEntityRenderer(EntityType<T> type, Function<EntityRendererProvider.Context, EntityRendererMapper<T>> factory) {
    }

    public static void registerRenderType(RenderType renderType, Block block) {
        RenderTypeRegistry.register((RenderType)renderType, (Block[])new Block[]{block});
    }

    public static void registerBlockColors(BlockColor blockColor, Block block) {
        ColorHandlerRegistry.registerBlockColors((BlockColor)blockColor, (Block[])new Block[]{block});
    }

    public static void registerPlayerJoinEvent(Consumer<LocalPlayer> consumer) {
        ClientPlayerEvent.CLIENT_PLAYER_JOIN.register(consumer::accept);
    }

    public static void registerClientStoppingEvent(Consumer<Minecraft> consumer) {
        ClientLifecycleEvent.CLIENT_STOPPING.register(consumer::accept);
    }

    public static void registerClientTickEvent(Consumer<Minecraft> consumer) {
        ClientTickEvent.CLIENT_PRE.register(consumer::accept);
    }
}

