/*
 * Decompiled with CFR 0.152.
 */
package mtr.libraries.org.eclipse.jetty.server.session;

import mtr.libraries.org.eclipse.jetty.server.session.AbstractSessionCacheFactory;
import mtr.libraries.org.eclipse.jetty.server.session.NullSessionCache;
import mtr.libraries.org.eclipse.jetty.server.session.SessionCache;
import mtr.libraries.org.eclipse.jetty.server.session.SessionHandler;
import mtr.libraries.org.eclipse.jetty.util.log.Log;
import mtr.libraries.org.eclipse.jetty.util.log.Logger;

public class NullSessionCacheFactory
extends AbstractSessionCacheFactory {
    private static final Logger LOG = Log.getLogger("mtr.libraries.org.eclipse.jetty.server.session");

    @Override
    public int getEvictionPolicy() {
        return 0;
    }

    @Override
    public void setEvictionPolicy(int evictionPolicy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public boolean isSaveOnInactiveEvict() {
        return false;
    }

    @Override
    public void setSaveOnInactiveEvict(boolean saveOnInactiveEvict) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public boolean isInvalidateOnShutdown() {
        return false;
    }

    @Override
    public void setInvalidateOnShutdown(boolean invalidateOnShutdown) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring invalidateOnShutdown setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public SessionCache newSessionCache(SessionHandler handler) {
        return new NullSessionCache(handler);
    }
}

