/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.Blocks;
import mtr.CreativeModeTabs;
import mtr.block.BlockPSDAPGBase;
import mtr.block.BlockPSDTop;
import mtr.block.IBlock;
import mtr.block.ITripleBlock;
import mtr.item.ItemWithCreativeTabBase;
import mtr.mappings.Text;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemPSDAPGBase
extends ItemWithCreativeTabBase
implements IBlock {
    private final EnumPSDAPGItem item;
    private final EnumPSDAPGType type;

    public ItemPSDAPGBase(EnumPSDAPGItem item, EnumPSDAPGType type) {
        super(type.isLift ? CreativeModeTabs.ESCALATORS_LIFTS : CreativeModeTabs.RAILWAY_FACILITIES);
        this.item = item;
        this.type = type;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        int horizontalBlocks;
        int n = this.item.isDoor ? (this.type.isOdd ? 3 : 2) : (horizontalBlocks = 1);
        if (ItemPSDAPGBase.blocksNotReplaceable(context, horizontalBlocks, this.type.isPSD ? 3 : 2, this.getBlockStateFromItem().m_60734_())) {
            return InteractionResult.FAIL;
        }
        Level world = context.m_43725_();
        Direction playerFacing = context.m_8125_();
        BlockPos pos = context.m_8083_().m_121945_(context.m_43719_());
        for (int x = 0; x < horizontalBlocks; ++x) {
            BlockPos newPos = pos.m_5484_(playerFacing.m_122427_(), x);
            for (int y = 0; y < 2; ++y) {
                BlockState state = (BlockState)((BlockState)this.getBlockStateFromItem().m_61124_((Property)BlockPSDAPGBase.f_54117_, (Comparable)playerFacing)).m_61124_((Property)HALF, (Comparable)(y == 1 ? DoubleBlockHalf.UPPER : DoubleBlockHalf.LOWER));
                if (this.item.isDoor) {
                    BlockState newState = (BlockState)state.m_61124_((Property)SIDE, (Comparable)((Object)(x == 0 ? IBlock.EnumSide.LEFT : IBlock.EnumSide.RIGHT)));
                    if (this.type.isOdd) {
                        newState = (BlockState)newState.m_61124_((Property)ITripleBlock.ODD, (Comparable)Boolean.valueOf(x > 0 && x < horizontalBlocks - 1));
                    }
                    world.m_46597_(newPos.m_6630_(y), newState);
                    continue;
                }
                world.m_46597_(newPos.m_6630_(y), (BlockState)state.m_61124_((Property)SIDE_EXTENDED, (Comparable)((Object)IBlock.EnumSide.SINGLE)));
            }
            if (!this.type.isPSD) continue;
            world.m_46597_(newPos.m_6630_(2), BlockPSDTop.getActualState((BlockGetter)world, newPos.m_6630_(2)));
        }
        context.m_43722_().m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack itemStack, Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Text.translatable((String)(this.type.isLift ? (this.type.isOdd ? "tooltip.mtr.railway_sign_odd" : "tooltip.mtr.railway_sign_even") : "tooltip.mtr." + this.item.m_7912_()), new Object[0]).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY)));
    }

    private BlockState getBlockStateFromItem() {
        switch (this.type) {
            case PSD_1: {
                switch (this.item) {
                    case PSD_APG_DOOR: {
                        return Blocks.PSD_DOOR_1.get().m_49966_();
                    }
                    case PSD_APG_GLASS: {
                        return Blocks.PSD_GLASS_1.get().m_49966_();
                    }
                    case PSD_APG_GLASS_END: {
                        return Blocks.PSD_GLASS_END_1.get().m_49966_();
                    }
                }
            }
            case PSD_2: {
                switch (this.item) {
                    case PSD_APG_DOOR: {
                        return Blocks.PSD_DOOR_2.get().m_49966_();
                    }
                    case PSD_APG_GLASS: {
                        return Blocks.PSD_GLASS_2.get().m_49966_();
                    }
                    case PSD_APG_GLASS_END: {
                        return Blocks.PSD_GLASS_END_2.get().m_49966_();
                    }
                }
            }
            case APG: {
                switch (this.item) {
                    case PSD_APG_DOOR: {
                        return Blocks.APG_DOOR.get().m_49966_();
                    }
                    case PSD_APG_GLASS: {
                        return Blocks.APG_GLASS.get().m_49966_();
                    }
                    case PSD_APG_GLASS_END: {
                        return Blocks.APG_GLASS_END.get().m_49966_();
                    }
                }
            }
            case LIFT_DOOR_1: {
                return Blocks.LIFT_DOOR_EVEN_1.get().m_49966_();
            }
            case LIFT_DOOR_ODD_1: {
                return Blocks.LIFT_DOOR_ODD_1.get().m_49966_();
            }
        }
        return net.minecraft.world.level.block.Blocks.f_50016_.m_49966_();
    }

    public static boolean blocksNotReplaceable(UseOnContext context, int width, int height, Block blacklistBlock) {
        Direction facing = context.m_8125_();
        Level world = context.m_43725_();
        BlockPos startingPos = context.m_8083_().m_121945_(context.m_43719_());
        for (int x = 0; x < width; ++x) {
            BlockPos offsetPos = startingPos.m_5484_(facing.m_122427_(), x);
            if (blacklistBlock != null) {
                boolean isBlacklistedBelow = world.m_8055_(offsetPos.m_7495_()).m_60713_(blacklistBlock);
                boolean isBlacklistedAbove = world.m_8055_(offsetPos.m_6630_(height)).m_60713_(blacklistBlock);
                if (isBlacklistedBelow || isBlacklistedAbove) {
                    return true;
                }
            }
            for (int y = 0; y < height; ++y) {
                if (world.m_8055_(offsetPos.m_6630_(y)).m_60767_().m_76336_()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum EnumPSDAPGType {
        PSD_1(true, false, false),
        PSD_2(true, false, false),
        APG(false, false, false),
        LIFT_DOOR_1(false, false, true),
        LIFT_DOOR_ODD_1(false, true, true);

        private final boolean isPSD;
        private final boolean isOdd;
        private final boolean isLift;

        private EnumPSDAPGType(boolean isPSD, boolean isOdd, boolean isLift) {
            this.isPSD = isPSD;
            this.isOdd = isOdd;
            this.isLift = isLift;
        }
    }

    public static enum EnumPSDAPGItem implements StringRepresentable
    {
        PSD_APG_DOOR("psd_apg_door", true),
        PSD_APG_GLASS("psd_apg_glass", false),
        PSD_APG_GLASS_END("psd_apg_glass_end", false);

        private final String name;
        private final boolean isDoor;

        private EnumPSDAPGItem(String name, boolean isDoor) {
            this.name = name;
            this.isDoor = isDoor;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

