/*
 * Decompiled with CFR 0.152.
 */
package mtr.item;

import java.util.List;
import mtr.CreativeModeTabs;
import mtr.block.BlockNode;
import mtr.data.RailAngle;
import mtr.data.RailwayData;
import mtr.data.TransportMode;
import mtr.item.ItemBlockClickingBase;
import mtr.mappings.Text;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ItemNodeModifierBase
extends ItemBlockClickingBase {
    public final boolean forNonContinuousMovementNode;
    public final boolean forContinuousMovementNode;
    public final boolean forAirplaneNode;
    protected final boolean isConnector;
    public static final String TAG_POS = "pos";
    private static final String TAG_TRANSPORT_MODE = "transport_mode";

    public ItemNodeModifierBase(boolean forNonContinuousMovementNode, boolean forContinuousMovementNode, boolean forAirplaneNode, boolean isConnector) {
        super(CreativeModeTabs.CORE, properties -> properties.m_41487_(1));
        this.forNonContinuousMovementNode = forNonContinuousMovementNode;
        this.forContinuousMovementNode = forContinuousMovementNode;
        this.forAirplaneNode = forAirplaneNode;
        this.isConnector = isConnector;
    }

    @Override
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag tooltipFlag) {
        CompoundTag compoundTag = stack.m_41784_();
        long posLong = compoundTag.m_128454_(TAG_POS);
        if (posLong != 0L) {
            tooltip.add((Component)Text.translatable("tooltip.mtr.selected_block", BlockPos.m_122022_((long)posLong).m_123344_()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)));
        }
    }

    @Override
    protected void onStartClick(UseOnContext context, CompoundTag compoundTag) {
        compoundTag.m_128359_(TAG_TRANSPORT_MODE, ((BlockNode)context.m_43725_().m_8055_((BlockPos)context.m_8083_()).m_60734_()).transportMode.toString());
    }

    @Override
    protected void onEndClick(UseOnContext context, BlockPos posEnd, CompoundTag compoundTag) {
        Level world = context.m_43725_();
        RailwayData railwayData = RailwayData.getInstance(world);
        BlockPos posStart = context.m_8083_();
        BlockState stateStart = world.m_8055_(posStart);
        Block blockStart = stateStart.m_60734_();
        BlockState stateEnd = world.m_8055_(posEnd);
        if (railwayData != null && stateEnd.m_60734_() instanceof BlockNode && ((BlockNode)blockStart).transportMode.toString().equals(compoundTag.m_128461_(TAG_TRANSPORT_MODE))) {
            Player player = context.m_43723_();
            if (this.isConnector) {
                if (!posStart.equals((Object)posEnd)) {
                    float angle1 = BlockNode.getAngle(stateStart);
                    float angle2 = BlockNode.getAngle(stateEnd);
                    float angleDifference = (float)Math.toDegrees(Math.atan2(posEnd.m_123343_() - posStart.m_123343_(), posEnd.m_123341_() - posStart.m_123341_()));
                    RailAngle railAngleStart = RailAngle.fromAngle(angle1 + (float)(RailAngle.similarFacing(angleDifference, angle1) ? 0 : 180));
                    RailAngle railAngleEnd = RailAngle.fromAngle(angle2 + (float)(RailAngle.similarFacing(angleDifference, angle2) ? 180 : 0));
                    this.onConnect(world, context.m_43722_(), ((BlockNode)blockStart).transportMode, stateStart, stateEnd, posStart, posEnd, railAngleStart, railAngleEnd, player, railwayData);
                }
            } else {
                this.onRemove(world, posStart, posEnd, player, railwayData);
            }
        }
        compoundTag.m_128473_(TAG_TRANSPORT_MODE);
    }

    @Override
    protected boolean clickCondition(UseOnContext context) {
        Level world = context.m_43725_();
        Block blockStart = world.m_8055_(context.m_8083_()).m_60734_();
        if (blockStart instanceof BlockNode) {
            BlockNode blockNode = (BlockNode)blockStart;
            if (blockNode.transportMode == TransportMode.AIRPLANE) {
                return this.forAirplaneNode;
            }
            return blockNode.transportMode.continuousMovement ? this.forContinuousMovementNode : this.forNonContinuousMovementNode;
        }
        return false;
    }

    protected abstract void onConnect(Level var1, ItemStack var2, TransportMode var3, BlockState var4, BlockState var5, BlockPos var6, BlockPos var7, RailAngle var8, RailAngle var9, Player var10, RailwayData var11);

    protected abstract void onRemove(Level var1, BlockPos var2, BlockPos var3, Player var4, RailwayData var5);
}

