/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import mtr.MTRClient;
import mtr.RegistryClient;
import mtr.client.ClientData;
import mtr.entity.EntitySeat;
import mtr.mappings.Utilities;
import mtr.packet.PacketTrainDataGuiClient;
import mtr.render.TrainRendererBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class VehicleRidingClient {
    private float clientPrevYaw;
    private float oldPercentageX;
    private float oldPercentageZ;
    private double lastSentX;
    private double lastSentY;
    private double lastSentZ;
    private float lastSentTicks;
    private int interval;
    private int previousInterval;
    private final List<Double> offset = new ArrayList<Double>();
    private final Map<UUID, Float> percentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> percentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesX = new HashMap<UUID, Float>();
    private final Map<UUID, Float> newPercentagesZ = new HashMap<UUID, Float>();
    private final Map<UUID, Vec3> riderPositions = new HashMap<UUID, Vec3>();
    private final Set<UUID> ridingEntities;
    private final ResourceLocation packetId;
    private static final float VEHICLE_WALKING_SPEED_MULTIPLIER = 0.25f;
    private static final int VEHICLE_PERCENTAGE_UPDATE_INTERVAL = 20;

    public VehicleRidingClient(Set<UUID> ridingEntities, ResourceLocation packetId) {
        this.ridingEntities = ridingEntities;
        this.packetId = packetId;
    }

    public Vec3 renderPlayerAndGetOffset() {
        boolean noOffset = this.offset.isEmpty();
        this.riderPositions.forEach((uuid, position) -> {
            if (noOffset) {
                TrainRendererBase.renderRidingPlayer(this.getViewOffset(), uuid, position);
            } else {
                TrainRendererBase.renderRidingPlayer(this.getViewOffset(), uuid, position.m_82492_(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue()));
            }
        });
        if (noOffset) {
            return Vec3.f_82478_;
        }
        return new Vec3(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue());
    }

    public void movePlayer(Consumer<UUID> ridingEntityCallback) {
        this.offset.clear();
        this.riderPositions.clear();
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        this.ridingEntities.forEach(uuid -> {
            if (!this.percentagesX.containsKey(uuid) || !this.newPercentagesX.containsKey(uuid)) {
                this.percentagesX.put((UUID)uuid, Float.valueOf(0.5f));
                this.newPercentagesX.put((UUID)uuid, Float.valueOf(0.5f));
            }
            if (!this.percentagesZ.containsKey(uuid) || !this.newPercentagesZ.containsKey(uuid)) {
                this.percentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
                this.newPercentagesZ.put((UUID)uuid, Float.valueOf(0.5f));
            }
            ridingEntityCallback.accept((UUID)uuid);
        });
    }

    public void setOffsets(UUID uuid, double x, double y, double z, float yaw, float pitch, double length, int width, boolean doorLeftOpen, boolean doorRightOpen, boolean hasPitchAscending, boolean hasPitchDescending, float riderOffset, float riderOffsetDismounting, boolean shouldSetOffset, boolean shouldSetYaw, Runnable clientPlayerCallback) {
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        boolean isClientPlayer = uuid.equals(clientPlayer.m_20148_());
        double percentageX = VehicleRidingClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), width);
        float riderOffsetNew = doorLeftOpen && percentageX < 0.0 || doorRightOpen && percentageX > 1.0 ? riderOffsetDismounting : riderOffset;
        Vec3 playerOffset = new Vec3(percentageX, (double)riderOffsetNew, VehicleRidingClient.getValueFromPercentage(Mth.m_14187_((float)this.percentagesZ.get(uuid).floatValue()), length)).m_82496_((pitch < 0.0f ? hasPitchAscending : hasPitchDescending) ? pitch : 0.0f).m_82524_(yaw);
        ClientData.updatePlayerRidingOffset(uuid);
        this.riderPositions.put(uuid, playerOffset.m_82520_(x, y, z));
        if (isClientPlayer) {
            boolean movePlayer;
            double moveX = x + playerOffset.f_82479_;
            double moveY = y + playerOffset.f_82480_;
            double moveZ = z + playerOffset.f_82481_;
            if (MTRClient.isVivecraft()) {
                boolean movedFar;
                Entity vehicle = clientPlayer.m_20202_();
                if (vehicle instanceof EntitySeat) {
                    ((EntitySeat)vehicle).setPosByTrain(moveX, moveY, moveZ);
                    movePlayer = false;
                } else {
                    movePlayer = true;
                }
                float tempPercentageX = this.percentagesX.get(uuid).floatValue();
                boolean doorOpen = doorLeftOpen && tempPercentageX < 0.0f || doorRightOpen && tempPercentageX > 1.0f;
                boolean bl = movedFar = Math.abs(this.lastSentX - moveX) > 2.0 || Math.abs(this.lastSentY - moveY) > 2.0 || Math.abs(this.lastSentZ - moveZ) > 2.0;
                if (doorOpen || MTRClient.getGameTick() - this.lastSentTicks > 60.0f && movedFar) {
                    PacketTrainDataGuiClient.sendUpdateEntitySeatPassengerPosition(moveX, moveY, moveZ);
                    this.lastSentX = moveX;
                    this.lastSentY = moveY;
                    this.lastSentZ = moveZ;
                    this.lastSentTicks = MTRClient.getGameTick();
                }
            } else {
                movePlayer = true;
            }
            if (movePlayer) {
                clientPlayer.f_19789_ = 0.0f;
                clientPlayer.m_20334_(0.0, 0.0, 0.0);
                clientPlayer.m_7910_(0.0f);
                if (MTRClient.getGameTick() > 40.0f) {
                    clientPlayer.m_20248_(moveX, moveY, moveZ);
                }
            }
            clientPlayerCallback.run();
            if (shouldSetOffset) {
                if (shouldSetYaw) {
                    float angleDifference = (float)Math.toDegrees(this.clientPrevYaw - yaw);
                    if (angleDifference > 180.0f) {
                        angleDifference -= 360.0f;
                    } else if (angleDifference < -180.0f) {
                        angleDifference += 360.0f;
                    }
                    Utilities.incrementYaw((Entity)clientPlayer, angleDifference);
                }
                this.offset.add(x);
                this.offset.add(y);
                this.offset.add(z);
                this.offset.add(playerOffset.f_82479_);
                this.offset.add(playerOffset.f_82480_ + (double)(MTRClient.isVivecraft() ? 0.0f : clientPlayer.m_20192_()));
                this.offset.add(playerOffset.f_82481_);
            }
            this.clientPrevYaw = yaw;
        }
    }

    public void moveSelf(long id, UUID uuid, double length, int width, float yaw, int percentageOffset, int maxPercentage, boolean doorLeftOpen, boolean doorRightOpen, boolean noGangwayConnection, float ticksElapsed) {
        float newPercentageZ;
        float newPercentageX;
        float speedMultiplier = ticksElapsed * 0.25f;
        LocalPlayer clientPlayer = Minecraft.m_91087_().f_91074_;
        if (clientPlayer == null) {
            return;
        }
        if (uuid.equals(clientPlayer.m_20148_())) {
            Vec3 movement = new Vec3((double)Math.abs(clientPlayer.f_20900_) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.f_20900_) : 0.0, 0.0, (double)Math.abs(clientPlayer.f_20902_) > 0.5 ? (double)Math.copySign(speedMultiplier, clientPlayer.f_20902_) : 0.0).m_82524_((float)(-Math.toRadians(Utilities.getYaw((Entity)clientPlayer))) - yaw);
            float tempPercentageX = this.percentagesX.get(uuid).floatValue() + (float)movement.f_82479_ / (float)width;
            float tempPercentageZ = this.percentagesZ.get(uuid).floatValue() + (length == 0.0 ? 0.0f : (float)movement.f_82481_ / (float)length);
            newPercentageX = Mth.m_14036_((float)tempPercentageX, (float)(doorLeftOpen ? -3.0f : 0.0f), (float)(doorRightOpen ? 4.0f : 1.0f));
            newPercentageZ = Mth.m_14036_((float)tempPercentageZ, (float)((noGangwayConnection ? (float)percentageOffset + 0.05f : 0.0f) + 0.01f), (float)((noGangwayConnection ? (float)percentageOffset + 0.95f : (float)maxPercentage) - 0.01f));
            if (this.previousInterval != this.interval && (newPercentageX != this.oldPercentageX || newPercentageZ != this.oldPercentageZ)) {
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.writeLong(id);
                packet.writeFloat(newPercentageX);
                packet.writeFloat(newPercentageZ);
                packet.m_130077_(uuid);
                RegistryClient.sendToServer(this.packetId, packet);
                this.oldPercentageX = newPercentageX;
                this.oldPercentageZ = newPercentageZ;
            }
        } else {
            double distanceZ;
            double distanceX = VehicleRidingClient.getValueFromPercentage(this.newPercentagesX.get(uuid).floatValue(), width) - VehicleRidingClient.getValueFromPercentage(this.percentagesX.get(uuid).floatValue(), width);
            double manhattanDistance = Math.abs(distanceX + (distanceZ = VehicleRidingClient.getValueFromPercentage(this.newPercentagesZ.get(uuid).floatValue(), length) - VehicleRidingClient.getValueFromPercentage(this.percentagesZ.get(uuid).floatValue(), length)));
            if (manhattanDistance == 0.0 || distanceX * distanceX + distanceZ * distanceZ < (double)(speedMultiplier * speedMultiplier)) {
                newPercentageX = this.newPercentagesX.get(uuid).floatValue();
                newPercentageZ = this.newPercentagesZ.get(uuid).floatValue();
            } else {
                newPercentageX = this.percentagesX.get(uuid).floatValue() + (float)(distanceX / manhattanDistance * (double)speedMultiplier / (double)width);
                newPercentageZ = this.percentagesZ.get(uuid).floatValue() + (float)(length == 0.0 ? 0.0 : distanceZ / manhattanDistance * (double)speedMultiplier / length);
            }
        }
        this.percentagesX.put(uuid, Float.valueOf(newPercentageX));
        this.percentagesZ.put(uuid, Float.valueOf(newPercentageZ));
    }

    public void begin() {
        this.interval = (int)Math.floor(MTRClient.getGameTick() / 20.0f);
    }

    public void end() {
        this.previousInterval = this.interval;
    }

    public void startRiding(UUID uuid, float percentageX, float percentageZ) {
        this.ridingEntities.add(uuid);
        this.percentagesX.put(uuid, Float.valueOf(percentageX));
        this.percentagesZ.put(uuid, Float.valueOf(percentageZ));
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public void updateRiderPercentages(UUID uuid, float percentageX, float percentageZ) {
        this.newPercentagesX.put(uuid, Float.valueOf(percentageX));
        this.newPercentagesZ.put(uuid, Float.valueOf(percentageZ));
    }

    public float getPercentageZ(UUID uuid) {
        return this.percentagesZ.get(uuid).floatValue();
    }

    public Vec3 getVehicleOffset() {
        return this.offset.isEmpty() ? null : new Vec3(this.offset.get(0).doubleValue(), this.offset.get(1).doubleValue(), this.offset.get(2).doubleValue());
    }

    public Vec3 getViewOffset() {
        return this.offset.isEmpty() ? null : new Vec3(this.offset.get(3).doubleValue(), this.offset.get(4).doubleValue(), this.offset.get(5).doubleValue());
    }

    private static double getValueFromPercentage(double percentage, double total) {
        return (percentage - 0.5) * total;
    }
}

