/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mtr.MTR;
import mtr.Registry;
import mtr.block.BlockNode;
import mtr.data.DataCache;
import mtr.data.Depot;
import mtr.data.Lift;
import mtr.data.LiftServer;
import mtr.data.MessagePackHelper;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailType;
import mtr.data.RailwayDataCoolDownModule;
import mtr.data.RailwayDataDriveTrainModule;
import mtr.data.RailwayDataFileSaveModule;
import mtr.data.RailwayDataLoggingModule;
import mtr.data.RailwayDataPathGenerationModule;
import mtr.data.RailwayDataRailActionsModule;
import mtr.data.RailwayDataRouteFinderModule;
import mtr.data.Route;
import mtr.data.SavedRailBase;
import mtr.data.ScheduleEntry;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.TrainDelay;
import mtr.data.TrainServer;
import mtr.data.TransportMode;
import mtr.data.UpdateNearbyMovingObjects;
import mtr.mappings.PersistentStateMapper;
import mtr.mappings.Utilities;
import mtr.packet.IPacket;
import mtr.packet.PacketTrainDataGuiServer;
import mtr.packet.UpdateBlueMap;
import mtr.packet.UpdateDynmap;
import mtr.packet.UpdateSquaremap;
import mtr.path.PathData;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.Value;

public class RailwayData
extends PersistentStateMapper
implements IPacket {
    public final Set<Station> stations = new HashSet<Station>();
    public final Set<Platform> platforms = new HashSet<Platform>();
    public final Set<Siding> sidings = new HashSet<Siding>();
    public final Set<Route> routes = new HashSet<Route>();
    public final Set<Depot> depots = new HashSet<Depot>();
    public final Set<LiftServer> lifts = new HashSet<LiftServer>();
    public final DataCache dataCache = new DataCache(this.stations, this.platforms, this.sidings, this.routes, this.depots, this.lifts);
    public final RailwayDataLoggingModule railwayDataLoggingModule;
    public final RailwayDataCoolDownModule railwayDataCoolDownModule;
    public final RailwayDataPathGenerationModule railwayDataPathGenerationModule;
    public final RailwayDataRailActionsModule railwayDataRailActionsModule;
    public final RailwayDataDriveTrainModule railwayDataDriveTrainModule;
    public final RailwayDataRouteFinderModule railwayDataRouteFinderModule;
    private int prevPlatformCount;
    private int prevSidingCount;
    private boolean useTimeAndWindSync;
    private final Level world;
    private final Map<BlockPos, Map<BlockPos, Rail>> rails = new HashMap<BlockPos, Map<BlockPos, Rail>>();
    private final SignalBlocks signalBlocks = new SignalBlocks();
    private final RailwayDataFileSaveModule railwayDataFileSaveModule;
    private final List<Map<UUID, Long>> trainPositions = new ArrayList<Map<UUID, Long>>(2);
    private final Map<Player, BlockPos> playerLastUpdatedPositions = new HashMap<Player, BlockPos>();
    private final List<Player> playersToSyncSchedules = new ArrayList<Player>();
    private final UpdateNearbyMovingObjects<TrainServer> updateNearbyTrains;
    private final UpdateNearbyMovingObjects<LiftServer> updateNearbyLifts;
    private final Map<Long, List<ScheduleEntry>> schedulesForPlatform = new HashMap<Long, List<ScheduleEntry>>();
    private final Map<Long, Map<BlockPos, TrainDelay>> trainDelays = new HashMap<Long, Map<BlockPos, TrainDelay>>();
    private static final int RAIL_UPDATE_DISTANCE = 128;
    private static final int PLAYER_MOVE_UPDATE_THRESHOLD = 16;
    private static final int SCHEDULE_UPDATE_TICKS = 60;
    private static final int DATA_VERSION = 1;
    private static final String NAME = "mtr_train_data";
    private static final String KEY_RAW_MESSAGE_PACK = "raw_message_pack";
    private static final String KEY_DATA_VERSION = "mtr_data_version";
    private static final String KEY_STATIONS = "stations";
    private static final String KEY_PLATFORMS = "platforms";
    private static final String KEY_SIDINGS = "sidings";
    private static final String KEY_ROUTES = "routes";
    private static final String KEY_DEPOTS = "depots";
    private static final String KEY_LIFTS = "lifts";
    private static final String KEY_RAILS = "rails";
    private static final String KEY_SIGNAL_BLOCKS = "signal_blocks";
    private static final String KEY_USE_TIME_AND_WIND_SYNC = "use_time_and_wind_sync";

    public RailwayData(Level world) {
        super(NAME);
        this.world = world;
        this.trainPositions.add(new HashMap());
        this.trainPositions.add(new HashMap());
        ResourceLocation dimensionLocation = world.m_46472_().m_135782_();
        Path savePath = ((ServerLevel)world).m_7654_().m_129843_(LevelResource.f_78182_).resolve("mtr").resolve(dimensionLocation.m_135827_()).resolve(dimensionLocation.m_135815_());
        this.railwayDataFileSaveModule = new RailwayDataFileSaveModule(this, world, this.rails, savePath, this.signalBlocks);
        this.railwayDataLoggingModule = new RailwayDataLoggingModule(this, world, this.rails, savePath);
        this.railwayDataPathGenerationModule = new RailwayDataPathGenerationModule(this, world, this.rails);
        this.railwayDataRailActionsModule = new RailwayDataRailActionsModule(this, world, this.rails);
        this.railwayDataCoolDownModule = new RailwayDataCoolDownModule(this, world, this.rails);
        this.railwayDataDriveTrainModule = new RailwayDataDriveTrainModule(this, world, this.rails);
        this.railwayDataRouteFinderModule = new RailwayDataRouteFinderModule(this, world, this.rails);
        this.updateNearbyTrains = new UpdateNearbyMovingObjects(PACKET_DELETE_TRAINS, PACKET_UPDATE_TRAINS);
        this.updateNearbyLifts = new UpdateNearbyMovingObjects(PACKET_DELETE_LIFTS, PACKET_UPDATE_LIFTS);
    }

    @Override
    public void load(CompoundTag compoundTag) {
        if (compoundTag.m_128441_(KEY_RAW_MESSAGE_PACK)) {
            try {
                MessageUnpacker messageUnpacker = MessagePack.newDefaultUnpacker(compoundTag.m_128463_(KEY_RAW_MESSAGE_PACK));
                int mapSize = messageUnpacker.unpackMapHeader();
                block33: for (int i = 0; i < mapSize; ++i) {
                    String key = messageUnpacker.unpackString();
                    if (key.equals(KEY_DATA_VERSION)) {
                        if (messageUnpacker.unpackInt() <= 1) continue;
                        throw new IllegalArgumentException("Unsupported data version");
                    }
                    int arraySize = messageUnpacker.unpackArrayHeader();
                    switch (key) {
                        case "stations": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.stations.add(new Station(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "platforms": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.platforms.add(new Platform(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "sidings": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.sidings.add(new Siding(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "routes": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.routes.add(new Route(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "depots": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.depots.add(new Depot(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "lifts": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.lifts.add(new LiftServer(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                        case "rails": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                RailEntry railEntry = new RailEntry(RailwayData.readMessagePackSKMap(messageUnpacker));
                                this.rails.put(railEntry.pos, railEntry.connections);
                            }
                            continue block33;
                        }
                        case "signal_blocks": {
                            int j;
                            for (j = 0; j < arraySize; ++j) {
                                this.signalBlocks.signalBlocks.add(new SignalBlocks.SignalBlock(RailwayData.readMessagePackSKMap(messageUnpacker)));
                            }
                            continue block33;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                CompoundTag tagStations = compoundTag.m_128469_(KEY_STATIONS);
                for (Object key : tagStations.m_128431_()) {
                    this.stations.add(new Station(tagStations.m_128469_((String)key)));
                }
                CompoundTag tagNewPlatforms = compoundTag.m_128469_(KEY_PLATFORMS);
                for (Object key : tagNewPlatforms.m_128431_()) {
                    this.platforms.add(new Platform(tagNewPlatforms.m_128469_((String)key)));
                }
                CompoundTag tagNewSidings = compoundTag.m_128469_(KEY_SIDINGS);
                for (Object key : tagNewSidings.m_128431_()) {
                    this.sidings.add(new Siding(tagNewSidings.m_128469_((String)key)));
                }
                CompoundTag tagNewRoutes = compoundTag.m_128469_(KEY_ROUTES);
                for (Object key : tagNewRoutes.m_128431_()) {
                    this.routes.add(new Route(tagNewRoutes.m_128469_((String)key)));
                }
                CompoundTag tagNewDepots = compoundTag.m_128469_(KEY_DEPOTS);
                for (Object key : tagNewDepots.m_128431_()) {
                    this.depots.add(new Depot(tagNewDepots.m_128469_((String)key)));
                }
                CompoundTag tagNewRails = compoundTag.m_128469_(KEY_RAILS);
                for (String key : tagNewRails.m_128431_()) {
                    RailEntry railEntry = new RailEntry(tagNewRails.m_128469_(key));
                    this.rails.put(railEntry.pos, railEntry.connections);
                }
                CompoundTag tagNewSignalBlocks = compoundTag.m_128469_(KEY_SIGNAL_BLOCKS);
                for (String key : tagNewSignalBlocks.m_128431_()) {
                    this.signalBlocks.signalBlocks.add(new SignalBlocks.SignalBlock(tagNewSignalBlocks.m_128469_(key)));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.railwayDataFileSaveModule.load();
        this.validateData();
        this.dataCache.sync();
        this.signalBlocks.writeCache();
        this.useTimeAndWindSync = compoundTag.m_128471_(KEY_USE_TIME_AND_WIND_SYNC);
        this.runRealTimeSync();
        try {
            UpdateDynmap.updateDynmap(this.world, this);
        }
        catch (IllegalStateException | NoClassDefFoundError ignored) {
            System.out.println("Dynamp is not loaded");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            UpdateBlueMap.updateBlueMap(this.world, this);
        }
        catch (IllegalStateException | NoClassDefFoundError ignored) {
            System.out.println("BlueMap is not loaded");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            UpdateSquaremap.updateSquaremap(this.world, this);
        }
        catch (IllegalStateException | NoClassDefFoundError ignored) {
            System.out.println("Squaremap is not loaded");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_77757_(File file) {
        MinecraftServer minecraftServer = ((ServerLevel)this.world).m_7654_();
        if (minecraftServer.m_129918_() || !minecraftServer.m_130010_()) {
            this.railwayDataFileSaveModule.fullSave();
        } else {
            this.railwayDataFileSaveModule.autoSave();
        }
        this.railwayDataLoggingModule.save();
        this.m_77762_();
        super.m_77757_(file);
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        compoundTag.m_128379_(KEY_USE_TIME_AND_WIND_SYNC, this.useTimeAndWindSync);
        return compoundTag;
    }

    public void simulateTrains() {
        List players = this.world.m_6907_();
        players.forEach(player -> {
            BlockPos playerBlockPos = player.m_20183_();
            Vec3 playerPos = player.m_20182_();
            if (!this.playerLastUpdatedPositions.containsKey(player) || this.playerLastUpdatedPositions.get(player).m_123333_((Vec3i)playerBlockPos) > 16) {
                HashMap<BlockPos, Map> railsToAdd = new HashMap<BlockPos, Map>();
                this.rails.forEach((startPos, blockPosRailMap) -> blockPosRailMap.forEach((endPos, rail) -> {
                    if (new AABB(startPos, endPos).m_82400_(128.0).m_82390_(playerPos)) {
                        if (!railsToAdd.containsKey(startPos)) {
                            railsToAdd.put((BlockPos)startPos, new HashMap());
                        }
                        ((Map)railsToAdd.get(startPos)).put(endPos, rail);
                    }
                }));
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.writeInt(railsToAdd.size());
                railsToAdd.forEach((posStart, railMap) -> {
                    packet.m_130064_(posStart);
                    packet.writeInt(railMap.size());
                    railMap.forEach((posEnd, rail) -> {
                        packet.m_130064_(posEnd);
                        rail.writePacket(packet);
                    });
                });
                if (packet.readableBytes() <= 0x100000) {
                    Registry.sendToPlayer((ServerPlayer)player, PACKET_WRITE_RAILS, packet);
                }
                this.playerLastUpdatedPositions.put((Player)player, playerBlockPos);
            }
        });
        this.updateNearbyTrains.startTick();
        this.trainPositions.remove(0);
        this.trainPositions.add(new HashMap());
        this.schedulesForPlatform.clear();
        this.signalBlocks.resetOccupied();
        this.sidings.forEach(siding -> {
            siding.setSidingData(this.world, this.dataCache.sidingIdToDepot.get(siding.id), this.rails);
            siding.simulateTrain(this.dataCache, this.railwayDataDriveTrainModule, this.trainPositions, this.signalBlocks, this.updateNearbyTrains.newDataSetInPlayerRange, this.updateNearbyTrains.dataSetToSync, this.schedulesForPlatform, this.trainDelays);
        });
        this.depots.forEach(depot -> depot.deployTrain(this, this.world));
        this.updateNearbyLifts.startTick();
        this.lifts.forEach(lift -> lift.tickServer(this.world, this.updateNearbyLifts.newDataSetInPlayerRange, this.updateNearbyLifts.dataSetToSync));
        this.railwayDataCoolDownModule.tick();
        this.railwayDataDriveTrainModule.tick();
        this.railwayDataRailActionsModule.tick();
        this.railwayDataRouteFinderModule.tick();
        this.updateNearbyTrains.tick();
        this.updateNearbyLifts.tick();
        if (MTR.isGameTickInterval(60)) {
            players.forEach(player -> {
                if (!this.playersToSyncSchedules.contains(player)) {
                    this.playersToSyncSchedules.add((Player)player);
                }
            });
        }
        if (!this.playersToSyncSchedules.isEmpty()) {
            Player player2 = this.playersToSyncSchedules.remove(0);
            BlockPos playerBlockPos = player2.m_20183_();
            Vec3 playerPos = player2.m_20182_();
            Set<Long> platformIds = this.platforms.stream().filter(platform -> {
                if (platform.isCloseToSavedRail(playerBlockPos, 16, 16, 16)) {
                    return true;
                }
                Station station = this.dataCache.platformIdToStation.get(platform.id);
                return station != null && station.inArea(playerBlockPos.m_123341_(), playerBlockPos.m_123343_());
            }).map(platform -> platform.id).collect(Collectors.toSet());
            HashSet railsToAdd = new HashSet();
            this.rails.forEach((startPos, blockPosRailMap) -> blockPosRailMap.forEach((endPos, rail) -> {
                if (new AABB(startPos, endPos).m_82400_(128.0).m_82390_(playerPos)) {
                    railsToAdd.add(PathData.getRailProduct(startPos, endPos));
                }
            }));
            HashMap<Long, Boolean> signalBlockStatus = new HashMap<Long, Boolean>();
            HashMap<UUID, Boolean> occupiedRails = new HashMap<UUID, Boolean>();
            railsToAdd.forEach(rail -> {
                this.signalBlocks.getSignalBlockStatus((Map<Long, Boolean>)signalBlockStatus, (UUID)rail);
                occupiedRails.put((UUID)rail, this.trainPositions.get(1).containsKey(rail));
            });
            if (!(platformIds.isEmpty() && signalBlockStatus.isEmpty() && occupiedRails.isEmpty())) {
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.writeInt(platformIds.size());
                platformIds.forEach(platformId -> {
                    packet.writeLong(platformId.longValue());
                    List<ScheduleEntry> scheduleEntries = this.schedulesForPlatform.get(platformId);
                    if (scheduleEntries == null) {
                        packet.writeInt(0);
                    } else {
                        packet.writeInt(scheduleEntries.size());
                        scheduleEntries.forEach(scheduleEntry -> scheduleEntry.writePacket(packet));
                    }
                });
                packet.writeInt(signalBlockStatus.size());
                signalBlockStatus.forEach((id, occupied) -> {
                    packet.writeLong(id.longValue());
                    packet.writeBoolean(occupied.booleanValue());
                });
                packet.writeInt(occupiedRails.size());
                occupiedRails.forEach((rail, occupied) -> {
                    packet.m_130077_(rail);
                    packet.writeBoolean(occupied.booleanValue());
                });
                if (packet.readableBytes() <= 0x100000) {
                    Registry.sendToPlayer((ServerPlayer)player2, PACKET_UPDATE_SCHEDULE, packet);
                }
            }
        }
        if (this.prevPlatformCount != this.platforms.size() || this.prevSidingCount != this.sidings.size()) {
            this.dataCache.sync();
        }
        this.prevPlatformCount = this.platforms.size();
        this.prevSidingCount = this.sidings.size();
        this.railwayDataFileSaveModule.autoSaveTick();
    }

    public void onPlayerJoin(ServerPlayer serverPlayer) {
        PacketTrainDataGuiServer.sendAllInChunks(serverPlayer, this.stations, this.platforms, this.sidings, this.routes, this.depots, this.lifts, this.signalBlocks);
        this.railwayDataCoolDownModule.onPlayerJoin(serverPlayer);
    }

    public long addRail(Player player, TransportMode transportMode, BlockPos posStart, BlockPos posEnd, Rail rail, boolean validate) {
        long newId = validate ? new Random().nextLong() : 0L;
        RailwayData.addRail(this.rails, this.platforms, this.sidings, transportMode, posStart, posEnd, rail, newId);
        if (validate) {
            Rail backwardsRail = DataCache.tryGet(this.rails, posEnd, posStart);
            if (backwardsRail != null) {
                ArrayList<String> dataList = new ArrayList<String>();
                dataList.add(String.format("type:%s", rail.railType));
                dataList.add(String.format("one_way:%s", backwardsRail.railType == RailType.NONE));
                this.railwayDataLoggingModule.addEvent((ServerPlayer)player, Rail.class, new ArrayList<String>(), dataList, posStart, posEnd);
            }
            this.validateData();
        }
        return newId;
    }

    public long addSignal(Player player, DyeColor color, BlockPos posStart, BlockPos posEnd) {
        this.railwayDataLoggingModule.addEvent((ServerPlayer)player, SignalBlocks.SignalBlock.class, new ArrayList<String>(), Collections.singletonList(String.format("color:%s", color)), posStart, posEnd);
        return this.signalBlocks.add(0L, color, PathData.getRailProduct(posStart, posEnd));
    }

    public void removeNode(Player player, BlockPos pos, TransportMode transportMode) {
        this.railwayDataLoggingModule.addEvent((ServerPlayer)player, BlockNode.class, Collections.singletonList(String.format("type:%s", new Object[]{transportMode})), new ArrayList<String>(), pos);
        RailwayData.removeNode(this.world, this.rails, pos);
        this.validateData();
        FriendlyByteBuf packet = this.signalBlocks.getValidationPacket(this.rails);
        if (packet != null) {
            this.world.m_6907_().forEach(player2 -> Registry.sendToPlayer((ServerPlayer)player2, PACKET_REMOVE_SIGNALS, packet));
        }
    }

    public void removeRailConnection(Player player, BlockPos pos1, BlockPos pos2) {
        Rail rail1 = DataCache.tryGet(this.rails, pos1, pos2);
        Rail rail2 = DataCache.tryGet(this.rails, pos2, pos1);
        if (rail1 != null && rail2 != null) {
            ArrayList<String> dataList = new ArrayList<String>();
            dataList.add(String.format("type:%s", (rail1.railType == RailType.NONE ? rail2 : rail1).railType));
            dataList.add(String.format("one_way:%s", (rail1.railType == RailType.NONE ? rail1 : rail2).railType == RailType.NONE));
            this.railwayDataLoggingModule.addEvent((ServerPlayer)player, Rail.class, dataList, new ArrayList<String>(), pos1, pos2);
        }
        RailwayData.removeRailConnection(this.world, this.rails, pos1, pos2);
        this.validateData();
        FriendlyByteBuf packet = this.signalBlocks.getValidationPacket(this.rails);
        if (packet != null) {
            this.world.m_6907_().forEach(player2 -> Registry.sendToPlayer((ServerPlayer)player2, PACKET_REMOVE_SIGNALS, packet));
        }
    }

    public void removeLiftFloorTrack(BlockPos pos) {
        RailwayData.removeLiftFloorTrack(this.world, this.lifts, pos);
        this.dataCache.sync();
    }

    public boolean hasSavedRail(BlockPos pos) {
        return this.rails.containsKey(pos) && this.rails.get(pos).values().stream().anyMatch(rail -> rail.railType.hasSavedRail);
    }

    public boolean containsRail(BlockPos pos1, BlockPos pos2) {
        return RailwayData.containsRail(this.rails, pos1, pos2);
    }

    public long removeSignal(Player player, DyeColor color, BlockPos posStart, BlockPos posEnd) {
        this.railwayDataLoggingModule.addEvent((ServerPlayer)player, SignalBlocks.SignalBlock.class, Collections.singletonList(String.format("color:%s", color)), new ArrayList<String>(), posStart, posEnd);
        return this.signalBlocks.remove(0L, color, PathData.getRailProduct(posStart, posEnd));
    }

    public void disconnectPlayer(Player player) {
        this.railwayDataCoolDownModule.onPlayerDisconnect(player);
        this.playerLastUpdatedPositions.remove(player);
    }

    public void getSchedulesForStation(Map<Long, List<ScheduleEntry>> schedulesForStation, long stationId) {
        this.schedulesForPlatform.forEach((platformId, schedules) -> {
            Station station = this.dataCache.platformIdToStation.get(platformId);
            if (station != null && station.id == stationId) {
                schedulesForStation.put((Long)platformId, (List<ScheduleEntry>)schedules);
            }
        });
    }

    public List<ScheduleEntry> getSchedulesAtPlatform(long platformId) {
        return this.schedulesForPlatform.get(platformId);
    }

    public Map<Long, Map<BlockPos, TrainDelay>> getTrainDelays() {
        return this.trainDelays;
    }

    public void resetTrainDelays(Depot depot) {
        depot.routeIds.forEach(this.trainDelays::remove);
    }

    public boolean getUseTimeAndWindSync() {
        return this.useTimeAndWindSync;
    }

    public void setUseTimeAndWindSync(boolean useTimeAndWindSync) {
        this.useTimeAndWindSync = useTimeAndWindSync;
        this.runRealTimeSync();
    }

    private void validateData() {
        RailwayData.removeSavedRailS2C(this.world, this.platforms, this.rails, PACKET_DELETE_PLATFORM);
        RailwayData.removeSavedRailS2C(this.world, this.sidings, this.rails, PACKET_DELETE_SIDING);
        ArrayList railsToRemove = new ArrayList();
        this.rails.forEach((startPos, railMap) -> railMap.forEach((endPos, rail) -> {
            if (rail.railType.hasSavedRail && SavedRailBase.isInvalidSavedRail(this.rails, endPos, startPos)) {
                railsToRemove.add(startPos);
                railsToRemove.add(endPos);
            }
        }));
        for (int i = 0; i < railsToRemove.size() - 1; i += 2) {
            RailwayData.removeRailConnection(null, this.rails, (BlockPos)railsToRemove.get(i), (BlockPos)railsToRemove.get(i + 1));
        }
    }

    private void runRealTimeSync() {
        MinecraftServer server;
        if (this.useTimeAndWindSync && (server = this.world.m_7654_()) != null) {
            CommandSourceStack commandSourceStack = server.m_129893_();
            RailwayData.runCommand(server, commandSourceStack, "/gamerule doDaylightCycle true");
            RailwayData.runCommand(server, commandSourceStack, "/taw set-cycle-length " + this.world.m_46472_().m_135782_() + " 864000 864000");
            RailwayData.runCommand(server, commandSourceStack, "/taw reload");
            Calendar calendar = Calendar.getInstance();
            long ticks = Math.round((double)((calendar.get(11) + 24 - 6) * 1000) + (double)calendar.get(12) / 0.06 + (double)calendar.get(13) / 3.6) % 24000L;
            RailwayData.runCommand(server, commandSourceStack, "/time set " + ticks);
        }
    }

    public static Platform getPlatformByPos(Set<Platform> platforms, BlockPos pos) {
        try {
            return platforms.stream().filter(platform -> platform.containsPos(pos)).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addRail(Map<BlockPos, Map<BlockPos, Rail>> rails, Set<Platform> platforms, Set<Siding> sidings, TransportMode transportMode, BlockPos posStart, BlockPos posEnd, Rail rail, long savedRailId) {
        try {
            if (!rails.containsKey(posStart)) {
                rails.put(posStart, new HashMap());
            }
            rails.get(posStart).put(posEnd, rail);
            if (savedRailId != 0L) {
                if (rail.railType == RailType.PLATFORM && platforms.stream().noneMatch(platform -> platform.containsPos(posStart) || platform.containsPos(posEnd))) {
                    platforms.add(new Platform(savedRailId, transportMode, posStart, posEnd));
                } else if (rail.railType == RailType.SIDING && sidings.stream().noneMatch(siding -> siding.containsPos(posStart) || siding.containsPos(posEnd))) {
                    sidings.add(new Siding(savedRailId, transportMode, posStart, posEnd, (int)Math.floor(rail.getLength())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void removeNode(Level world, Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos) {
        try {
            rails.remove(pos);
            rails.forEach((startPos, railMap) -> {
                railMap.remove(pos);
                if (railMap.isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, startPos);
                }
            });
            if (world != null) {
                RailwayData.validateRails(world, rails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T extends Lift> void removeLiftFloorTrack(Level world, Set<T> lifts, BlockPos pos) {
        lifts.removeIf(lift -> lift.hasFloor(pos));
        if (world != null) {
            RailwayData.validateLifts(world, lifts);
        }
    }

    public static void removeRailConnection(Level world, Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos1, BlockPos pos2) {
        try {
            if (rails.containsKey(pos1)) {
                rails.get(pos1).remove(pos2);
                if (rails.get(pos1).isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, pos1);
                }
            }
            if (rails.containsKey(pos2)) {
                rails.get(pos2).remove(pos1);
                if (rails.get(pos2).isEmpty() && world != null) {
                    BlockNode.resetRailNode(world, pos2);
                }
            }
            if (world != null) {
                RailwayData.validateRails(world, rails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean containsRail(Map<BlockPos, Map<BlockPos, Rail>> rails, BlockPos pos1, BlockPos pos2) {
        return rails.containsKey(pos1) && rails.get(pos1).containsKey(pos2);
    }

    public static Station getStation(Set<Station> stations, DataCache dataCache, BlockPos pos) {
        try {
            if (dataCache.blockPosToStation.containsKey(pos)) {
                return dataCache.blockPosToStation.get(pos);
            }
            return stations.stream().filter(station -> station.inArea(pos.m_123341_(), pos.m_123343_())).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static long getClosePlatformId(Set<Platform> platforms, DataCache dataCache, BlockPos pos) {
        return RailwayData.getClosePlatformId(platforms, dataCache, pos, 5, 0, 4);
    }

    public static long getClosePlatformId(Set<Platform> platforms, DataCache dataCache, BlockPos pos, int radius, int lower, int upper) {
        try {
            long posLong = pos.m_121878_();
            if (dataCache.blockPosToPlatformId.containsKey(posLong)) {
                return dataCache.blockPosToPlatformId.get(posLong);
            }
            long platformId = 0L;
            int i = 1;
            while (i <= radius) {
                int searchRadius = i++;
                platformId = platforms.stream().filter(platform -> platform.isCloseToSavedRail(pos, searchRadius, lower, upper)).min(Comparator.comparingInt(platform -> platform.getMidPos().m_123333_((Vec3i)pos))).map(platform -> platform.id).orElse(0L);
                if (platformId != 0L) break;
            }
            dataCache.blockPosToPlatformId.put(posLong, platformId);
            return platformId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static boolean useRoutesAndStationsFromIndex(int stopIndex, List<Long> routeIds, DataCache dataCache, RouteAndStationsCallback routeAndStationsCallback) {
        if (stopIndex < 0) {
            return false;
        }
        int sum = 0;
        for (int i = 0; i < routeIds.size(); ++i) {
            Route nextRoute;
            Route thisRoute = dataCache.routeIdMap.get(routeIds.get(i));
            Route route = nextRoute = i < routeIds.size() - 1 && !dataCache.routeIdMap.get((Object)routeIds.get((int)(i + 1))).isHidden ? dataCache.routeIdMap.get(routeIds.get(i + 1)) : null;
            if (thisRoute == null) continue;
            int difference = stopIndex - sum;
            sum += thisRoute.platformIds.size();
            if (!thisRoute.platformIds.isEmpty() && nextRoute != null && !nextRoute.platformIds.isEmpty() && thisRoute.getLastPlatformId() == nextRoute.getFirstPlatformId()) {
                --sum;
            }
            if (stopIndex >= sum) continue;
            Station thisStation = dataCache.platformIdToStation.get(thisRoute.platformIds.get((int)difference).platformId);
            Station nextStation = difference < thisRoute.platformIds.size() - 1 ? dataCache.platformIdToStation.get(thisRoute.platformIds.get((int)(difference + 1)).platformId) : null;
            Station lastStation = thisRoute.platformIds.isEmpty() ? null : dataCache.platformIdToStation.get(thisRoute.getLastPlatformId());
            routeAndStationsCallback.routeAndStationsCallback(difference, thisRoute, nextRoute, thisStation, nextStation, lastStation);
            return true;
        }
        return false;
    }

    public static boolean isBetween(double value, double value1, double value2) {
        return RailwayData.isBetween(value, value1, value2, 0.0);
    }

    public static boolean isBetween(double value, double value1, double value2, double padding) {
        return value >= Math.min(value1, value2) - padding && value <= Math.max(value1, value2) + padding;
    }

    public static float round(double value, int decimalPlaces) {
        int factor = 1;
        for (int i = 0; i < decimalPlaces; ++i) {
            factor *= 10;
        }
        return (float)Math.round(value * (double)factor) / (float)factor;
    }

    public static void writeMessagePackDataset(MessagePacker messagePacker, Collection<? extends SerializedDataBase> dataSet, String key) throws IOException {
        messagePacker.packString(key);
        messagePacker.packArrayHeader(dataSet.size());
        for (SerializedDataBase serializedDataBase : dataSet) {
            messagePacker.packMapHeader(serializedDataBase.messagePackLength());
            serializedDataBase.toMessagePack(messagePacker);
        }
    }

    public static Map<String, Value> castMessagePackValueToSKMap(Value value) {
        Map<Object, Object> oldMap = value == null ? new HashMap() : value.asMapValue().map();
        HashMap<String, Value> resultMap = new HashMap<String, Value>(oldMap.size());
        oldMap.forEach((key, newValue) -> resultMap.put(key.asStringValue().asString(), (Value)newValue));
        return resultMap;
    }

    public static boolean hasNoPermission(ServerPlayer serverPlayer) {
        return !RailwayData.hasPermission(serverPlayer.f_8941_.m_9290_());
    }

    public static boolean hasPermission(GameType gameType) {
        return gameType == GameType.CREATIVE || gameType == GameType.SURVIVAL;
    }

    public static boolean chunkLoaded(Level world, BlockPos pos) {
        return world.m_7726_().m_7131_(pos.m_123341_() / 16, pos.m_123343_() / 16) != null && world.m_7232_(pos.m_123341_() / 16, pos.m_123343_() / 16);
    }

    public static String prettyPrint(JsonElement jsonElement) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(jsonElement);
    }

    public static RailwayData getInstance(Level world) {
        return RailwayData.getInstance(world, () -> new RailwayData(world), NAME);
    }

    public static void benchmark(Runnable runnable, float threshold) {
        long nanos = System.nanoTime();
        runnable.run();
        float duration = (float)(System.nanoTime() - nanos) / 1.0E9f;
        if (duration >= threshold) {
            System.out.println(duration);
        }
    }

    private static void validateRails(Level world, Map<BlockPos, Map<BlockPos, Rail>> rails) {
        HashSet railsToRemove = new HashSet();
        HashSet railsNodesToRemove = new HashSet();
        rails.forEach((startPos, railMap) -> {
            boolean chunkLoaded = RailwayData.chunkLoaded(world, startPos);
            if (chunkLoaded && !(world.m_8055_(startPos).m_60734_() instanceof BlockNode)) {
                railsNodesToRemove.add(startPos);
            }
            if (railMap.isEmpty()) {
                railsToRemove.add(startPos);
            }
        });
        railsToRemove.forEach(rails::remove);
        railsNodesToRemove.forEach(pos -> RailwayData.removeNode(null, rails, pos));
    }

    private static <T extends Lift> void validateLifts(Level world, Set<T> lifts) {
        lifts.removeIf(lift -> lift.isInvalidLift(world));
    }

    private static void removeSavedRailS2C(Level world, Set<? extends SavedRailBase> savedRailBases, Map<BlockPos, Map<BlockPos, Rail>> rails, ResourceLocation packetId) {
        savedRailBases.removeIf(savedRailBase -> {
            boolean delete = savedRailBase.isInvalidSavedRail(rails);
            if (delete) {
                FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
                packet.writeLong(savedRailBase.id);
                world.m_6907_().forEach(player -> Registry.sendToPlayer((ServerPlayer)player, packetId, packet));
            }
            return delete;
        });
    }

    private static void runCommand(MinecraftServer server, CommandSourceStack commandSourceStack, String command) {
        System.out.println("Running command " + command);
        Utilities.sendCommand(server, commandSourceStack, command);
    }

    private static Map<String, Value> readMessagePackSKMap(MessageUnpacker messageUnpacker) throws IOException {
        int size = messageUnpacker.unpackMapHeader();
        HashMap<String, Value> result = new HashMap<String, Value>(size);
        for (int i = 0; i < size; ++i) {
            result.put(messageUnpacker.unpackString(), messageUnpacker.unpackValue());
        }
        return result;
    }

    @Deprecated
    private static class RailEntry
    extends SerializedDataBase {
        public final BlockPos pos;
        public final Map<BlockPos, Rail> connections;
        private static final String KEY_NODE_POS = "node_pos";
        private static final String KEY_RAIL_CONNECTIONS = "rail_connections";

        public RailEntry(BlockPos pos, Map<BlockPos, Rail> connections) {
            this.pos = pos;
            this.connections = connections;
        }

        public RailEntry(CompoundTag compoundTag) {
            this.pos = BlockPos.m_122022_((long)compoundTag.m_128454_(KEY_NODE_POS));
            this.connections = new HashMap<BlockPos, Rail>();
            CompoundTag tagConnections = compoundTag.m_128469_(KEY_RAIL_CONNECTIONS);
            for (String keyConnection : tagConnections.m_128431_()) {
                this.connections.put(BlockPos.m_122022_((long)tagConnections.m_128469_(keyConnection).m_128454_(KEY_NODE_POS)), new Rail(tagConnections.m_128469_(keyConnection)));
            }
        }

        public RailEntry(Map<String, Value> map) {
            MessagePackHelper messagePackHelper = new MessagePackHelper(map);
            this.pos = BlockPos.m_122022_((long)messagePackHelper.getLong(KEY_NODE_POS));
            this.connections = new HashMap<BlockPos, Rail>();
            messagePackHelper.iterateArrayValue(KEY_RAIL_CONNECTIONS, value -> {
                Map<String, Value> mapSK = RailwayData.castMessagePackValueToSKMap(value);
                this.connections.put(BlockPos.m_122022_((long)new MessagePackHelper(mapSK).getLong(KEY_NODE_POS)), new Rail(mapSK));
            });
        }

        @Override
        public void toMessagePack(MessagePacker messagePacker) throws IOException {
            messagePacker.packString(KEY_NODE_POS).packLong(this.pos.m_121878_());
            messagePacker.packString(KEY_RAIL_CONNECTIONS).packArrayHeader(this.connections.size());
            for (Map.Entry<BlockPos, Rail> entry : this.connections.entrySet()) {
                BlockPos endNodePos = entry.getKey();
                messagePacker.packMapHeader(entry.getValue().messagePackLength() + 1);
                messagePacker.packString(KEY_NODE_POS).packLong(endNodePos.m_121878_());
                entry.getValue().toMessagePack(messagePacker);
            }
        }

        @Override
        public int messagePackLength() {
            return 2;
        }

        @Override
        public void writePacket(FriendlyByteBuf packet) {
        }
    }

    @FunctionalInterface
    public static interface RouteAndStationsCallback {
        public void routeAndStationsCallback(int var1, Route var2, Route var3, Station var4, Station var5, Station var6);
    }
}

