/*
 * Decompiled with CFR 0.152.
 */
package mtr.data;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mtr.block.BlockLiftButtons;
import mtr.data.Lift;
import mtr.data.RailwayData;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LiftInstructions {
    private boolean isDirty = false;
    private final List<LiftInstruction> instructions = new ArrayList<LiftInstruction>();

    public LiftInstructions() {
    }

    public LiftInstructions(FriendlyByteBuf packet) {
        int instructionsCount = packet.readInt();
        for (int i = 0; i < instructionsCount; ++i) {
            this.instructions.add(new LiftInstruction(packet));
        }
    }

    public void writePacket(FriendlyByteBuf packet) {
        packet.writeInt(this.instructions.size());
        this.instructions.forEach(liftInstruction -> liftInstruction.writePacket(packet));
    }

    public void copyFrom(LiftInstructions liftInstructions) {
        this.isDirty = false;
        this.instructions.clear();
        this.instructions.addAll(liftInstructions.instructions);
    }

    public void getTargetFloor(Consumer<Integer> callback) {
        if (this.hasInstructions()) {
            callback.accept(this.instructions.get((int)0).floor);
        }
    }

    public void arrived() {
        if (this.hasInstructions()) {
            this.instructions.remove(0);
            this.isDirty = true;
        }
    }

    public boolean hasInstructions() {
        return !this.instructions.isEmpty();
    }

    public void addInstruction(int currentFloor, boolean currentMovingUp, int floor) {
        this.addInstruction(currentFloor, currentMovingUp, floor, false, true, true);
    }

    public boolean isDirty() {
        boolean isDirtyTemp = this.isDirty;
        this.isDirty = false;
        return isDirtyTemp;
    }

    private int addInstruction(int currentFloor, boolean currentMovingUp, int newFloor, boolean newMovingUp, boolean noDirection, boolean shouldAdd) {
        int lastInstruction;
        if (currentFloor == newFloor) {
            return 0;
        }
        ArrayList<LiftInstruction> tempInstructions = new ArrayList<LiftInstruction>(this.instructions);
        tempInstructions.add(0, new LiftInstruction(currentFloor, currentMovingUp));
        int distance = 0;
        for (int i = 0; i < tempInstructions.size() - 1; ++i) {
            boolean newMovingUpTemp;
            LiftInstruction previousInstruction = (LiftInstruction)tempInstructions.get(i);
            LiftInstruction nextInstruction = (LiftInstruction)tempInstructions.get(i + 1);
            boolean bl = newMovingUpTemp = noDirection ? nextInstruction.movingUp : newMovingUp;
            if (this.instructions.contains(new LiftInstruction(newFloor, newMovingUpTemp))) {
                return -1;
            }
            if (nextInstruction.canInsert(previousInstruction, newFloor, newMovingUpTemp)) {
                if (shouldAdd) {
                    this.instructions.add(i, new LiftInstruction(newFloor, newMovingUpTemp));
                    this.isDirty = true;
                }
                return distance + Math.abs(newFloor - previousInstruction.floor);
            }
            distance += Math.abs(nextInstruction.floor - previousInstruction.floor);
        }
        int n = lastInstruction = this.hasInstructions() ? this.instructions.get((int)(this.instructions.size() - 1)).floor : currentFloor;
        if (shouldAdd) {
            this.instructions.add(new LiftInstruction(newFloor, noDirection ? newFloor > lastInstruction : newMovingUp));
            this.isDirty = true;
        }
        return distance + Math.abs(newFloor - lastInstruction);
    }

    public boolean containsInstruction(int floor, boolean movingUp) {
        return this.instructions.contains(new LiftInstruction(floor, movingUp));
    }

    public boolean containsInstruction(int floor) {
        return this.containsInstruction(floor, true) || this.containsInstruction(floor, false);
    }

    public static void addInstruction(Level world, BlockPos pos, boolean topHalfClicked) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof BlockLiftButtons.TileEntityLiftButtons)) {
            return;
        }
        RailwayData railwayData = RailwayData.getInstance(world);
        if (railwayData == null) {
            return;
        }
        int[] currentWeight = new int[]{Integer.MAX_VALUE};
        LiftInstructions[] liftInstructionsToUse = new LiftInstructions[]{null};
        int[] liftFloorToUse = new int[]{0};
        boolean[] liftMovingUpToUse = new boolean[]{false};
        int[] newLiftFloorToUse = new int[]{0};
        boolean[] hasButtonOverall = new boolean[]{false, false};
        ((BlockLiftButtons.TileEntityLiftButtons)blockEntity).forEachTrackPosition(world, (trackPosition, trackFloorTileEntity) -> railwayData.lifts.stream().filter(lift -> lift.hasFloor((BlockPos)trackPosition)).findFirst().ifPresent(lift -> {
            int liftFloor = (int)Math.round(lift.getPositionY());
            int newLiftFloor = trackPosition.m_123342_();
            boolean[] hasButton = new boolean[]{false, false};
            lift.hasUpDownButtonForFloor(newLiftFloor, hasButton);
            boolean newMovingUp = topHalfClicked ? hasButton[0] : !hasButton[1];
            boolean liftMovingUp = lift.getLiftDirection() == Lift.LiftDirection.UP;
            int weight = lift.liftInstructions.addInstruction(liftFloor, liftMovingUp, newLiftFloor, newMovingUp, false, false);
            if (weight >= 0 && (topHalfClicked == newMovingUp && weight < currentWeight[0] || newMovingUp && !hasButtonOverall[0] || !newMovingUp && !hasButtonOverall[1])) {
                currentWeight[0] = weight;
                liftInstructionsToUse[0] = lift.liftInstructions;
                liftFloorToUse[0] = liftFloor;
                liftMovingUpToUse[0] = liftMovingUp;
                newLiftFloorToUse[0] = newLiftFloor;
            }
            if (hasButton[0]) {
                hasButtonOverall[0] = true;
            }
            if (hasButton[1]) {
                hasButtonOverall[1] = true;
            }
        }));
        if (liftInstructionsToUse[0] != null) {
            boolean newMovingUp = topHalfClicked ? hasButtonOverall[0] : !hasButtonOverall[1];
            liftInstructionsToUse[0].addInstruction(liftFloorToUse[0], liftMovingUpToUse[0], newLiftFloorToUse[0], newMovingUp, false, true);
        }
    }

    private static class LiftInstruction {
        private final int floor;
        private final boolean movingUp;

        private LiftInstruction(int floor, boolean movingUp) {
            this.floor = floor;
            this.movingUp = movingUp;
        }

        private LiftInstruction(FriendlyByteBuf packet) {
            this.floor = packet.readInt();
            this.movingUp = packet.readBoolean();
        }

        private boolean canInsert(LiftInstruction previousInstruction, int newFloor, boolean newMovingUp) {
            if (RailwayData.isBetween(newFloor, previousInstruction.floor, this.floor) && newMovingUp == this.movingUp) {
                return true;
            }
            return previousInstruction.movingUp != this.movingUp && previousInstruction.movingUp == newFloor > previousInstruction.floor;
        }

        private void writePacket(FriendlyByteBuf packet) {
            packet.writeInt(this.floor);
            packet.writeBoolean(this.movingUp);
        }

        public boolean equals(Object object) {
            return object instanceof LiftInstruction && this.floor == ((LiftInstruction)object).floor && this.movingUp == ((LiftInstruction)object).movingUp;
        }
    }
}

