/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mtr.MTRClient;
import mtr.client.ClientCache;
import mtr.client.IDrawing;
import mtr.data.IGui;
import mtr.render.MoreRenderLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;

public class ScrollingText
implements IGui {
    private float ticksOffset;
    private ClientCache.DynamicResource dynamicResource;
    private VertexConsumer vertexConsumer;
    private final float availableWidth;
    private final float availableHeight;
    private final int scrollSpeed;
    private final boolean isFullPixel;

    public ScrollingText(float availableWidth, float availableHeight, int scrollSpeed, boolean isFullPixel) {
        this.availableWidth = availableWidth;
        this.availableHeight = availableHeight;
        this.scrollSpeed = scrollSpeed;
        this.isFullPixel = isFullPixel;
    }

    public void changeImage(ClientCache.DynamicResource dynamicResource) {
        if (this.dynamicResource != dynamicResource) {
            this.dynamicResource = dynamicResource;
            this.ticksOffset = MTRClient.getGameTick();
        }
    }

    public void setVertexConsumer(MultiBufferSource vertexConsumers) {
        this.vertexConsumer = this.dynamicResource == null ? null : vertexConsumers.m_6299_(MoreRenderLayers.getLight(this.dynamicResource.resourceLocation, true));
    }

    public void scrollText(PoseStack matrices) {
        if (this.vertexConsumer != null) {
            int pixelScale = this.isFullPixel ? 1 : 4;
            float scale = this.availableHeight / (float)this.dynamicResource.height;
            int widthSteps = (int)Math.floor(this.availableWidth / scale / (float)pixelScale);
            int imageSteps = this.dynamicResource.width / pixelScale;
            int totalSteps = widthSteps + imageSteps;
            int step = Math.round((MTRClient.getGameTick() - this.ticksOffset) * (float)this.scrollSpeed) % totalSteps;
            float width = Math.min(Math.min(this.availableWidth, (float)this.dynamicResource.width * scale), Math.min((float)(step * pixelScale) * scale, (float)((totalSteps - step) * pixelScale) * scale));
            IDrawing.drawTexture(matrices, this.vertexConsumer, (float)Math.max(widthSteps - step, 0) * scale * (float)pixelScale, 0.0f, width, this.availableHeight, Math.max((float)(step - widthSteps) / (float)imageSteps, 0.0f), 0.0f, Math.min((float)step / (float)imageSteps, 1.0f), 1.0f, Direction.UP, -1, 0xF000F0);
        }
    }
}

