/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public interface ICustomResources {
    public static final String CUSTOM_RESOURCES_ID = "mtr_custom_resources";
    public static final String CUSTOM_TRAIN_ID_PREFIX = "mtr_custom_train_";
    public static final String CUSTOM_SIGN_ID_PREFIX = "mtr_custom_sign_";
    public static final String CUSTOM_TRAINS_KEY = "custom_trains";
    public static final String CUSTOM_SIGNS_KEY = "custom_signs";
    public static final String CUSTOM_TRAINS_BASE_TRAIN_TYPE = "base_train_type";
    public static final String CUSTOM_TRAINS_NAME = "name";
    public static final String CUSTOM_TRAINS_COLOR = "color";
    public static final String CUSTOM_TRAINS_MODEL = "model";
    public static final String CUSTOM_TRAINS_MODEL_PROPERTIES = "model_properties";
    public static final String CUSTOM_TRAINS_DESCRIPTION = "description";
    public static final String CUSTOM_TRAINS_WIKIPEDIA_ARTICLE = "wikipedia_article";
    public static final String CUSTOM_TRAINS_TEXTURE_ID = "texture_id";
    public static final String CUSTOM_TRAINS_GANGWAY_CONNECTION_ID = "gangway_connection_id";
    public static final String CUSTOM_TRAINS_TRAIN_BARRIER_ID = "train_barrier_id";
    public static final String CUSTOM_TRAINS_DOOR_ANIMATION_TYPE = "door_animation_type";
    public static final String CUSTOM_TRAINS_RENDER_DOOR_OVERLAY = "render_door_overlay";
    public static final String CUSTOM_TRAINS_RIDER_OFFSET = "rider_offset";
    public static final String CUSTOM_TRAINS_BVE_SOUND_BASE_ID = "bve_sound_base_id";
    public static final String CUSTOM_TRAINS_SPEED_SOUND_COUNT = "speed_sound_count";
    public static final String CUSTOM_TRAINS_SPEED_SOUND_BASE_ID = "speed_sound_base_id";
    public static final String CUSTOM_TRAINS_DOOR_SOUND_BASE_ID = "door_sound_base_id";
    public static final String CUSTOM_TRAINS_DOOR_CLOSE_SOUND_TIME = "door_close_sound_time";
    public static final String CUSTOM_TRAINS_ACCEL_SOUND_AT_COAST = "accel_sound_at_coast";
    public static final String CUSTOM_TRAINS_CONST_PLAYBACK_SPEED = "const_playback_speed";
    public static final String CUSTOM_SIGNS_TEXTURE_ID = "texture_id";
    public static final String CUSTOM_SIGNS_FLIP_TEXTURE = "flip_texture";
    public static final String CUSTOM_SIGNS_CUSTOM_TEXT = "custom_text";
    public static final String CUSTOM_SIGNS_FLIP_CUSTOM_TEXT = "flip_custom_text";
    public static final String CUSTOM_SIGNS_SMALL = "small";
    public static final String CUSTOM_SIGNS_BACKGROUND_COLOR = "background_color";

    public static void createCustomTrainSchema(JsonObject jsonObject, String id, String name, String description, String wikipediaArticle, String color, String gangwayConnectionId, String trainBarrierId, String doorAnimationType, boolean renderDoorOverlay, float riderOffset) {
        JsonObject customTrainsObject = new JsonObject();
        jsonObject.add(CUSTOM_TRAINS_KEY, (JsonElement)customTrainsObject);
        JsonObject customTrainObject = new JsonObject();
        customTrainsObject.add(id, (JsonElement)customTrainObject);
        customTrainObject.addProperty(CUSTOM_TRAINS_NAME, name);
        customTrainObject.addProperty(CUSTOM_TRAINS_DESCRIPTION, description);
        customTrainObject.addProperty(CUSTOM_TRAINS_WIKIPEDIA_ARTICLE, wikipediaArticle);
        customTrainObject.addProperty(CUSTOM_TRAINS_COLOR, color);
        customTrainObject.addProperty(CUSTOM_TRAINS_GANGWAY_CONNECTION_ID, gangwayConnectionId);
        customTrainObject.addProperty(CUSTOM_TRAINS_TRAIN_BARRIER_ID, trainBarrierId);
        customTrainObject.addProperty(CUSTOM_TRAINS_DOOR_ANIMATION_TYPE, doorAnimationType);
        customTrainObject.addProperty(CUSTOM_TRAINS_RENDER_DOOR_OVERLAY, Boolean.valueOf(renderDoorOverlay));
        customTrainObject.addProperty(CUSTOM_TRAINS_RIDER_OFFSET, (Number)Float.valueOf(riderOffset));
        String resource = String.format("mtr:%s/%s", id, id);
        customTrainObject.addProperty("texture_id", resource);
        customTrainObject.addProperty(CUSTOM_TRAINS_MODEL, resource + ".bbmodel");
        customTrainObject.addProperty(CUSTOM_TRAINS_MODEL_PROPERTIES, resource + ".json");
    }
}

