/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import mtr.KeyMappings;
import mtr.MTRClient;
import mtr.data.RailwayData;
import mtr.mappings.Text;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;

public class DebugKeys {
    private int index;
    private boolean isPressing;
    private float lastPressedTicks;
    private final int categories;
    private final float scale;
    private final int[] field1;
    private final int[] field2;
    private final int[] field3;

    public DebugKeys(int categories, float scale) {
        this.categories = categories;
        this.scale = scale;
        this.field1 = new int[categories];
        this.field2 = new int[categories];
        this.field3 = new int[categories];
    }

    public void tick() {
        boolean fastPress;
        boolean shouldIncrement;
        boolean tempPressing1Negative = KeyMappings.DEBUG_1_NEGATIVE.m_90857_();
        boolean tempPressing2Negative = KeyMappings.DEBUG_2_NEGATIVE.m_90857_();
        boolean tempPressing3Negative = KeyMappings.DEBUG_3_NEGATIVE.m_90857_();
        boolean tempPressing1Positive = KeyMappings.DEBUG_1_POSITIVE.m_90857_();
        boolean tempPressing2Positive = KeyMappings.DEBUG_2_POSITIVE.m_90857_();
        boolean tempPressing3Positive = KeyMappings.DEBUG_3_POSITIVE.m_90857_();
        boolean tempPressingCategoryNegative = KeyMappings.DEBUG_ROTATE_CATEGORY_NEGATIVE.m_90857_();
        boolean tempPressingCategoryPositive = KeyMappings.DEBUG_ROTATE_CATEGORY_POSITIVE.m_90857_();
        boolean tempIsPressing = tempPressing1Negative || tempPressing2Negative || tempPressing3Negative || tempPressing1Positive || tempPressing2Positive || tempPressing3Positive || tempPressingCategoryNegative || tempPressingCategoryPositive;
        float gameTick = MTRClient.getGameTick();
        if (!this.isPressing && tempIsPressing) {
            this.lastPressedTicks = gameTick;
            shouldIncrement = true;
            fastPress = false;
        } else {
            shouldIncrement = tempIsPressing && gameTick - this.lastPressedTicks > 10.0f;
            fastPress = true;
        }
        if (shouldIncrement) {
            int n = this.index = (this.categories + this.index + (tempPressingCategoryNegative ? -1 : (tempPressingCategoryPositive ? 1 : 0))) % this.categories;
            this.field1[n] = this.field1[n] + (fastPress ? 10 : 1) * (tempPressing1Negative ? -1 : (tempPressing1Positive ? 1 : 0));
            int n2 = this.index;
            this.field2[n2] = this.field2[n2] + (fastPress ? 10 : 1) * (tempPressing2Negative ? -1 : (tempPressing2Positive ? 1 : 0));
            int n3 = this.index;
            this.field3[n3] = this.field3[n3] + (fastPress ? 10 : 1) * (tempPressing3Negative ? -1 : (tempPressing3Positive ? 1 : 0));
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                if (tempPressingCategoryNegative || tempPressingCategoryPositive) {
                    player.m_5661_((Component)Text.literal(String.format("Category: %s", this.index)), true);
                }
                if (tempPressing1Negative || tempPressing1Positive) {
                    player.m_5661_((Component)Text.literal(String.format("Category: %s - Value: %s", this.index, Float.valueOf(this.getField1(this.index)))), true);
                }
                if (tempPressing2Negative || tempPressing2Positive) {
                    player.m_5661_((Component)Text.literal(String.format("Category: %s - Value: %s", this.index, Float.valueOf(this.getField2(this.index)))), true);
                }
                if (tempPressing3Negative || tempPressing3Positive) {
                    player.m_5661_((Component)Text.literal(String.format("Category: %s - Value: %s", this.index, Float.valueOf(this.getField3(this.index)))), true);
                }
            }
        }
        this.isPressing = tempIsPressing;
    }

    public float getField1(int category) {
        return RailwayData.round((float)this.field1[Math.abs(category) % this.categories] * this.scale, 5);
    }

    public float getField2(int category) {
        return RailwayData.round((float)this.field2[Math.abs(category) % this.categories] * this.scale, 5);
    }

    public float getField3(int category) {
        return RailwayData.round((float)this.field3[Math.abs(category) % this.categories] * this.scale, 5);
    }
}

