/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mtr.Patreon;
import mtr.data.RailwayData;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public class Config {
    private static boolean useMTRFont;
    private static boolean showAnnouncementMessages;
    private static boolean useTTSAnnouncements;
    private static boolean hideSpecialRailColors;
    private static boolean hideTranslucentParts;
    private static boolean shiftToToggleSitting;
    private static int languageOptions;
    private static boolean useDynamicFPS;
    private static int trackTextureOffset;
    private static int dynamicTextureResolution;
    private static int trainRenderDistanceRatio;
    public static final List<Patreon> PATREON_LIST;
    public static final int TRACK_OFFSET_COUNT = 32;
    public static final int DYNAMIC_RESOLUTION_COUNT = 8;
    public static final int TRAIN_RENDER_DISTANCE_RATIO_COUNT = 16;
    private static final Path CONFIG_FILE_PATH;
    private static final String USE_MTR_FONT_KEY = "use_mtr_font";
    private static final String SHOW_ANNOUNCEMENT_MESSAGES = "show_announcement_messages";
    private static final String HIDE_SPECIAL_RAIL_COLORS = "hide_special_rail_colors";
    private static final String HIDE_TRANSLUCENT_PARTS = "hide_translucent_parts";
    private static final String SHIFT_TO_TOGGLE_SITTING = "shift_to_toggle_sitting";
    private static final String LANGUAGE_OPTIONS = "language_options";
    private static final String USE_TTS_ANNOUNCEMENTS = "use_tts_announcements";
    private static final String TRACK_TEXTURE_OFFSET = "track_texture_offset";
    private static final String DYNAMIC_TEXTURE_RESOLUTION = "dynamic texture resolution";
    private static final String TRAIN_RENDER_DISTANCE_RATIO = "train_render_distance_ratio";

    public static boolean useMTRFont() {
        return useMTRFont;
    }

    public static boolean showAnnouncementMessages() {
        return showAnnouncementMessages;
    }

    public static boolean useTTSAnnouncements() {
        return useTTSAnnouncements;
    }

    public static boolean hideTranslucentParts() {
        return hideTranslucentParts;
    }

    public static boolean shiftToToggleSitting() {
        return shiftToToggleSitting;
    }

    public static int languageOptions() {
        return languageOptions;
    }

    public static boolean hideSpecialRailColors() {
        return hideSpecialRailColors;
    }

    public static boolean useDynamicFPS() {
        return useDynamicFPS;
    }

    public static int trackTextureOffset() {
        return trackTextureOffset;
    }

    public static int dynamicTextureResolution() {
        return dynamicTextureResolution;
    }

    public static int trainRenderDistanceRatio() {
        return trainRenderDistanceRatio;
    }

    public static boolean setUseMTRFont(boolean value) {
        useMTRFont = value;
        Config.writeToFile();
        return useMTRFont;
    }

    public static boolean setShowAnnouncementMessages(boolean value) {
        showAnnouncementMessages = value;
        Config.writeToFile();
        return showAnnouncementMessages;
    }

    public static boolean setUseTTSAnnouncements(boolean value) {
        useTTSAnnouncements = value;
        Config.writeToFile();
        return useTTSAnnouncements;
    }

    public static boolean setHideSpecialRailColors(boolean value) {
        hideSpecialRailColors = value;
        Config.writeToFile();
        return hideSpecialRailColors;
    }

    public static boolean setHideTranslucentParts(boolean value) {
        hideTranslucentParts = value;
        Config.writeToFile();
        return hideTranslucentParts;
    }

    public static boolean setShiftToToggleSitting(boolean value) {
        shiftToToggleSitting = value;
        Config.writeToFile();
        return shiftToToggleSitting;
    }

    public static int setLanguageOptions(int value) {
        languageOptions = value % 3;
        Config.writeToFile();
        return languageOptions;
    }

    public static boolean setUseDynamicFPS(boolean value) {
        useDynamicFPS = value;
        Config.writeToFile();
        return useDynamicFPS;
    }

    public static void setTrackTextureOffset(int value) {
        trackTextureOffset = Mth.m_14045_((int)value, (int)0, (int)31);
        Config.writeToFile();
    }

    public static void setDynamicTextureResolution(int value) {
        dynamicTextureResolution = Mth.m_14045_((int)value, (int)0, (int)7);
        Config.writeToFile();
    }

    public static void setTrainRenderDistanceRatio(int value) {
        trainRenderDistanceRatio = Mth.m_14045_((int)value, (int)0, (int)15);
        Config.writeToFile();
    }

    public static void refreshProperties() {
        System.out.println("Refreshed MTR mod config");
        try {
            JsonObject jsonConfig = new JsonParser().parse(String.join((CharSequence)"", Files.readAllLines(CONFIG_FILE_PATH))).getAsJsonObject();
            try {
                useMTRFont = jsonConfig.get(USE_MTR_FONT_KEY).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                showAnnouncementMessages = jsonConfig.get(SHOW_ANNOUNCEMENT_MESSAGES).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                useTTSAnnouncements = jsonConfig.get(USE_TTS_ANNOUNCEMENTS).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hideSpecialRailColors = jsonConfig.get(HIDE_SPECIAL_RAIL_COLORS).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                hideTranslucentParts = jsonConfig.get(HIDE_TRANSLUCENT_PARTS).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                shiftToToggleSitting = jsonConfig.get(SHIFT_TO_TOGGLE_SITTING).getAsBoolean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                languageOptions = jsonConfig.get(LANGUAGE_OPTIONS).getAsInt() % 3;
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                trackTextureOffset = Mth.m_14045_((int)jsonConfig.get(TRACK_TEXTURE_OFFSET).getAsInt(), (int)0, (int)31);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                dynamicTextureResolution = Mth.m_14045_((int)jsonConfig.get(DYNAMIC_TEXTURE_RESOLUTION).getAsInt(), (int)0, (int)7);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                trainRenderDistanceRatio = Mth.m_14045_((int)jsonConfig.get(TRAIN_RENDER_DISTANCE_RATIO).getAsInt(), (int)0, (int)15);
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            Config.writeToFile();
            e.printStackTrace();
        }
    }

    private static void writeToFile() {
        System.out.println("Wrote MTR mod config to file");
        JsonObject jsonConfig = new JsonObject();
        jsonConfig.addProperty(USE_MTR_FONT_KEY, Boolean.valueOf(useMTRFont));
        jsonConfig.addProperty(SHOW_ANNOUNCEMENT_MESSAGES, Boolean.valueOf(showAnnouncementMessages));
        jsonConfig.addProperty(USE_TTS_ANNOUNCEMENTS, Boolean.valueOf(useTTSAnnouncements));
        jsonConfig.addProperty(HIDE_SPECIAL_RAIL_COLORS, Boolean.valueOf(hideSpecialRailColors));
        jsonConfig.addProperty(HIDE_TRANSLUCENT_PARTS, Boolean.valueOf(hideTranslucentParts));
        jsonConfig.addProperty(SHIFT_TO_TOGGLE_SITTING, Boolean.valueOf(shiftToToggleSitting));
        jsonConfig.addProperty(LANGUAGE_OPTIONS, (Number)languageOptions);
        jsonConfig.addProperty(TRACK_TEXTURE_OFFSET, (Number)trackTextureOffset);
        jsonConfig.addProperty(DYNAMIC_TEXTURE_RESOLUTION, (Number)dynamicTextureResolution);
        jsonConfig.addProperty(TRAIN_RENDER_DISTANCE_RATIO, (Number)trainRenderDistanceRatio);
        try {
            Files.write(CONFIG_FILE_PATH, Collections.singleton(RailwayData.prettyPrint((JsonElement)jsonConfig)), new OpenOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        useDynamicFPS = true;
        dynamicTextureResolution = 2;
        trainRenderDistanceRatio = 7;
        PATREON_LIST = new ArrayList<Patreon>();
        CONFIG_FILE_PATH = Minecraft.m_91087_().f_91069_.toPath().resolve("config").resolve("mtr.json");
    }
}

