/*
 * Decompiled with CFR 0.152.
 */
package mtr.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import mtr.KeyMappings;
import mtr.MTRClient;
import mtr.client.ClientCache;
import mtr.data.DataConverter;
import mtr.data.Depot;
import mtr.data.LiftClient;
import mtr.data.NameColorDataBase;
import mtr.data.Platform;
import mtr.data.Rail;
import mtr.data.RailwayData;
import mtr.data.Route;
import mtr.data.ScheduleEntry;
import mtr.data.SerializedDataBase;
import mtr.data.Siding;
import mtr.data.SignalBlocks;
import mtr.data.Station;
import mtr.data.Train;
import mtr.data.TrainClient;
import mtr.data.TransportMode;
import mtr.mappings.Text;
import mtr.packet.PacketTrainDataGuiClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;

public final class ClientData {
    public static String DASHBOARD_SEARCH = "";
    public static String ROUTES_PLATFORMS_SEARCH = "";
    public static String ROUTES_PLATFORMS_SELECTED_SEARCH = "";
    public static String TRAINS_SEARCH = "";
    public static String EXIT_PARENTS_SEARCH = "";
    public static String EXIT_DESTINATIONS_SEARCH = "";
    private static boolean pressingAccelerate = false;
    private static boolean pressingBrake = false;
    private static boolean pressingDoors = false;
    private static float shiftHoldingTicks = 0.0f;
    public static final Set<Station> STATIONS = new HashSet<Station>();
    public static final Set<Platform> PLATFORMS = new HashSet<Platform>();
    public static final Set<Siding> SIDINGS = new HashSet<Siding>();
    public static final Set<Route> ROUTES = new HashSet<Route>();
    public static final Set<Depot> DEPOTS = new HashSet<Depot>();
    public static final Set<LiftClient> LIFTS = new HashSet<LiftClient>();
    public static final SignalBlocks SIGNAL_BLOCKS = new SignalBlocks();
    public static final Map<UUID, Boolean> OCCUPIED_RAILS = new HashMap<UUID, Boolean>();
    public static final Map<BlockPos, Map<BlockPos, Rail>> RAILS = new HashMap<BlockPos, Map<BlockPos, Rail>>();
    public static final Set<TrainClient> TRAINS = new HashSet<TrainClient>();
    public static final List<DataConverter> RAIL_ACTIONS = new ArrayList<DataConverter>();
    public static final Map<Long, Set<ScheduleEntry>> SCHEDULES_FOR_PLATFORM = new HashMap<Long, Set<ScheduleEntry>>();
    public static final ClientCache DATA_CACHE = new ClientCache(STATIONS, PLATFORMS, SIDINGS, ROUTES, DEPOTS, LIFTS);
    private static final Map<UUID, Integer> PLAYER_RIDING_COOL_DOWN = new HashMap<UUID, Integer>();

    public static void tick() {
        HashSet playersToRemove = new HashSet();
        PLAYER_RIDING_COOL_DOWN.forEach((uuid, coolDown) -> {
            if (coolDown <= 0) {
                playersToRemove.add(uuid);
            }
            PLAYER_RIDING_COOL_DOWN.put((UUID)uuid, coolDown - 1);
        });
        playersToRemove.forEach(PLAYER_RIDING_COOL_DOWN::remove);
        boolean tempPressingAccelerate = KeyMappings.TRAIN_ACCELERATE.m_90857_();
        boolean tempPressingBrake = KeyMappings.TRAIN_BRAKE.m_90857_();
        boolean tempPressingDoors = KeyMappings.TRAIN_TOGGLE_DOORS.m_90857_();
        PacketTrainDataGuiClient.sendDriveTrainC2S(tempPressingAccelerate && !pressingAccelerate, tempPressingBrake && !pressingBrake, tempPressingDoors && !pressingDoors);
        pressingAccelerate = tempPressingAccelerate;
        pressingBrake = tempPressingBrake;
        pressingDoors = tempPressingDoors;
        Minecraft minecraftClient = Minecraft.m_91087_();
        LocalPlayer player = minecraftClient.f_91074_;
        if (player != null) {
            shiftHoldingTicks = player.m_6144_() ? (shiftHoldingTicks += MTRClient.getLastFrameDuration()) : 0.0f;
        }
    }

    public static void writeRails(Minecraft client, FriendlyByteBuf packet) {
        HashMap railsTemp = new HashMap();
        int railsCount = packet.readInt();
        for (int i = 0; i < railsCount; ++i) {
            BlockPos startPos = packet.m_130135_();
            HashMap<BlockPos, Rail> railMap = new HashMap<BlockPos, Rail>();
            int railCount = packet.readInt();
            for (int j = 0; j < railCount; ++j) {
                railMap.put(packet.m_130135_(), new Rail(packet));
            }
            railsTemp.put(startPos, railMap);
        }
        client.execute(() -> ClientData.clearAndAddAll(RAILS, railsTemp));
    }

    public static void updateTrains(Minecraft client, FriendlyByteBuf packet) {
        HashSet<TrainClient> trainsToUpdate = new HashSet<TrainClient>();
        while (packet.isReadable()) {
            trainsToUpdate.add(new TrainClient(packet));
        }
        client.execute(() -> trainsToUpdate.forEach(newTrain -> {
            TrainClient existingTrain = ClientData.getTrainById(newTrain.id);
            if (existingTrain == null) {
                TRAINS.add((TrainClient)newTrain);
            } else {
                existingTrain.copyFromTrain((Train)newTrain);
            }
        }));
    }

    public static void deleteTrains(Minecraft client, FriendlyByteBuf packet) {
        HashSet<Long> trainIdsToKeep = new HashSet<Long>();
        int trainsCount = packet.readInt();
        for (int i = 0; i < trainsCount; ++i) {
            trainIdsToKeep.add(packet.readLong());
        }
        client.execute(() -> {
            TRAINS.forEach(trainClient -> {
                if (!trainIdsToKeep.contains(trainClient.id)) {
                    trainClient.isRemoved = true;
                }
            });
            TRAINS.removeIf(trainClient -> trainClient.isRemoved);
        });
    }

    public static void updateLifts(Minecraft client, FriendlyByteBuf packet) {
        HashSet<LiftClient> liftsToUpdate = new HashSet<LiftClient>();
        while (packet.isReadable()) {
            liftsToUpdate.add(new LiftClient(packet));
        }
        client.execute(() -> liftsToUpdate.forEach(newLift -> {
            LiftClient existingLift = ClientData.DATA_CACHE.liftsClientIdMap.get(newLift.id);
            if (existingLift == null) {
                LIFTS.add((LiftClient)newLift);
                DATA_CACHE.syncLiftIds();
            } else {
                existingLift.copyFromLift((LiftClient)newLift);
            }
        }));
    }

    public static void deleteLifts(Minecraft client, FriendlyByteBuf packet) {
        HashSet<Long> liftIdsToKeep = new HashSet<Long>();
        int liftsCount = packet.readInt();
        for (int i = 0; i < liftsCount; ++i) {
            liftIdsToKeep.add(packet.readLong());
        }
        client.execute(() -> {
            HashSet liftsToRemove = new HashSet();
            LIFTS.forEach(lift -> {
                if (!liftIdsToKeep.contains(lift.id)) {
                    liftsToRemove.add(lift);
                }
            });
            liftsToRemove.forEach(LIFTS::remove);
            DATA_CACHE.syncLiftIds();
        });
    }

    public static void updateTrainPassengers(Minecraft client, FriendlyByteBuf packet) {
        TrainClient train = ClientData.getTrainById(packet.readLong());
        float percentageX = packet.readFloat();
        float percentageZ = packet.readFloat();
        UUID uuid = packet.m_130259_();
        if (train != null) {
            client.execute(() -> train.startRidingClient(uuid, percentageX, percentageZ));
        }
    }

    public static void updateTrainPassengerPosition(Minecraft client, FriendlyByteBuf packet) {
        TrainClient train = ClientData.getTrainById(packet.readLong());
        float percentageX = packet.readFloat();
        float percentageZ = packet.readFloat();
        UUID uuid = packet.m_130259_();
        if (train != null) {
            client.execute(() -> train.updateRiderPercentages(uuid, percentageX, percentageZ));
        }
    }

    public static void updateLiftPassengers(Minecraft client, FriendlyByteBuf packet) {
        LiftClient lift = ClientData.DATA_CACHE.liftsClientIdMap.get(packet.readLong());
        float percentageX = packet.readFloat();
        float percentageZ = packet.readFloat();
        UUID uuid = packet.m_130259_();
        if (lift != null) {
            client.execute(() -> lift.startRidingClient(uuid, percentageX, percentageZ));
        }
    }

    public static void updateLiftPassengerPosition(Minecraft client, FriendlyByteBuf packet) {
        LiftClient lift = ClientData.DATA_CACHE.liftsClientIdMap.get(packet.readLong());
        float percentageX = packet.readFloat();
        float percentageZ = packet.readFloat();
        UUID uuid = packet.m_130259_();
        if (lift != null) {
            client.execute(() -> lift.updateRiderPercentages(uuid, percentageX, percentageZ));
        }
    }

    public static void updateRailActions(Minecraft client, FriendlyByteBuf packet) {
        ArrayList<DataConverter> railActions = new ArrayList<DataConverter>();
        int actionCount = packet.readInt();
        for (int i = 0; i < actionCount; ++i) {
            long id = packet.readLong();
            String player = packet.m_130277_();
            float length = packet.readFloat();
            String block = Text.translatable(packet.m_130277_(), new Object[0]).getString();
            String name = Text.translatable("gui.mtr." + packet.m_130277_(), player, Float.valueOf(length), block).getString();
            int color = packet.readInt();
            railActions.add(new DataConverter(id, name, color));
        }
        client.execute(() -> {
            RAIL_ACTIONS.clear();
            RAIL_ACTIONS.addAll(railActions);
        });
    }

    public static void updateSchedule(Minecraft client, FriendlyByteBuf packet) {
        HashMap tempSchedulesForPlatform = new HashMap();
        int platformCount = packet.readInt();
        for (int i = 0; i < platformCount; ++i) {
            long platformId = packet.readLong();
            int scheduleCount = packet.readInt();
            for (int j = 0; j < scheduleCount; ++j) {
                if (!tempSchedulesForPlatform.containsKey(platformId)) {
                    tempSchedulesForPlatform.put(platformId, new HashSet());
                }
                ((Set)tempSchedulesForPlatform.get(platformId)).add(new ScheduleEntry(packet));
            }
        }
        HashMap<Long, Boolean> signalBlockStatus = new HashMap<Long, Boolean>();
        int signalBlockCount = packet.readInt();
        for (int i = 0; i < signalBlockCount; ++i) {
            signalBlockStatus.put(packet.readLong(), packet.readBoolean());
        }
        HashMap<UUID, Boolean> occupiedRails = new HashMap<UUID, Boolean>();
        int occupiedRailsCount = packet.readInt();
        for (int i = 0; i < occupiedRailsCount; ++i) {
            occupiedRails.put(packet.m_130259_(), packet.readBoolean());
        }
        client.execute(() -> {
            ClientData.clearAndAddAll(SCHEDULES_FOR_PLATFORM, tempSchedulesForPlatform);
            SIGNAL_BLOCKS.writeSignalBlockStatus(signalBlockStatus);
            OCCUPIED_RAILS.clear();
            OCCUPIED_RAILS.putAll(occupiedRails);
        });
    }

    public static void receivePacket(FriendlyByteBuf packet) {
        FriendlyByteBuf packetCopy = new FriendlyByteBuf(packet.copy());
        ClientData.clearAndAddAll(STATIONS, ClientData.deserializeData(packetCopy, Station::new));
        ClientData.clearAndAddAll(PLATFORMS, ClientData.deserializeData(packetCopy, Platform::new));
        ClientData.clearAndAddAll(SIDINGS, ClientData.deserializeData(packetCopy, Siding::new));
        ClientData.clearAndAddAll(ROUTES, ClientData.deserializeData(packetCopy, Route::new));
        ClientData.clearAndAddAll(DEPOTS, ClientData.deserializeData(packetCopy, Depot::new));
        ClientData.clearAndAddAll(LIFTS, ClientData.deserializeData(packetCopy, LiftClient::new));
        ClientData.clearAndAddAll(ClientData.SIGNAL_BLOCKS.signalBlocks, ClientData.deserializeData(packetCopy, SignalBlocks.SignalBlock::new));
        TRAINS.clear();
        DATA_CACHE.sync();
        DATA_CACHE.refreshDynamicResources();
        SIGNAL_BLOCKS.writeCache();
    }

    public static <T extends NameColorDataBase> Set<T> getFilteredDataSet(TransportMode transportMode, Set<T> dataSet) {
        HashSet returnData = new HashSet();
        dataSet.forEach(data -> {
            if (data.isTransportMode(transportMode)) {
                returnData.add(data);
            }
        });
        return returnData;
    }

    public static void updatePlayerRidingOffset(UUID uuid) {
        PLAYER_RIDING_COOL_DOWN.put(uuid, 2);
    }

    public static boolean isRiding(UUID uuid) {
        return PLAYER_RIDING_COOL_DOWN.containsKey(uuid);
    }

    public static boolean hasPermission() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        ClientPacketListener clientPacketListener = Minecraft.m_91087_().m_91403_();
        if (clientPacketListener == null) {
            return false;
        }
        PlayerInfo playerInfo = clientPacketListener.m_104949_(player.m_20148_());
        if (playerInfo == null) {
            return false;
        }
        return RailwayData.hasPermission(playerInfo.m_105325_());
    }

    public static float getShiftHoldingTicks() {
        return shiftHoldingTicks;
    }

    private static <T extends SerializedDataBase> Set<T> deserializeData(FriendlyByteBuf packet, Function<FriendlyByteBuf, T> supplier) {
        HashSet<SerializedDataBase> objects = new HashSet<SerializedDataBase>();
        int dataCount = packet.readInt();
        for (int i = 0; i < dataCount; ++i) {
            objects.add((SerializedDataBase)supplier.apply(packet));
        }
        return objects;
    }

    private static <U> void clearAndAddAll(Collection<U> target, Collection<U> source) {
        target.clear();
        target.addAll(source);
    }

    private static <U, V> void clearAndAddAll(Map<U, V> target, Map<U, V> source) {
        target.clear();
        target.putAll(source);
    }

    private static TrainClient getTrainById(long id) {
        try {
            return TRAINS.stream().filter(item -> item.id == id).findFirst().orElse(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

