/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.function.Consumer;
import mtr.Items;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IBlock {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final EnumProperty<EnumThird> THIRD = EnumProperty.m_61587_((String)"third", EnumThird.class);
    public static final EnumProperty<EnumSide> SIDE_EXTENDED = EnumProperty.m_61587_((String)"side", EnumSide.class);
    public static final EnumProperty<EnumSide> SIDE = EnumProperty.m_61594_((String)"side", EnumSide.class, side -> side != EnumSide.MIDDLE && side != EnumSide.SINGLE);

    default public <T extends Comparable<T>> void propagate(Level world, BlockPos pos, Direction direction, Property<T> property, int maxBlocksAway) {
        Object originalPropertyValue = IBlock.getStatePropertySafe((BlockGetter)world, pos, property);
        this.propagate(world, pos, direction, (BlockPos offsetPos) -> world.m_46597_(offsetPos, (BlockState)world.m_8055_(offsetPos).m_61124_(property, originalPropertyValue)), maxBlocksAway);
    }

    default public void propagate(Level world, BlockPos pos, Direction direction, Consumer<BlockPos> callback, int maxBlocksAway) {
        for (int i = 1; i <= maxBlocksAway; ++i) {
            BlockPos offsetPos = pos.m_5484_(direction, i);
            if (this != world.m_8055_(offsetPos).m_60734_()) continue;
            callback.accept(offsetPos);
            this.propagate(world, offsetPos, direction, callback, maxBlocksAway);
            return;
        }
    }

    public static InteractionResult checkHoldingBrush(Level world, Player player, Runnable callbackBrush, Runnable callbackNoBrush) {
        return IBlock.checkHoldingItem(world, player, item -> callbackBrush.run(), callbackNoBrush, Items.BRUSH.get());
    }

    public static InteractionResult checkHoldingItem(Level world, Player player, Consumer<Item> callbackItem, Runnable callbackNoItem, Item ... items) {
        Item holdingItem = null;
        for (Item item : items) {
            if (!player.m_21055_(item)) continue;
            holdingItem = item;
            break;
        }
        if (holdingItem != null) {
            if (!world.f_46443_) {
                callbackItem.accept(holdingItem);
            }
            return InteractionResult.SUCCESS;
        }
        if (callbackNoItem == null) {
            return InteractionResult.FAIL;
        }
        if (!world.f_46443_) {
            callbackNoItem.run();
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult checkHoldingBrush(Level world, Player player, Runnable callbackBrush) {
        return IBlock.checkHoldingBrush(world, player, callbackBrush, null);
    }

    public static VoxelShape getVoxelShapeByDirection(double x1, double y1, double z1, double x2, double y2, double z2, Direction facing) {
        switch (facing) {
            case NORTH: {
                return Block.m_49796_((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            case EAST: {
                return Block.m_49796_((double)(16.0 - z2), (double)y1, (double)x1, (double)(16.0 - z1), (double)y2, (double)x2);
            }
            case SOUTH: {
                return Block.m_49796_((double)(16.0 - x2), (double)y1, (double)(16.0 - z2), (double)(16.0 - x1), (double)y2, (double)(16.0 - z1));
            }
            case WEST: {
                return Block.m_49796_((double)z1, (double)y1, (double)(16.0 - x2), (double)z2, (double)y2, (double)(16.0 - x1));
            }
        }
        return Shapes.m_83144_();
    }

    public static boolean isReplaceable(BlockPlaceContext ctx, Direction direction, int totalLength) {
        for (int i = 0; i < totalLength; ++i) {
            if (ctx.m_43725_().m_8055_(ctx.m_8083_().m_5484_(direction, i)).m_60629_(ctx)) continue;
            return false;
        }
        return true;
    }

    public static void onBreakCreative(Level world, Player player, BlockPos pos) {
        if (!world.f_46443_ && (player == null || player.m_7500_())) {
            world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
            BlockState state = world.m_8055_(pos);
            world.m_5898_(player, 2001, pos, Block.m_49956_((BlockState)state));
        }
    }

    public static Direction getSideDirection(BlockState state) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, HorizontalDirectionalBlock.f_54117_);
        return IBlock.getStatePropertySafe(state, SIDE) == EnumSide.LEFT ? facing.m_122427_() : facing.m_122428_();
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(BlockGetter world, BlockPos pos, Property<T> property) {
        return IBlock.getStatePropertySafe(world.m_8055_(pos), property);
    }

    public static <T extends Comparable<T>> T getStatePropertySafe(BlockState state, Property<T> property) {
        Comparable defaultProperty = (Comparable)property.m_6908_().toArray()[0];
        try {
            return (T)(state.m_61138_(property) ? state.m_61143_(property) : defaultProperty);
        }
        catch (Exception exception) {
            return (T)defaultProperty;
        }
    }

    public static enum EnumSide implements StringRepresentable
    {
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        SINGLE("single");

        private final String name;

        private EnumSide(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }

    public static enum EnumThird implements StringRepresentable
    {
        LOWER("lower"),
        MIDDLE("middle"),
        UPPER("upper");

        private final String name;

        private EnumThird(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

