/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mtr.BlockEntityTypes;
import mtr.block.BlockTrainPoweredSensorBase;
import mtr.block.BlockTrainSensorBase;
import mtr.block.IBlock;
import mtr.data.RailwayData;
import mtr.data.ScheduleEntry;
import mtr.mappings.BlockEntityMapper;
import mtr.mappings.TickableMapper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockTrainScheduleSensor
extends BlockTrainPoweredSensorBase {
    @Override
    public BlockEntityMapper createBlockEntity(BlockPos pos, BlockState state) {
        return new TileEntityTrainScheduleSensor(pos, state);
    }

    @Override
    public <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
        TileEntityTrainScheduleSensor.tick(world, pos, blockEntity);
    }

    @Override
    public BlockEntityType<? extends BlockEntityMapper> getType() {
        return BlockEntityTypes.TRAIN_SCHEDULE_SENSOR_TILE_ENTITY.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public static class TileEntityTrainScheduleSensor
    extends BlockTrainSensorBase.TileEntityTrainSensorBase
    implements TickableMapper {
        private int seconds = 10;
        private static final String KEY_SECONDS = "seconds";

        public TileEntityTrainScheduleSensor(BlockPos pos, BlockState state) {
            super(BlockEntityTypes.TRAIN_SCHEDULE_SENSOR_TILE_ENTITY.get(), pos, state);
        }

        @Override
        public void tick() {
            if (this.f_58857_ != null) {
                TileEntityTrainScheduleSensor.tick(this.f_58857_, this.f_58858_, this);
            }
        }

        @Override
        public void readCompoundTag(CompoundTag compoundTag) {
            this.seconds = compoundTag.m_128451_(KEY_SECONDS);
            super.readCompoundTag(compoundTag);
        }

        @Override
        public void writeCompoundTag(CompoundTag compoundTag) {
            compoundTag.m_128405_(KEY_SECONDS, this.seconds);
            super.writeCompoundTag(compoundTag);
        }

        @Override
        public void setData(Set<Long> filterRouteIds, boolean stoppedOnly, boolean movingOnly, int number, String ... strings) {
            this.seconds = number;
            this.setData(filterRouteIds, stoppedOnly, movingOnly);
        }

        public int getSeconds() {
            return this.seconds;
        }

        public static <T extends BlockEntityMapper> void tick(Level world, BlockPos pos, T blockEntity) {
            if (world != null && !world.f_46443_) {
                boolean isActive;
                BlockState state = world.m_8055_(pos);
                Block block = state.m_60734_();
                boolean bl = isActive = (Integer)IBlock.getStatePropertySafe(state, BlockTrainPoweredSensorBase.POWERED) > 1 && world.m_183326_().m_183582_(pos, (Object)block);
                if (isActive || !(block instanceof BlockTrainScheduleSensor) || !(blockEntity instanceof TileEntityTrainScheduleSensor)) {
                    return;
                }
                RailwayData railwayData = RailwayData.getInstance(world);
                if (railwayData == null) {
                    return;
                }
                long platformId = RailwayData.getClosePlatformId(railwayData.platforms, railwayData.dataCache, pos, 4, 4, 0);
                if (platformId == 0L) {
                    return;
                }
                List<ScheduleEntry> schedules = railwayData.getSchedulesAtPlatform(platformId);
                if (schedules == null) {
                    return;
                }
                ArrayList scheduleList = new ArrayList();
                schedules.forEach(scheduleEntry -> {
                    if (((TileEntityTrainScheduleSensor)blockEntity).matchesFilter(scheduleEntry.routeId, -1.0f)) {
                        scheduleList.add(scheduleEntry);
                    }
                });
                if (!scheduleList.isEmpty()) {
                    Collections.sort(scheduleList);
                    if ((((ScheduleEntry)scheduleList.get((int)0)).arrivalMillis - System.currentTimeMillis()) / 1000L == (long)((TileEntityTrainScheduleSensor)blockEntity).seconds) {
                        ((BlockTrainScheduleSensor)block).power(world, state, pos);
                    }
                }
            }
        }
    }
}

