/*
 * Decompiled with CFR 0.152.
 */
package mtr.block;

import mtr.SoundEvents;
import mtr.block.BlockDirectionalDoubleBlockBase;
import mtr.block.IBlock;
import mtr.data.TicketSystem;
import mtr.mappings.Utilities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockTicketProcessor
extends BlockDirectionalDoubleBlockBase {
    public boolean hasLight;
    public boolean canEnter;
    public boolean canExit;
    public static final EnumProperty<EnumTicketProcessorLights> LIGHTS = EnumProperty.m_61587_((String)"lights", EnumTicketProcessorLights.class);

    public BlockTicketProcessor(boolean hasLight, boolean canEnter, boolean canExit) {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76419_).m_60999_().m_60978_(2.0f).m_60953_(state -> 5).m_60955_());
        this.hasLight = hasLight;
        this.canEnter = canEnter;
        this.canExit = canExit;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!world.f_46443_ && IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            TicketSystem.EnumTicketBarrierOpen open = TicketSystem.passThrough(world, pos, player, this.canEnter, this.canExit, SoundEvents.TICKET_PROCESSOR_ENTRY, SoundEvents.TICKET_PROCESSOR_ENTRY_CONCESSIONARY, SoundEvents.TICKET_PROCESSOR_EXIT, SoundEvents.TICKET_PROCESSOR_EXIT_CONCESSIONARY, SoundEvents.TICKET_PROCESSOR_FAIL, true);
            world.m_46597_(pos, (BlockState)state.m_61124_(LIGHTS, (Comparable)((Object)(open.isOpen() ? EnumTicketProcessorLights.GREEN : EnumTicketProcessorLights.RED))));
            Utilities.scheduleBlockTick(world, pos, (Block)this, 20);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void tick(BlockState state, ServerLevel world, BlockPos pos) {
        if (this.hasLight) {
            world.m_46597_(pos, (BlockState)state.m_61124_(LIGHTS, (Comparable)((Object)EnumTicketProcessorLights.NONE)));
        }
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        Direction facing = (Direction)IBlock.getStatePropertySafe(state, f_54117_);
        if (IBlock.getStatePropertySafe(state, HALF) == DoubleBlockHalf.UPPER) {
            return Shapes.m_83110_((VoxelShape)IBlock.getVoxelShapeByDirection(4.75, 1.0, 0.0, 11.25, 13.0, 8.0, facing), (VoxelShape)IBlock.getVoxelShapeByDirection(7.0, 0.0, 2.0, 9.0, 1.0, 4.0, facing));
        }
        return Shapes.m_83110_((VoxelShape)IBlock.getVoxelShapeByDirection(5.0, 0.0, 0.0, 11.0, 1.0, 6.0, facing), (VoxelShape)IBlock.getVoxelShapeByDirection(7.0, 1.0, 2.0, 9.0, 16.0, 4.0, facing));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HALF, LIGHTS});
    }

    public static enum EnumTicketProcessorLights implements StringRepresentable
    {
        NONE("none"),
        RED("red"),
        YELLOW_GREEN("yellow_green"),
        GREEN("green");

        private final String name;

        private EnumTicketProcessorLights(String nameIn) {
            this.name = nameIn;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

